/*
 * Decompiled with CFR 0.152.
 */
package auction.model;

import auction.model.Category;
import auction.model.Item;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.ForeignKey;

@Entity
@org.hibernate.annotations.Entity(mutable=false)
@Table(name="CATEGORIZED_ITEM")
public class CategorizedItem
implements Serializable,
Comparable {
    @EmbeddedId
    private Id id;
    @Column(name="ADDED_BY_USER", nullable=false, length=16)
    private String username;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ADDED_ON")
    private Date dateAdded = new Date();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ITEM_ID", insertable=false, updatable=false)
    @ForeignKey(name="FK_CATEGORIZED_ITEM_ITEM_ID")
    private Item item;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CATEGORY_ID", insertable=false, updatable=false)
    @ForeignKey(name="FK_CATEGORIZED_ITEM_CATEGORY_ID")
    private Category category;

    public CategorizedItem() {
    }

    public CategorizedItem(String string, Category category, Item item) {
        this.username = string;
        this.category = category;
        this.item = item;
        this.id = new Id(category.getId(), item.getId());
        category.getCategorizedItems().add(this);
        item.getCategorizedItems().add(this);
    }

    public Id getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public Category getCategory() {
        return this.category;
    }

    public Item getItem() {
        return this.item;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CategorizedItem categorizedItem = (CategorizedItem)object;
        return this.id.equals(categorizedItem.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public int compareTo(Object object) {
        if (object instanceof CategorizedItem) {
            return this.getDateAdded().compareTo(((CategorizedItem)object).getDateAdded());
        }
        return 0;
    }

    public String toString() {
        return "Added by: '" + this.getUsername() + "', " + "On Date: '" + this.getDateAdded();
    }

    @Embeddable
    public static class Id
    implements Serializable {
        @Column(name="CATEGORY_ID")
        private Long categoryId;
        @Column(name="ITEM_ID")
        private Long itemId;

        public Id() {
        }

        public Id(Long l, Long l2) {
            this.categoryId = l;
            this.itemId = l2;
        }

        public boolean equals(Object object) {
            if (object instanceof Id) {
                Id id = (Id)object;
                return this.categoryId.equals(id.categoryId) && this.itemId.equals(id.itemId);
            }
            return false;
        }

        public int hashCode() {
            return this.categoryId.hashCode() + this.itemId.hashCode();
        }
    }
}

