/*
 * Decompiled with CFR 0.152.
 */
package auction.model;

import auction.model.Item;
import auction.model.Rating;
import auction.model.User;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.ForeignKey;

@Entity
@Table(name="COMMENT")
public class Comment
implements Serializable,
Comparable {
    @Id
    @GeneratedValue
    @Column(name="COMMENT_ID")
    private Long id = null;
    @Version
    @Column(name="OBJ_VERSION")
    private int version = 0;
    @Enumerated(value=EnumType.STRING)
    @Column(name="RATING", nullable=false, updatable=false)
    private Rating rating;
    @Column(name="COMMENT_TEXT", length=4000, nullable=true)
    private String text;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="FROM_USER_ID", nullable=false, updatable=false)
    @ForeignKey(name="FK_FROM_USER_ID")
    private User fromUser;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ABOUT_ITEM_ID", nullable=false, updatable=false)
    @ForeignKey(name="FK_ABOUT_ITEM_ID")
    private Item item;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED", nullable=false, updatable=false)
    private Date created = new Date();

    public Comment() {
    }

    public Comment(Rating rating, String string, User user, Item item) {
        this.rating = rating;
        this.text = string;
        this.fromUser = user;
        this.item = item;
    }

    public Long getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public Rating getRating() {
        return this.rating;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public User getFromUser() {
        return this.fromUser;
    }

    public Item getItem() {
        return this.item;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Comment)) {
            return false;
        }
        Comment comment = (Comment)object;
        if (this.created.getTime() != comment.created.getTime()) {
            return false;
        }
        if (!this.rating.equals((Object)comment.rating)) {
            return false;
        }
        return !(this.text != null ? !this.text.equals(comment.text) : comment.text != null);
    }

    public int hashCode() {
        int n = this.rating.hashCode();
        n = 29 * n + (this.text != null ? this.text.hashCode() : 0);
        n = 29 * n + this.created.hashCode();
        return n;
    }

    public String toString() {
        return "Comment ('" + this.getId() + "'), " + "Rating: '" + (Object)((Object)this.getRating()) + "'";
    }

    public int compareTo(Object object) {
        if (object instanceof Comment) {
            return Long.valueOf(this.getCreated().getTime()).compareTo(((Comment)object).getCreated().getTime());
        }
        return 0;
    }
}

