/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.observables.ConnectableObservable;
import rx.subjects.Subject;

public class OperationMulticast {
    public static <T, R> ConnectableObservable<R> multicast(Observable<? extends T> source, Subject<? super T, ? extends R> subject) {
        return new MulticastConnectableObservable<T, R>(source, subject);
    }

    private static class MulticastConnectableObservable<T, R>
    extends ConnectableObservable<R> {
        private final Object lock = new Object();
        private final Observable<? extends T> source;
        private final Subject<? super T, ? extends R> subject;
        private Subscription subscription;

        public MulticastConnectableObservable(Observable<? extends T> source, final Subject<? super T, ? extends R> subject) {
            super(new Observable.OnSubscribeFunc<R>(){

                @Override
                public Subscription onSubscribe(Observer<? super R> observer) {
                    return subject.subscribe(observer);
                }
            });
            this.source = source;
            this.subject = subject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Subscription connect() {
            Object object = this.lock;
            synchronized (object) {
                if (this.subscription == null) {
                    this.subscription = this.source.subscribe(new Observer<T>(){

                        @Override
                        public void onCompleted() {
                            MulticastConnectableObservable.this.subject.onCompleted();
                        }

                        @Override
                        public void onError(Throwable e) {
                            MulticastConnectableObservable.this.subject.onError(e);
                        }

                        @Override
                        public void onNext(T args) {
                            MulticastConnectableObservable.this.subject.onNext(args);
                        }
                    });
                }
            }
            return new Subscription(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void unsubscribe() {
                    Object object = MulticastConnectableObservable.this.lock;
                    synchronized (object) {
                        if (MulticastConnectableObservable.this.subscription != null) {
                            MulticastConnectableObservable.this.subscription.unsubscribe();
                            MulticastConnectableObservable.this.subscription = null;
                        }
                    }
                }
            };
        }
    }
}

