/*
 * Decompiled with CFR 0.152.
 */
package cocaine.message;

import cocaine.message.Message;
import cocaine.message.MessageType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public final class TerminateMessage
extends Message {
    private final Reason reason;
    private final String message;

    public TerminateMessage(Reason reason, String message) {
        super(MessageType.TERMINATE);
        this.reason = Preconditions.checkNotNull(reason, "Termination reason can not be null");
        this.message = Preconditions.checkNotNull(message, "Message can not be null");
    }

    public Reason getReason() {
        return this.reason;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "TerminateMessage/" + this.getSession() + ": " + this.reason.name() + " - " + this.message;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TerminateMessage that = (TerminateMessage)o;
        return this.message.equals(that.message) && this.reason == that.reason;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.reason.hashCode();
        result = 31 * result + this.message.hashCode();
        return result;
    }

    public static enum Reason {
        NORMAL(1),
        ABNORMAL(2);

        private static final Map<Integer, Reason> mapping;
        private final int value;

        private Reason(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static Reason fromValue(int value) {
            Reason result = mapping.get(value);
            if (result == null) {
                throw new IllegalArgumentException("Reason " + value + " does not exist");
            }
            return result;
        }

        public static Function<Reason, Integer> valueF() {
            return new Function<Reason, Integer>(){

                @Override
                public Integer apply(Reason reason) {
                    return reason.value();
                }
            };
        }

        static {
            mapping = Maps.uniqueIndex(Arrays.asList(Reason.values()), Reason.valueF());
        }
    }
}

