/*
 * Decompiled with CFR 0.152.
 */
package cocaine.message;

import cocaine.message.Message;
import cocaine.message.MessageType;
import com.google.common.base.Preconditions;
import java.util.Arrays;

public final class ChunkMessage
extends Message {
    private final byte[] data;

    public ChunkMessage(long session, byte[] data) {
        super(MessageType.CHUNK, session);
        Preconditions.checkNotNull(data, "CHunk data can not be null");
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return "ChunkMessage/" + this.getSession() + ": " + Arrays.toString(this.data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChunkMessage that = (ChunkMessage)o;
        return Arrays.equals(this.data, that.data);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }
}

