/*
 * Decompiled with CFR 0.152.
 */
package cocaine;

import cocaine.ServiceException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import rx.Observable;
import rx.Observer;
import rx.subjects.ReplaySubject;

public final class Sessions {
    private static final Logger logger = Logger.getLogger(Sessions.class);
    private final AtomicLong counter;
    private final Map<Long, Observer<byte[]>> sessions;
    private final String service;

    public Sessions(String service) {
        this.service = service;
        this.counter = new AtomicLong(0L);
        this.sessions = new ConcurrentHashMap<Long, Observer<byte[]>>();
    }

    public Session create() {
        long id = this.counter.getAndIncrement();
        ReplaySubject subject = ReplaySubject.create();
        logger.debug("Creating new session: " + id);
        this.sessions.put(id, subject);
        return new Session(id, subject);
    }

    public void onChunk(long id, byte[] chunk) {
        Observer<byte[]> session = this.sessions.get(id);
        if (session != null) {
            logger.debug("Pushing new chunk " + Arrays.toString(chunk) + " to session " + id);
            session.onNext(chunk);
        } else {
            logger.warn("Session " + id + " does not exist");
        }
    }

    public void onCompleted(long id) {
        Observer<byte[]> session = this.sessions.remove(id);
        if (session != null) {
            logger.debug("Closing session " + id);
            session.onCompleted();
        } else {
            logger.warn("Session " + id + " does not exist");
        }
    }

    public void onError(long id, ServiceException exception) {
        Observer<byte[]> session = this.sessions.remove(id);
        if (session != null) {
            logger.debug("Setting error " + exception.getMessage() + " for session " + id);
            session.onError(exception);
        } else {
            logger.warn("Session " + id + " does not exist");
        }
    }

    public void onCompleted() {
        logger.debug("Closing all sessions of " + this.service);
        for (long session : this.sessions.keySet()) {
            this.onCompleted(session);
        }
    }

    public void onError(ServiceException exception) {
        logger.debug("Setting errors for all sessions of " + this.service);
        for (long session : this.sessions.keySet()) {
            this.onError(session, exception);
        }
    }

    public static final class Session {
        private final long id;
        private final Observable<byte[]> observable;

        private Session(long id, Observable<byte[]> observable) {
            this.id = id;
            this.observable = observable;
        }

        public long getId() {
            return this.id;
        }

        public Observable<byte[]> getObservable() {
            return this.observable;
        }
    }
}

