/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.operators.SafeObserver;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Func0;
import rx.util.functions.Func1;

public class OperationUsing {
    public static <T, RESOURCE extends Subscription> Observable.OnSubscribeFunc<T> using(final Func0<RESOURCE> resourceFactory, final Func1<RESOURCE, Observable<T>> observableFactory) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                Subscription resourceSubscription = Subscriptions.empty();
                try {
                    Subscription resource = (Subscription)resourceFactory.call();
                    if (resource != null) {
                        resourceSubscription = resource;
                    }
                    Observable observable = (Observable)observableFactory.call(resource);
                    SafeObservableSubscription subscription = new SafeObservableSubscription();
                    return subscription.wrap(new CompositeSubscription(observable.subscribe(new SafeObserver(subscription, observer)), resourceSubscription));
                }
                catch (Throwable e) {
                    resourceSubscription.unsubscribe();
                    return Observable.error(e).subscribe(observer);
                }
            }
        };
    }
}

