/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Func0;
import rx.util.functions.Func1;
import rx.util.functions.Functions;

public class OperationToMultimap {
    public static <T, K> Observable.OnSubscribeFunc<Map<K, Collection<T>>> toMultimap(Observable<T> source, Func1<? super T, ? extends K> keySelector) {
        return new ToMultimap(source, keySelector, Functions.identity(), new DefaultToMultimapFactory(), new DefaultMultimapCollectionFactory());
    }

    public static <T, K, V> Observable.OnSubscribeFunc<Map<K, Collection<V>>> toMultimap(Observable<T> source, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector) {
        return new ToMultimap<T, K, V>(source, keySelector, valueSelector, new DefaultToMultimapFactory(), new DefaultMultimapCollectionFactory());
    }

    public static <T, K, V> Observable.OnSubscribeFunc<Map<K, Collection<V>>> toMultimap(Observable<T> source, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, Collection<V>>> mapFactory) {
        return new ToMultimap<T, K, V>(source, keySelector, valueSelector, mapFactory, new DefaultMultimapCollectionFactory());
    }

    public static <T, K, V> Observable.OnSubscribeFunc<Map<K, Collection<V>>> toMultimap(Observable<T> source, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, Collection<V>>> mapFactory, Func1<? super K, ? extends Collection<V>> collectionFactory) {
        return new ToMultimap<T, K, V>(source, keySelector, valueSelector, mapFactory, collectionFactory);
    }

    public static class ToMultimap<T, K, V>
    implements Observable.OnSubscribeFunc<Map<K, Collection<V>>> {
        private final Observable<T> source;
        private final Func1<? super T, ? extends K> keySelector;
        private final Func1<? super T, ? extends V> valueSelector;
        private final Func0<? extends Map<K, Collection<V>>> mapFactory;
        private final Func1<? super K, ? extends Collection<V>> collectionFactory;

        public ToMultimap(Observable<T> source, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, Collection<V>>> mapFactory, Func1<? super K, ? extends Collection<V>> collectionFactory) {
            this.source = source;
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            this.mapFactory = mapFactory;
            this.collectionFactory = collectionFactory;
        }

        @Override
        public Subscription onSubscribe(Observer<? super Map<K, Collection<V>>> t1) {
            Map<K, Collection<V>> map;
            try {
                map = this.mapFactory.call();
            }
            catch (Throwable t) {
                t1.onError(t);
                return Subscriptions.empty();
            }
            return this.source.subscribe(new ToMultimapObserver<T, K, V>(t1, this.keySelector, this.valueSelector, map, this.collectionFactory));
        }

        public static class ToMultimapObserver<T, K, V>
        implements Observer<T> {
            private final Func1<? super T, ? extends K> keySelector;
            private final Func1<? super T, ? extends V> valueSelector;
            private final Func1<? super K, ? extends Collection<V>> collectionFactory;
            private Map<K, Collection<V>> map;
            private Observer<? super Map<K, Collection<V>>> t1;

            public ToMultimapObserver(Observer<? super Map<K, Collection<V>>> t1, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Map<K, Collection<V>> map, Func1<? super K, ? extends Collection<V>> collectionFactory) {
                this.t1 = t1;
                this.keySelector = keySelector;
                this.valueSelector = valueSelector;
                this.collectionFactory = collectionFactory;
                this.map = map;
            }

            @Override
            public void onNext(T args) {
                K key = this.keySelector.call(args);
                V value = this.valueSelector.call(args);
                Collection<V> collection = this.map.get(key);
                if (collection == null) {
                    collection = this.collectionFactory.call(key);
                    this.map.put(key, collection);
                }
                collection.add(value);
            }

            @Override
            public void onError(Throwable e) {
                this.map = null;
                this.t1.onError(e);
            }

            @Override
            public void onCompleted() {
                Map<K, Collection<V>> map0 = this.map;
                this.map = null;
                this.t1.onNext(map0);
                this.t1.onCompleted();
            }
        }
    }

    public static class DefaultMultimapCollectionFactory<K, V>
    implements Func1<K, Collection<V>> {
        @Override
        public Collection<V> call(K t1) {
            return new ArrayList();
        }
    }

    public static class DefaultToMultimapFactory<K, V>
    implements Func0<Map<K, Collection<V>>> {
        @Override
        public Map<K, Collection<V>> call() {
            return new HashMap();
        }
    }
}

