/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantLock;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;

public class OperationSkipLast {
    public static <T> Observable.OnSubscribeFunc<T> skipLast(Observable<? extends T> source, int count) {
        return new SkipLast(source, count);
    }

    private static class SkipLast<T>
    implements Observable.OnSubscribeFunc<T> {
        private final int count;
        private final Observable<? extends T> source;

        private SkipLast(Observable<? extends T> source, int count) {
            this.count = count;
            this.source = source;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            if (this.count < 0) {
                throw new IndexOutOfBoundsException("count could not be negative");
            }
            final SafeObservableSubscription subscription = new SafeObservableSubscription();
            return subscription.wrap(this.source.subscribe(new Observer<T>(){
                private final ReentrantLock lock = new ReentrantLock();
                private final Deque<T> deque = new LinkedList();

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    observer.onError(e);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNext(T value) {
                    if (SkipLast.this.count == 0) {
                        try {
                            observer.onNext(value);
                        }
                        catch (Throwable ex) {
                            observer.onError(ex);
                            subscription.unsubscribe();
                        }
                        return;
                    }
                    this.lock.lock();
                    try {
                        this.deque.offerLast(value);
                        if (this.deque.size() > SkipLast.this.count) {
                            observer.onNext(this.deque.removeFirst());
                        }
                    }
                    catch (Throwable ex) {
                        observer.onError(ex);
                        subscription.unsubscribe();
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }));
        }
    }
}

