/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.operators.SynchronizedObserver;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.SerialSubscription;
import rx.util.functions.Func2;
import rx.util.functions.Func3;
import rx.util.functions.Func4;
import rx.util.functions.Func5;
import rx.util.functions.Func6;
import rx.util.functions.Func7;
import rx.util.functions.Func8;
import rx.util.functions.Func9;
import rx.util.functions.FuncN;
import rx.util.functions.Functions;

public final class OperationZip {
    public static <T1, T2, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Func2<? super T1, ? super T2, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2), Functions.fromFunc(zipFunction));
    }

    public static <T1, T2, T3, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Func3<? super T1, ? super T2, ? super T3, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2, o3), Functions.fromFunc(zipFunction));
    }

    public static <T1, T2, T3, T4, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Func4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2, o3, o4), Functions.fromFunc(zipFunction));
    }

    public static <T1, T2, T3, T4, T5, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Func5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2, o3, o4, o5), Functions.fromFunc(zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Func6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2, o3, o4, o5, o6), Functions.fromFunc(zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Func7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2, o3, o4, o5, o6, o7), Functions.fromFunc(zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Func8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2, o3, o4, o5, o6, o7, o8), Functions.fromFunc(zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Observable<? extends T9> o9, Func9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2, o3, o4, o5, o6, o7, o8, o9), Functions.fromFunc(zipFunction));
    }

    public static <R> Observable.OnSubscribeFunc<R> zip(Iterable<? extends Observable<?>> ws, FuncN<? extends R> zipFunction) {
        ManyObservables a = new ManyObservables(ws, zipFunction);
        return a;
    }

    public static class ManyObservables<T, U>
    implements Observable.OnSubscribeFunc<U> {
        protected final Iterable<? extends Observable<? extends T>> sources;
        protected final FuncN<? extends U> selector;

        public ManyObservables(Iterable<? extends Observable<? extends T>> sources, FuncN<? extends U> selector) {
            this.sources = sources;
            this.selector = selector;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super U> observer) {
            CompositeSubscription composite = new CompositeSubscription(new Subscription[0]);
            ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
            ArrayList all = new ArrayList();
            Observer o2 = new Observer<List<T>>(){

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable t) {
                    observer.onError(t);
                }

                @Override
                public void onNext(List<T> value) {
                    observer.onNext(ManyObservables.this.selector.call(value.toArray(new Object[value.size()])));
                }
            };
            for (Observable<? extends T> observable : this.sources) {
                ItemObserver<? extends T> io = new ItemObserver<T>(rwLock, all, observable, o2, composite);
                composite.add(io);
                all.add(io);
            }
            for (ItemObserver itemObserver : all) {
                itemObserver.connect();
            }
            return composite;
        }

        public static class ItemObserver<T>
        implements Observer<T>,
        Subscription {
            protected final ReadWriteLock rwLock;
            public final Queue<Object> queue = new LinkedList<Object>();
            public final List<ItemObserver<T>> all;
            protected static final Object NULL_SENTINEL = new Object();
            protected final Subscription cancel;
            protected final SerialSubscription toSource = new SerialSubscription();
            protected boolean done;
            protected final Observable<? extends T> source;
            protected final Observer<? super List<T>> observer;

            public ItemObserver(ReadWriteLock rwLock, List<ItemObserver<T>> all, Observable<? extends T> source, Observer<? super List<T>> observer, Subscription cancel) {
                this.rwLock = rwLock;
                this.all = all;
                this.source = source;
                this.observer = observer;
                this.cancel = cancel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T value) {
                this.rwLock.readLock().lock();
                try {
                    if (this.done) {
                        return;
                    }
                    this.queue.add(value != null ? value : NULL_SENTINEL);
                }
                finally {
                    this.rwLock.readLock().unlock();
                }
                if (this.rwLock.writeLock().tryLock()) {
                    try {
                        while (true) {
                            ArrayList<Object> values = new ArrayList<Object>(this.all.size());
                            for (ItemObserver<T> io : this.all) {
                                if (io.queue.isEmpty()) {
                                    if (io.done) {
                                        this.observer.onCompleted();
                                        this.cancel.unsubscribe();
                                    }
                                    return;
                                }
                                Object v = io.queue.peek();
                                if (v == NULL_SENTINEL) {
                                    v = null;
                                }
                                values.add(v);
                            }
                            if (values.size() != this.all.size()) continue;
                            for (ItemObserver<T> io : this.all) {
                                io.queue.poll();
                            }
                            this.observer.onNext(values);
                        }
                    }
                    finally {
                        this.rwLock.writeLock().unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable ex) {
                boolean c = false;
                this.rwLock.writeLock().lock();
                try {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    c = true;
                    this.observer.onError(ex);
                    this.cancel.unsubscribe();
                }
                finally {
                    this.rwLock.writeLock().unlock();
                }
                if (c) {
                    this.unsubscribe();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                boolean c = false;
                this.rwLock.readLock().lock();
                try {
                    this.done = true;
                    c = true;
                }
                finally {
                    this.rwLock.readLock().unlock();
                }
                if (this.rwLock.writeLock().tryLock()) {
                    try {
                        for (ItemObserver<T> io : this.all) {
                            if (!io.queue.isEmpty() || !io.done) continue;
                            this.observer.onCompleted();
                            this.cancel.unsubscribe();
                            return;
                        }
                    }
                    finally {
                        this.rwLock.writeLock().unlock();
                    }
                }
                if (c) {
                    this.unsubscribe();
                }
            }

            public void connect() {
                this.toSource.setSubscription(this.source.subscribe(this));
            }

            @Override
            public void unsubscribe() {
                this.toSource.unsubscribe();
            }
        }
    }

    static class Aggregator<T>
    implements Observable.OnSubscribeFunc<T> {
        private volatile SynchronizedObserver<T> observer;
        private final FuncN<? extends T> zipFunction;
        private final AtomicBoolean started = new AtomicBoolean(false);
        private final AtomicBoolean running = new AtomicBoolean(true);
        private final ConcurrentHashMap<ZipObserver<T, ?>, Boolean> completed = new ConcurrentHashMap();
        private ConcurrentHashMap<ZipObserver<T, ?>, ConcurrentLinkedQueue<Object>> receivedValuesPerObserver = new ConcurrentHashMap();
        private ConcurrentLinkedQueue<ZipObserver<T, ?>> observers = new ConcurrentLinkedQueue();

        public Aggregator(FuncN<? extends T> zipFunction) {
            this.zipFunction = zipFunction;
        }

        void addObserver(ZipObserver<T, ?> w) {
            this.observers.add(w);
            this.receivedValuesPerObserver.put(w, new ConcurrentLinkedQueue());
        }

        void complete(ZipObserver<T, ?> w) {
            this.completed.put(w, Boolean.TRUE);
            if (this.completed.size() == this.observers.size() && this.running.compareAndSet(true, false)) {
                this.observer.onCompleted();
            }
        }

        void error(ZipObserver<T, ?> w, Throwable e) {
            if (this.running.compareAndSet(true, false)) {
                this.observer.onError(e);
                this.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next(ZipObserver<T, ?> w, Object arg) {
            if (this.observer == null) {
                throw new RuntimeException("This shouldn't be running if a Observer isn't registered");
            }
            if (!this.running.get()) {
                return;
            }
            this.receivedValuesPerObserver.get(w).add(arg);
            Object[] argsToZip = new Object[this.observers.size()];
            Aggregator aggregator = this;
            synchronized (aggregator) {
                for (ZipObserver rw : this.receivedValuesPerObserver.keySet()) {
                    if (this.receivedValuesPerObserver.get(rw).peek() != null) continue;
                    return;
                }
                int i = 0;
                for (ZipObserver<T, ?> rw : this.observers) {
                    argsToZip[i++] = this.receivedValuesPerObserver.get(rw).remove();
                }
            }
            this.observer.onNext(this.zipFunction.call(argsToZip));
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            if (this.started.compareAndSet(false, true)) {
                SafeObservableSubscription subscription = new SafeObservableSubscription();
                this.observer = new SynchronizedObserver<T>(observer, subscription);
                for (ZipObserver<T, ?> rw : this.observers) {
                    rw.startWatching();
                }
                return subscription.wrap(new Subscription(){

                    @Override
                    public void unsubscribe() {
                        Aggregator.this.stop();
                    }
                });
            }
            throw new IllegalStateException("Only one Observer can subscribe to this Observable.");
        }

        private void stop() {
            if (this.running.compareAndSet(true, false)) {
                for (ZipObserver<T, ?> o : this.observers) {
                    if (((ZipObserver)o).subscription == null) continue;
                    ((ZipObserver)o).subscription.unsubscribe();
                }
            }
        }
    }

    static class ZipObserver<R, T>
    implements Observer<T> {
        final Observable<? extends T> w;
        final Aggregator<R> a;
        private final SafeObservableSubscription subscription = new SafeObservableSubscription();
        private final AtomicBoolean subscribed = new AtomicBoolean(false);

        public ZipObserver(Aggregator<R> a, Observable<? extends T> w) {
            this.a = a;
            this.w = w;
        }

        public void startWatching() {
            if (this.subscribed.compareAndSet(false, true)) {
                this.subscription.wrap(this.w.subscribe(this));
            }
        }

        @Override
        public void onCompleted() {
            this.a.complete(this);
        }

        @Override
        public void onError(Throwable e) {
            this.a.error(this, e);
        }

        @Override
        public void onNext(T args) {
            try {
                this.a.next(this, args);
            }
            catch (Throwable e) {
                this.onError(e);
            }
        }
    }
}

