/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.util.functions.Func2;

public final class OperationSum {
    public static Observable<Integer> sum(Observable<Integer> source) {
        return source.reduce(0, new Func2<Integer, Integer, Integer>(){

            @Override
            public Integer call(Integer accu, Integer next) {
                return accu + next;
            }
        });
    }

    public static Observable<Long> sumLongs(Observable<Long> source) {
        return source.reduce(0L, new Func2<Long, Long, Long>(){

            @Override
            public Long call(Long accu, Long next) {
                return accu + next;
            }
        });
    }

    public static Observable<Float> sumFloats(Observable<Float> source) {
        return source.reduce(Float.valueOf(0.0f), new Func2<Float, Float, Float>(){

            @Override
            public Float call(Float accu, Float next) {
                return Float.valueOf(accu.floatValue() + next.floatValue());
            }
        });
    }

    public static Observable<Double> sumDoubles(Observable<Double> source) {
        return source.reduce(0.0, new Func2<Double, Double, Double>(){

            @Override
            public Double call(Double accu, Double next) {
                return accu + next;
            }
        });
    }
}

