/*
 * Decompiled with CFR 0.152.
 */
package cocaine.netty;

import cocaine.ServiceErrorException;
import cocaine.Sessions;
import cocaine.UnexpectedMessageException;
import cocaine.message.ChunkMessage;
import cocaine.message.ErrorMessage;
import cocaine.message.Message;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.log4j.Logger;

public class ServiceMessageHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = Logger.getLogger(ServiceMessageHandler.class);
    private final String service;
    private final Sessions sessions;

    public ServiceMessageHandler(String service, Sessions sessions) {
        this.service = service;
        this.sessions = sessions;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        logger.info("Handling message: " + msg);
        Message message = (Message)msg;
        long session = message.getSession();
        switch (message.getType()) {
            case CHUNK: {
                ChunkMessage chunk = (ChunkMessage)msg;
                this.sessions.onChunk(session, chunk.getData());
                break;
            }
            case CHOKE: {
                this.sessions.onCompleted(session);
                break;
            }
            case ERROR: {
                ErrorMessage error = (ErrorMessage)msg;
                this.sessions.onError(session, new ServiceErrorException(this.service, error.getMessage(), error.getCode()));
                break;
            }
            default: {
                this.sessions.onError(session, new UnexpectedMessageException(this.service, message));
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.sessions.onCompleted();
    }
}

