/*
 * Decompiled with CFR 0.152.
 */
package cocaine.message;

import cocaine.message.Message;
import cocaine.message.MessageType;
import com.google.common.base.Preconditions;

public final class ErrorMessage
extends Message {
    private final int code;
    private final String message;

    public ErrorMessage(long session, int code, String message) {
        super(MessageType.ERROR, session);
        this.code = code;
        this.message = Preconditions.checkNotNull(message, "Error message can not be null");
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "ErrorMessage/" + this.getSession() + ": " + this.code + " - " + this.message;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ErrorMessage that = (ErrorMessage)o;
        return this.code == that.code && this.message.equals(that.message);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.code;
        result = 31 * result + this.message.hashCode();
        return result;
    }
}

