/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.subjects.AbstractSubject;
import rx.util.functions.Action2;

public class AsyncSubject<T>
extends AbstractSubject<T> {
    private final AbstractSubject.SubjectState<T> state;

    public static <T> AsyncSubject<T> create() {
        AbstractSubject.SubjectState state = new AbstractSubject.SubjectState();
        Observable.OnSubscribeFunc onSubscribe = AsyncSubject.getOnSubscribeFunc(state, new Action2<AbstractSubject.SubjectState<T>, Observer<? super T>>(){

            @Override
            public void call(AbstractSubject.SubjectState<T> state, Observer<? super T> o) {
                Notification value;
                if (state.completed.get() && (value = state.currentValue.get()) != null && value.isOnNext()) {
                    o.onCompleted();
                }
            }
        });
        return new AsyncSubject(onSubscribe, state);
    }

    protected AsyncSubject(Observable.OnSubscribeFunc<T> onSubscribe, AbstractSubject.SubjectState<T> state) {
        super(onSubscribe);
        this.state = state;
    }

    @Override
    public void onCompleted() {
        this.emitNotificationAndTerminate(this.state, new Action2<AbstractSubject.SubjectState<T>, Observer<? super T>>(){

            @Override
            public void call(AbstractSubject.SubjectState<T> state, Observer<? super T> o) {
                o.onCompleted();
            }
        });
    }

    @Override
    public void onError(Throwable e) {
        this.state.currentValue.set(new Notification(e));
        this.emitNotificationAndTerminate(this.state, null);
    }

    @Override
    public void onNext(T v) {
        this.state.currentValue.set(new Notification<T>(v));
    }
}

