/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.subjects.AbstractSubject;
import rx.util.functions.Action2;

public class BehaviorSubject<T>
extends AbstractSubject<T> {
    private final AbstractSubject.SubjectState<T> state;

    public static <T> BehaviorSubject<T> createWithDefaultValue(T defaultValue) {
        return BehaviorSubject.create(defaultValue);
    }

    public static <T> BehaviorSubject<T> create(T defaultValue) {
        AbstractSubject.SubjectState state = new AbstractSubject.SubjectState();
        state.currentValue.set(new Notification<T>(defaultValue));
        Observable.OnSubscribeFunc onSubscribe = BehaviorSubject.getOnSubscribeFunc(state, new Action2<AbstractSubject.SubjectState<T>, Observer<? super T>>(){

            @Override
            public void call(AbstractSubject.SubjectState<T> state, Observer<? super T> o) {
                AbstractSubject.emitNotification(state.currentValue.get(), o);
            }
        });
        return new BehaviorSubject(onSubscribe, state);
    }

    protected BehaviorSubject(Observable.OnSubscribeFunc<T> onSubscribe, AbstractSubject.SubjectState<T> state) {
        super(onSubscribe);
        this.state = state;
    }

    @Override
    public void onCompleted() {
        this.state.currentValue.set(new Notification());
        this.emitNotificationAndTerminate(this.state, null);
    }

    @Override
    public void onError(Throwable e) {
        this.state.currentValue.set(new Notification(e));
        this.emitNotificationAndTerminate(this.state, null);
    }

    @Override
    public void onNext(T v) {
        this.state.currentValue.set(new Notification<T>(v));
        BehaviorSubject.emitNotification(this.state, null);
    }
}

