/*
 * Decompiled with CFR 0.152.
 */
package rx.joins;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observer;

public abstract class ObserverBase<T>
implements Observer<T> {
    private final AtomicBoolean completed = new AtomicBoolean();

    @Override
    public void onNext(T args) {
        if (!this.completed.get()) {
            this.onNextCore(args);
        }
    }

    @Override
    public void onError(Throwable e) {
        if (this.completed.compareAndSet(false, true)) {
            this.onErrorCore(e);
        }
    }

    @Override
    public void onCompleted() {
        if (this.completed.compareAndSet(false, true)) {
            this.onCompletedCore();
        }
    }

    protected abstract void onNextCore(T var1);

    protected abstract void onErrorCore(Throwable var1);

    protected abstract void onCompletedCore();

    protected boolean fail(Throwable t) {
        if (this.completed.compareAndSet(false, true)) {
            this.onErrorCore(t);
            return true;
        }
        return false;
    }
}

