/*
 * Decompiled with CFR 0.152.
 */
package rx.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CompositeException
extends RuntimeException {
    private static final long serialVersionUID = 3026362227162912146L;
    private final List<Throwable> exceptions;
    private final String message;

    public CompositeException(String messagePrefix, Collection<Throwable> errors) {
        StringBuilder _message = new StringBuilder();
        if (messagePrefix != null) {
            _message.append(messagePrefix).append(" => ");
        }
        ArrayList<Throwable> _exceptions = new ArrayList<Throwable>();
        for (Throwable e : errors) {
            _exceptions.add(e);
            if (_message.length() > 0) {
                _message.append(", ");
            }
            _message.append(e.getClass().getSimpleName()).append(":").append(e.getMessage());
        }
        this.exceptions = Collections.unmodifiableList(_exceptions);
        this.message = _message.toString();
    }

    public CompositeException(Collection<Throwable> errors) {
        this(null, errors);
    }

    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

