/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.subjects.Subject;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action2;

public abstract class AbstractSubject<T>
extends Subject<T, T> {
    protected AbstractSubject(Observable.OnSubscribeFunc<T> onSubscribe) {
        super(onSubscribe);
    }

    protected static <T> Observable.OnSubscribeFunc<T> getOnSubscribeFunc(final SubjectState<T> state, final Action2<SubjectState<T>, Observer<? super T>> onEach) {
        return new Observable.OnSubscribeFunc<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                state.SUBSCRIPTION_LOCK.lock();
                try {
                    if (state.completed.get()) {
                        AbstractSubject.emitNotification(state.currentValue.get(), observer);
                        if (onEach != null) {
                            onEach.call(state, observer);
                        }
                        Subscription subscription = Subscriptions.empty();
                        return subscription;
                    }
                    final SafeObservableSubscription subscription = new SafeObservableSubscription();
                    subscription.wrap(new Subscription(){

                        @Override
                        public void unsubscribe() {
                            state.observers.remove(subscription);
                        }
                    });
                    state.observers.put(subscription, observer);
                    if (onEach != null) {
                        onEach.call(state, observer);
                    }
                    SafeObservableSubscription safeObservableSubscription = subscription;
                    return safeObservableSubscription;
                }
                finally {
                    state.SUBSCRIPTION_LOCK.unlock();
                }
            }
        };
    }

    protected static <T> void emitNotification(Notification<T> value, Observer<? super T> observer) {
        if (value != null) {
            if (value.isOnNext()) {
                observer.onNext(value.getValue());
            } else if (value.isOnError()) {
                observer.onError(value.getThrowable());
            } else if (value.isOnCompleted()) {
                observer.onCompleted();
            }
        }
    }

    protected static <T> void emitNotification(SubjectState<T> state, Action2<SubjectState<T>, Observer<? super T>> onEach) {
        for (Subscription s : AbstractSubject.snapshotOfObservers(state)) {
            Observer o = state.observers.get(s);
            AbstractSubject.emitNotification(state.currentValue.get(), o);
            if (onEach == null) continue;
            onEach.call(state, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emitNotificationAndTerminate(SubjectState<T> state, Action2<SubjectState<T>, Observer<? super T>> onEach) {
        state.SUBSCRIPTION_LOCK.lock();
        try {
            if (state.completed.compareAndSet(false, true)) {
                for (Subscription s : AbstractSubject.snapshotOfObservers(state)) {
                    Observer o = state.observers.get(s);
                    AbstractSubject.emitNotification(state.currentValue.get(), o);
                    if (onEach != null) {
                        onEach.call(state, o);
                    }
                    state.observers.remove(s);
                }
            }
        }
        finally {
            state.SUBSCRIPTION_LOCK.unlock();
        }
    }

    private static <T> Collection<Subscription> snapshotOfObservers(SubjectState<T> state) {
        return new ArrayList<Subscription>(state.observers.keySet());
    }

    protected static class SubjectState<T> {
        protected final ConcurrentHashMap<Subscription, Observer<? super T>> observers = new ConcurrentHashMap();
        protected final AtomicReference<Notification<T>> currentValue = new AtomicReference();
        protected final AtomicBoolean completed = new AtomicBoolean();
        protected final ReentrantLock SUBSCRIPTION_LOCK = new ReentrantLock();

        protected SubjectState() {
        }
    }
}

