/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscription;

public class OperationLast {
    public static <T> Observable.OnSubscribeFunc<T> last(final Observable<? extends T> sequence) {
        return new Observable.OnSubscribeFunc<T>(){
            final AtomicReference<T> last = new AtomicReference();
            final AtomicBoolean hasLast = new AtomicBoolean(false);

            @Override
            public Subscription onSubscribe(final Observer<? super T> observer) {
                return sequence.subscribe(new Observer<T>(){

                    @Override
                    public void onCompleted() {
                        if (hasLast.get()) {
                            observer.onNext(last.get());
                            observer.onCompleted();
                        } else {
                            observer.onError(new IllegalArgumentException("Sequence contains no elements"));
                        }
                    }

                    @Override
                    public void onError(Throwable e) {
                        observer.onError(e);
                    }

                    @Override
                    public void onNext(T value) {
                        last.set(value);
                        hasLast.set(true);
                    }
                });
            }
        };
    }
}

