/*
 * Decompiled with CFR 0.152.
 */
package ru.cocainum;

import cocaine.Locator;
import cocaine.LocatorResolveException;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.lang.reflect.Array;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.msgpack.MessagePack;
import rx.observables.BlockingObservable;

public class Service {
    private static final Logger logger = Logger.getLogger(Service.class);

    private static <T> T[] concatenate(T[] A, T[] B) {
        int aLen = A.length;
        int bLen = B.length;
        Object[] C = (Object[])Array.newInstance(A.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(A, 0, C, 0, aLen);
        System.arraycopy(B, 0, C, aLen, bLen);
        return C;
    }

    public static String test(String tst_str) {
        return "test string - " + tst_str;
    }

    public static String getString(String service, String method, Object ... args) {
        String result = "";
        try (Locator locator = Locator.create();){
            cocaine.Service echo = locator.service(service);
            String[] m = new String[]{method};
            BlockingObservable<byte[]> response = echo.invoke("enqueue", Service.concatenate(m, args)).toBlockingObservable();
            logger.info("Got response");
            result = Service.unpack(response.toFuture().get(), String.class);
            logger.info("Got: " + result);
        }
        catch (LocatorResolveException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return result;
    }

    public static String[] getStringArray(String service, String method, Object ... args) {
        String[] results = new String[]{};
        try (Locator locator = Locator.create();){
            cocaine.Service echo = locator.service(service);
            String[] m = new String[]{method};
            BlockingObservable<byte[]> response = echo.invoke("enqueue", Service.concatenate(m, args)).toBlockingObservable();
            logger.info("Got response");
            results = Service.unpack(response.toFuture().get(), String[].class);
            for (int i = 0; i < results.length; ++i) {
                logger.info("Got: " + results[i]);
            }
            logger.info("After response: " + results.length);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return results;
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        System.out.println("Hello World!");
        String[] res = Service.getStringArray("DummyService", "write_dummy", "test string");
        System.out.println(res[0]);
        System.out.println(res[1]);
    }

    public static byte[] pack(long value) {
        try {
            return MessagePack.pack(value);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            throw Throwables.propagate(e);
        }
    }

    private static <T> T unpack(byte[] bytes, Class<T> type) {
        try {
            return (T)MessagePack.unpack(bytes, type);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            throw Throwables.propagate(e);
        }
    }
}

