/*
 * Decompiled with CFR 0.152.
 */
package cocaine;

import cocaine.CocaineException;
import cocaine.ServiceApi;
import cocaine.Sessions;
import cocaine.netty.ServiceMessageHandler;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.msgpack.MessagePackable;
import org.msgpack.packer.Packer;
import org.msgpack.unpacker.Unpacker;
import rx.Observable;

public class Service {
    private static final Logger logger = Logger.getLogger(Service.class);
    private final String name;
    private final ServiceApi api;
    private final Sessions sessions;
    private Channel channel;

    private Service(String name, ServiceApi api, Bootstrap bootstrap, Supplier<SocketAddress> endpoint) {
        this.name = name;
        this.sessions = new Sessions(name);
        this.api = api;
        this.connect(bootstrap, endpoint, new ServiceMessageHandler(name, this.sessions));
    }

    public static Service create(String name, Bootstrap bootstrap, Supplier<SocketAddress> endpoint, ServiceApi api) {
        return new Service(name, api, bootstrap, endpoint);
    }

    public Observable<byte[]> invoke(String method, Object ... args) {
        return this.invoke(method, Arrays.asList(args));
    }

    public Observable<byte[]> invoke(String method, List<Object> args) {
        logger.debug("Invoking " + method + "(" + Joiner.on(", ").join(args) + ") asynchronously");
        Sessions.Session session = this.sessions.create();
        int requestedMethod = this.api.getMethod(method);
        this.channel.write(new InvocationRequest(requestedMethod, session.getId(), args));
        return session.getObservable();
    }

    public String toString() {
        return this.name + "/" + this.channel.remoteAddress();
    }

    private void connect(final Bootstrap bootstrap, final Supplier<SocketAddress> endpoint, final ServiceMessageHandler handler) {
        try {
            this.channel = bootstrap.connect(endpoint.get()).sync().channel();
            this.channel.pipeline().addLast(handler);
            this.channel.closeFuture().addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    future.channel().eventLoop().schedule(new Runnable(){

                        @Override
                        public void run() {
                            if (!bootstrap.group().isShuttingDown()) {
                                Service.this.connect(bootstrap, endpoint, handler);
                            }
                        }
                    }, 2L, TimeUnit.SECONDS);
                }
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new CocaineException(e);
        }
    }

    private static class InvocationRequest
    implements MessagePackable {
        private final int method;
        private final long session;
        private final List<Object> args;

        public InvocationRequest(int method, long session, List<Object> args) {
            this.method = method;
            this.session = session;
            this.args = args;
        }

        @Override
        public void writeTo(Packer packer) throws IOException {
            packer.writeArrayBegin(3);
            packer.write(this.method);
            packer.write(this.session);
            packer.write(this.args);
            packer.writeArrayEnd();
        }

        @Override
        public void readFrom(Unpacker unpacker) {
            throw new UnsupportedOperationException("Reading InvocationRequest is not supported");
        }

        public String toString() {
            return "InvocationRequest/" + this.session + ": " + this.method + " [" + Joiner.on(", ").join(this.args) + "]";
        }
    }
}

