/*
 * Decompiled with CFR 0.152.
 */
package ru.cocainum;

import cocaine.Locator;
import cocaine.Service;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.lang.reflect.Array;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.msgpack.MessagePack;
import rx.observables.BlockingObservable;

public class App {
    private static final Logger logger = Logger.getLogger(App.class);

    private static <T> T[] concatenate(T[] A, T[] B) {
        int aLen = A.length;
        int bLen = B.length;
        Object[] C = (Object[])Array.newInstance(A.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(A, 0, C, 0, aLen);
        System.arraycopy(B, 0, C, aLen, bLen);
        return C;
    }

    public static String test(String tst_str) {
        return "test string - " + tst_str;
    }

    public static String getString(String service, String method, String ... args) {
        String result = "";
        try (Locator locator = Locator.create();){
            Service echo = locator.service(service);
            String[] m = new String[]{method};
            BlockingObservable response = echo.invoke("enqueue", (Object[])App.concatenate(m, args)).toBlockingObservable();
            logger.info((Object)"Got response");
            result = App.unpack((byte[])response.toFuture().get(), String.class);
            logger.info((Object)("Got: " + result));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static String[] getStringArray(String service, String method, String ... args) {
        String[] results = new String[]{};
        try (Locator locator = Locator.create();){
            Service echo = locator.service(service);
            String[] m = new String[]{method};
            BlockingObservable response = echo.invoke("enqueue", (Object[])App.concatenate(m, args)).toBlockingObservable();
            logger.info((Object)"Got response");
            results = App.unpack((byte[])response.toFuture().get(), String[].class);
            for (int i = 0; i < results.length; ++i) {
                logger.info((Object)("Got: " + results[i]));
            }
            logger.info((Object)("After response: " + results.length));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        System.out.println("Hello World!");
        String[] res = App.getStringArray("DummyService", "write_dummy", "test string");
        System.out.println(res[0]);
        System.out.println(res[1]);
    }

    public static byte[] pack(long value) {
        try {
            return MessagePack.pack((Object)value);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static <T> T unpack(byte[] bytes, Class<T> type) {
        try {
            return (T)MessagePack.unpack((byte[])bytes, type);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }
}

