/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observer;
import rx.operators.SafeObservableSubscription;

public final class SynchronizedObserver<T>
implements Observer<T> {
    private final Observer<? super T> observer;
    private final SafeObservableSubscription subscription;
    private volatile boolean finishRequested = false;
    private volatile boolean finished = false;
    private volatile Object lock;

    public SynchronizedObserver(Observer<? super T> Observer2, SafeObservableSubscription subscription) {
        this.observer = Observer2;
        this.subscription = subscription;
        this.lock = this;
    }

    public SynchronizedObserver(Observer<? super T> Observer2, SafeObservableSubscription subscription, Object lock) {
        this.observer = Observer2;
        this.subscription = subscription;
        this.lock = lock;
    }

    public SynchronizedObserver(Observer<? super T> Observer2) {
        this(Observer2, new SafeObservableSubscription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T arg) {
        if (this.finished || this.finishRequested || this.subscription.isUnsubscribed()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.finished || this.finishRequested || this.subscription.isUnsubscribed()) {
                return;
            }
            this.observer.onNext(arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable e) {
        if (this.finished || this.subscription.isUnsubscribed()) {
            return;
        }
        this.finishRequested = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.finished || this.subscription.isUnsubscribed()) {
                return;
            }
            this.observer.onError(e);
            this.finished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        if (this.finished || this.subscription.isUnsubscribed()) {
            return;
        }
        this.finishRequested = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.finished || this.subscription.isUnsubscribed()) {
                return;
            }
            this.observer.onCompleted();
            this.finished = true;
        }
    }
}

