/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Func0;
import rx.util.functions.Func1;
import rx.util.functions.Functions;

public class OperationToMap {
    public static <T, K> Observable.OnSubscribeFunc<Map<K, T>> toMap(Observable<T> source, Func1<? super T, ? extends K> keySelector) {
        return new ToMap(source, keySelector, Functions.identity(), new DefaultToMapFactory());
    }

    public static <T, K, V> Observable.OnSubscribeFunc<Map<K, V>> toMap(Observable<T> source, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector) {
        return new ToMap<T, K, V>(source, keySelector, valueSelector, new DefaultToMapFactory());
    }

    public static <T, K, V> Observable.OnSubscribeFunc<Map<K, V>> toMap(Observable<T> source, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, V>> mapFactory) {
        return new ToMap<T, K, V>(source, keySelector, valueSelector, mapFactory);
    }

    public static class ToMap<T, K, V>
    implements Observable.OnSubscribeFunc<Map<K, V>> {
        private final Observable<T> source;
        private final Func1<? super T, ? extends K> keySelector;
        private final Func1<? super T, ? extends V> valueSelector;
        private final Func0<? extends Map<K, V>> mapFactory;

        public ToMap(Observable<T> source, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, V>> mapFactory) {
            this.source = source;
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            this.mapFactory = mapFactory;
        }

        @Override
        public Subscription onSubscribe(Observer<? super Map<K, V>> t1) {
            Map<K, V> map;
            try {
                map = this.mapFactory.call();
            }
            catch (Throwable t) {
                t1.onError(t);
                return Subscriptions.empty();
            }
            return this.source.subscribe(new ToMapObserver<K, V, T>(t1, this.keySelector, this.valueSelector, map));
        }

        public static class ToMapObserver<K, V, T>
        implements Observer<T> {
            Map<K, V> map;
            private final Func1<? super T, ? extends K> keySelector;
            private final Func1<? super T, ? extends V> valueSelector;
            private final Observer<? super Map<K, V>> t1;

            public ToMapObserver(Observer<? super Map<K, V>> t1, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Map<K, V> map) {
                this.map = map;
                this.t1 = t1;
                this.keySelector = keySelector;
                this.valueSelector = valueSelector;
            }

            @Override
            public void onNext(T args) {
                K key = this.keySelector.call(args);
                V value = this.valueSelector.call(args);
                this.map.put(key, value);
            }

            @Override
            public void onError(Throwable e) {
                this.map = null;
                this.t1.onError(e);
            }

            @Override
            public void onCompleted() {
                Map<K, V> map0 = this.map;
                this.map = null;
                this.t1.onNext(map0);
                this.t1.onCompleted();
            }
        }
    }

    public static class DefaultToMapFactory<K, V>
    implements Func0<Map<K, V>> {
        @Override
        public Map<K, V> call() {
            return new HashMap();
        }
    }
}

