/*
 * Decompiled with CFR 0.152.
 */
package rx.subscriptions;

import java.util.concurrent.atomic.AtomicReference;
import rx.Subscription;
import rx.subscriptions.Subscriptions;

public final class SingleAssignmentSubscription
implements Subscription {
    private final AtomicReference<Subscription> current = new AtomicReference();
    private static final Subscription SENTINEL = new Subscription(){

        @Override
        public void unsubscribe() {
        }
    };

    public Subscription get() {
        Subscription s = this.current.get();
        if (s == SENTINEL) {
            return Subscriptions.empty();
        }
        return s;
    }

    public void set(Subscription s) {
        if (this.current.compareAndSet(null, s)) {
            return;
        }
        if (this.current.get() != SENTINEL) {
            throw new IllegalStateException("Subscription already set");
        }
        if (s != null) {
            s.unsubscribe();
        }
    }

    @Override
    public void unsubscribe() {
        Subscription old = this.current.getAndSet(SENTINEL);
        if (old != null) {
            old.unsubscribe();
        }
    }

    public boolean isUnsubscribed() {
        return this.current.get() == SENTINEL;
    }
}

