/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.util.functions.Action0;

public final class OperationFinally {
    public static <T> Observable.OnSubscribeFunc<T> finallyDo(final Observable<? extends T> sequence, final Action0 action) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new Finally(sequence, action).onSubscribe(observer);
            }
        };
    }

    private static class Finally<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> sequence;
        private final Action0 finalAction;

        Finally(Observable<? extends T> sequence, Action0 finalAction) {
            this.sequence = sequence;
            this.finalAction = finalAction;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            return this.sequence.subscribe(new FinallyObserver(observer));
        }

        private class FinallyObserver
        implements Observer<T> {
            private final Observer<? super T> observer;

            FinallyObserver(Observer<? super T> observer) {
                this.observer = observer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                try {
                    this.observer.onCompleted();
                }
                finally {
                    Finally.this.finalAction.call();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                try {
                    this.observer.onError(e);
                }
                finally {
                    Finally.this.finalAction.call();
                }
            }

            @Override
            public void onNext(T args) {
                this.observer.onNext(args);
            }
        }
    }
}

