/*
 * Decompiled with CFR 0.152.
 */
package rx.joins;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import rx.Notification;
import rx.Observable;
import rx.joins.ActivePlan0;
import rx.joins.JoinObserver;
import rx.joins.ObserverBase;
import rx.subscriptions.SingleAssignmentSubscription;
import rx.util.functions.Action1;

public final class JoinObserver1<T>
extends ObserverBase<Notification<T>>
implements JoinObserver {
    private Object gate;
    private final Observable<T> source;
    private final Action1<Throwable> onError;
    private final List<ActivePlan0> activePlans;
    private final Queue<Notification<T>> queue;
    private final SingleAssignmentSubscription subscription;
    private volatile boolean done;

    public JoinObserver1(Observable<T> source, Action1<Throwable> onError) {
        this.source = source;
        this.onError = onError;
        this.queue = new LinkedList<Notification<T>>();
        this.subscription = new SingleAssignmentSubscription();
        this.activePlans = new ArrayList<ActivePlan0>();
    }

    public Queue<Notification<T>> queue() {
        return this.queue;
    }

    public void addActivePlan(ActivePlan0 activePlan) {
        this.activePlans.add(activePlan);
    }

    @Override
    public void subscribe(Object gate) {
        this.gate = gate;
        this.subscription.set(this.source.materialize().subscribe(this));
    }

    @Override
    public void dequeue() {
        this.queue.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onNextCore(Notification<T> args) {
        Object object = this.gate;
        synchronized (object) {
            if (!this.done) {
                if (args.isOnError()) {
                    this.onError.call(args.getThrowable());
                    return;
                }
                this.queue.add(args);
                for (ActivePlan0 a : new ArrayList<ActivePlan0>(this.activePlans)) {
                    a.match();
                }
            }
        }
    }

    @Override
    protected void onErrorCore(Throwable e) {
    }

    @Override
    protected void onCompletedCore() {
    }

    void removeActivePlan(ActivePlan0 activePlan) {
        this.activePlans.remove(activePlan);
        if (this.activePlans.isEmpty()) {
            this.unsubscribe();
        }
    }

    @Override
    public void unsubscribe() {
        if (!this.done) {
            this.done = true;
            this.subscription.unsubscribe();
        }
    }
}

