/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import rx.Notification;
import rx.Observable;
import rx.subjects.AbstractSubject;

public class PublishSubject<T>
extends AbstractSubject<T> {
    private final AbstractSubject.SubjectState<T> state;

    public static <T> PublishSubject<T> create() {
        AbstractSubject.SubjectState state = new AbstractSubject.SubjectState();
        Observable.OnSubscribeFunc onSubscribe = PublishSubject.getOnSubscribeFunc(state, null);
        return new PublishSubject(onSubscribe, state);
    }

    protected PublishSubject(Observable.OnSubscribeFunc<T> onSubscribe, AbstractSubject.SubjectState<T> state) {
        super(onSubscribe);
        this.state = state;
    }

    @Override
    public void onCompleted() {
        this.state.currentValue.set(new Notification());
        this.emitNotificationAndTerminate(this.state, null);
    }

    @Override
    public void onError(Throwable e) {
        this.state.currentValue.set(new Notification(e));
        this.emitNotificationAndTerminate(this.state, null);
    }

    @Override
    public void onNext(T v) {
        this.state.currentValue.set(new Notification<T>(v));
        PublishSubject.emitNotification(this.state, null);
    }
}

