/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.OperationMostRecent;
import rx.operators.OperationNext;
import rx.operators.OperationToFuture;
import rx.operators.OperationToIterator;
import rx.operators.SafeObservableSubscription;
import rx.operators.SafeObserver;
import rx.util.functions.Action1;
import rx.util.functions.Func1;

public class BlockingObservable<T> {
    private final Observable<? extends T> o;

    private BlockingObservable(Observable<? extends T> o) {
        this.o = o;
    }

    public static <T> BlockingObservable<T> from(Observable<? extends T> o) {
        return new BlockingObservable<T>(o);
    }

    private static <T> T _singleOrDefault(BlockingObservable<? extends T> source, boolean hasDefault, T defaultValue) {
        Iterator<T> it = source.toIterable().iterator();
        if (!it.hasNext()) {
            if (hasDefault) {
                return defaultValue;
            }
            throw new IllegalStateException("Expected single entry. Actually empty stream.");
        }
        T result = it.next();
        if (it.hasNext()) {
            throw new IllegalStateException("Expected single entry. Actually more than one entry.");
        }
        return result;
    }

    private Subscription protectivelyWrapAndSubscribe(Observer<? super T> observer) {
        SafeObservableSubscription subscription = new SafeObservableSubscription();
        return subscription.wrap(this.o.subscribe(new SafeObserver<T>(subscription, observer)));
    }

    public void forEach(final Action1<? super T> onNext) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference exceptionFromOnError = new AtomicReference();
        this.protectivelyWrapAndSubscribe(new Observer<T>(){

            @Override
            public void onCompleted() {
                latch.countDown();
            }

            @Override
            public void onError(Throwable e) {
                exceptionFromOnError.set(e);
                latch.countDown();
            }

            @Override
            public void onNext(T args) {
                onNext.call(args);
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for subscription to complete.", e);
        }
        if (exceptionFromOnError.get() != null) {
            if (exceptionFromOnError.get() instanceof RuntimeException) {
                throw (RuntimeException)exceptionFromOnError.get();
            }
            throw new RuntimeException((Throwable)exceptionFromOnError.get());
        }
    }

    public Iterator<T> getIterator() {
        return OperationToIterator.toIterator(this.o);
    }

    public T last() {
        return new BlockingObservable<T>(this.o.last()).single();
    }

    public T last(Func1<? super T, Boolean> predicate) {
        return BlockingObservable.from(this.o.filter(predicate)).last();
    }

    public T lastOrDefault(T defaultValue) {
        boolean found = false;
        T result = null;
        for (T value : this.toIterable()) {
            found = true;
            result = value;
        }
        if (!found) {
            return defaultValue;
        }
        return result;
    }

    public T lastOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return BlockingObservable.from(this.o.filter(predicate)).lastOrDefault(defaultValue);
    }

    public Iterable<T> mostRecent(T initialValue) {
        return OperationMostRecent.mostRecent(this.o, initialValue);
    }

    public Iterable<T> next() {
        return OperationNext.next(this.o);
    }

    public T single() {
        return BlockingObservable._singleOrDefault(this, false, null);
    }

    public T single(Func1<? super T, Boolean> predicate) {
        return BlockingObservable._singleOrDefault(BlockingObservable.from(this.o.filter(predicate)), false, null);
    }

    public T singleOrDefault(T defaultValue) {
        return BlockingObservable._singleOrDefault(this, true, defaultValue);
    }

    public T singleOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return BlockingObservable._singleOrDefault(BlockingObservable.from(this.o.filter(predicate)), true, defaultValue);
    }

    public Future<T> toFuture() {
        return OperationToFuture.toFuture(this.o);
    }

    public Iterable<T> toIterable() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return BlockingObservable.this.getIterator();
            }
        };
    }
}

