/*
 * Decompiled with CFR 0.152.
 */
package cocaine.msgpack;

import cocaine.ServiceApi;
import cocaine.ServiceInfo;
import cocaine.msgpack.SocketAddressTemplate;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Map;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.Template;
import org.msgpack.template.Templates;
import org.msgpack.unpacker.Unpacker;

public class ServiceInfoTemplate
extends AbstractTemplate<ServiceInfo> {
    private final String name;

    private ServiceInfoTemplate(String name) {
        this.name = name;
    }

    public static Template<ServiceInfo> create(String name) {
        return new ServiceInfoTemplate(name);
    }

    @Override
    public void write(Packer packer, ServiceInfo service, boolean required) throws IOException {
        throw new UnsupportedOperationException(ServiceInfo.class.getSimpleName() + " can not be encoded by " + ServiceInfoTemplate.class.getSimpleName());
    }

    @Override
    public ServiceInfo read(Unpacker unpacker, ServiceInfo service, boolean required) throws IOException {
        unpacker.readArrayBegin();
        SocketAddress endpoint = unpacker.read(SocketAddressTemplate.getInstance());
        unpacker.readInt();
        Map<Integer, String> api = unpacker.read(Templates.tMap(Templates.TInteger, Templates.TString));
        unpacker.readArrayEnd();
        return new ServiceInfo(this.name, endpoint, ServiceApi.of(this.name, (ImmutableMap<String, Integer>)((Object)ImmutableBiMap.copyOf(api).inverse())));
    }
}

