/*
 * Decompiled with CFR 0.152.
 */
package ru.cetelem.cassiope.supplier.model;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import ru.cetelem.cassiope.supplier.io.PayloadType;
import ru.cetelem.cassiope.supplier.model.PayloadItem;
import ru.cetelem.cassiope.supplier.util.DateUtils;

@Entity
@Table(name="PAYLOAD")
public class Payload {
    @Id
    @GeneratedValue
    @Column(name="Id", nullable=false)
    public int id;
    public PayloadType payloadType;
    public String name;
    public LocalDateTime date;
    public LocalDate processedDate;
    public LocalDate rollbackDate;
    @OneToMany(mappedBy="payload", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    public List<PayloadItem> payloadItems;
    public String state;
    public int sequenceNumber;
    private LocalDate archivedDate;

    public Payload() {
        this.state = "NEW";
        this.date = LocalDateTime.now();
        this.payloadItems = new ArrayList<PayloadItem>();
    }

    public Payload(PayloadType payloadType, String name, LocalDateTime date) {
        this.payloadType = payloadType;
        this.name = name;
        this.date = date;
        this.state = "NEW";
        this.payloadItems = new ArrayList<PayloadItem>();
    }

    public PayloadType getPayloadType() {
        return this.payloadType;
    }

    public void setPayloadType(PayloadType payloadType) {
        this.payloadType = payloadType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    public void setDate(LocalDateTime date) {
        this.date = date;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.name == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Payload payload = (Payload)o;
        if (payload.name == null) {
            return false;
        }
        return this.name.equals(payload.name);
    }

    public String toString() {
        return "Payload [name=" + this.name + "]";
    }

    public List<PayloadItem> getPayloadItems() {
        return this.payloadItems;
    }

    public void setPayloadItems(List<PayloadItem> payloadItems) {
        this.payloadItems = payloadItems;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public LocalDate getProcessedDate() {
        return this.processedDate;
    }

    public void setProcessedDate(LocalDate processedDate) {
        this.processedDate = processedDate;
    }

    public LocalDate getRollbackDate() {
        return this.rollbackDate;
    }

    public void setRollbackDate(LocalDate rollbackDate) {
        this.rollbackDate = rollbackDate;
    }

    public LocalDate getDateOnly() {
        return DateUtils.asLocalDate(this.date);
    }

    public void setDateOnly(LocalDate date) {
        this.date = DateUtils.asLocalDateTime(date);
    }

    public LocalDate getArchivedDate() {
        return this.archivedDate;
    }

    public void setArchivedDate(LocalDate archivedDate) {
        this.archivedDate = archivedDate;
    }
}

