/*
 * Decompiled with CFR 0.152.
 */
package ru.cetelem.cassiope.supplier.io.icfl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.cetelem.cassiope.supplier.io.icfl.ICfl11Item;
import ru.cetelem.cassiope.supplier.io.icfl.ICfl11Trail;
import ru.cetelem.cassiope.supplier.io.icfl.ICfl22Item;
import ru.cetelem.cassiope.supplier.io.icfl.ICfl22Trail;
import ru.cetelem.cassiope.supplier.io.icfl.ICfl33Trail;
import ru.cetelem.cassiope.supplier.io.icfl.ICfl44Trail;
import ru.cetelem.cassiope.supplier.io.icfl.ICflHeader;
import ru.cetelem.cassiope.supplier.io.icfl.ICflTrail;
import ru.cetelem.cassiope.supplier.model.Car;

public class ICfl {
    public ICflHeader icflHeader;
    public List<ICfl11Item> icfl11Items = new ArrayList<ICfl11Item>();
    public ICfl11Trail icfl11Trail;
    public List<ICfl22Item> icfl22Items = new ArrayList<ICfl22Item>();
    public ICfl22Trail icfl22Trail;
    public ICfl33Trail icfl33Trail;
    public ICfl44Trail icfl44Trail;
    public ICflTrail icflTrail;

    public List<Object> getAsList() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.icflHeader);
        result.addAll(this.icfl11Items);
        result.add(this.icfl11Trail);
        result.addAll(this.icfl22Items);
        result.add(this.icfl22Trail);
        result.add(this.icfl33Trail);
        result.add(this.icfl44Trail);
        result.add(this.icflTrail);
        return result;
    }

    public static class ICflBuilder {
        private ICfl icfl = new ICfl();
        private String creator;

        ICflBuilder(Date batchDate, long sequenceNumber, String creator) {
            this.creator = creator;
            this.icfl.icflHeader = new ICflHeader();
            this.icfl.icflHeader.batchDate = batchDate;
            this.icfl.icflHeader.sequnceNumber = sequenceNumber;
        }

        public static ICflBuilder createICflBuilder(Date batchDate, long sequenceNumber, String creator) {
            return new ICflBuilder(batchDate, sequenceNumber, creator);
        }

        public ICflBuilder addICfl22Item(String dealerCode, String invoiceNumber, String vin, long invoiceAmount, String model, String planCode) {
            return this.addICfl22Item(dealerCode, invoiceNumber, vin, invoiceAmount, model, planCode, null);
        }

        public ICflBuilder addICfl22Item(String dealerCode, String invoiceNumber, String vin, long invoiceAmount, String model, String planCode, Car car) {
            ICfl22Item icfl22Item = new ICfl22Item();
            icfl22Item.recordId = "22";
            icfl22Item.creator = this.creator;
            icfl22Item.dealerCode = dealerCode;
            icfl22Item.invoiceNumber = invoiceNumber;
            icfl22Item.invoiceAmount = invoiceAmount;
            icfl22Item.vin = vin;
            icfl22Item.model = vin != null && !"".equals(vin.trim()) ? vin.substring(6, 10) : model;
            icfl22Item.planCode = planCode;
            icfl22Item.car = car;
            this.icfl.icfl22Items.add(icfl22Item);
            return this;
        }

        public ICflBuilder addICfl11Item(String dealerCode, String invoiceNumber, String vin, long paymentAmount) {
            return this.addICfl11Item(dealerCode, invoiceNumber, vin, paymentAmount, null);
        }

        public ICflBuilder addICfl11Item(String dealerCode, String invoiceNumber, String vin, long paymentAmount, Car car) {
            ICfl11Item icfl11Item = new ICfl11Item();
            icfl11Item.recordId = "11";
            icfl11Item.creator = this.creator;
            icfl11Item.dealerCode = dealerCode;
            icfl11Item.invoiceNumber = invoiceNumber;
            icfl11Item.paymentAmount = paymentAmount;
            icfl11Item.vin = vin;
            icfl11Item.car = car;
            this.icfl.icfl11Items.add(icfl11Item);
            return this;
        }

        public ICfl build() {
            this.icfl.icfl11Trail = this.icfl.icfl11Items.size() > 0 ? new ICfl11Trail(this.creator, this.icfl.icfl11Items) : new ICfl11Trail(this.creator);
            this.icfl.icfl22Trail = this.icfl.icfl22Items.size() > 0 ? new ICfl22Trail(this.creator, this.icfl.icfl22Items) : new ICfl22Trail(this.creator);
            this.icfl.icfl33Trail = new ICfl33Trail(this.creator);
            this.icfl.icfl44Trail = new ICfl44Trail(this.creator);
            this.icfl.icflTrail = new ICflTrail(this.icfl, this.creator);
            return this.icfl;
        }
    }
}

