/*
 * Decompiled with CFR 0.152.
 */
package ru.cetelem.cassiope.supplier.io.cfl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.cetelem.cassiope.supplier.io.cfl.Cfl11Item;
import ru.cetelem.cassiope.supplier.io.cfl.Cfl11Trail;
import ru.cetelem.cassiope.supplier.io.cfl.Cfl22Item;
import ru.cetelem.cassiope.supplier.io.cfl.Cfl22Trail;
import ru.cetelem.cassiope.supplier.io.cfl.Cfl33Trail;
import ru.cetelem.cassiope.supplier.io.cfl.Cfl44Trail;
import ru.cetelem.cassiope.supplier.io.cfl.CflHeader;
import ru.cetelem.cassiope.supplier.io.cfl.CflTrail;
import ru.cetelem.cassiope.supplier.model.Car;

public class Cfl {
    public CflHeader cflHeader;
    public List<Cfl11Item> cfl11Items = new ArrayList<Cfl11Item>();
    public Cfl11Trail cfl11Trail;
    public List<Cfl22Item> cfl22Items = new ArrayList<Cfl22Item>();
    public Cfl22Trail cfl22Trail;
    public Cfl33Trail cfl33Trail;
    public Cfl44Trail cfl44Trail;
    public CflTrail cflTrail;

    public List<Object> getAsList() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.cflHeader);
        result.addAll(this.cfl11Items);
        result.add(this.cfl11Trail);
        result.addAll(this.cfl22Items);
        result.add(this.cfl22Trail);
        result.add(this.cfl33Trail);
        result.add(this.cfl44Trail);
        result.add(this.cflTrail);
        return result;
    }

    public static class CflBuilder {
        private Cfl cfl = new Cfl();
        private String creator;

        CflBuilder(Date batchDate, long sequenceNumber, String creator) {
            this.creator = creator;
            this.cfl.cflHeader = new CflHeader();
            this.cfl.cflHeader.batchDate = batchDate;
            this.cfl.cflHeader.sequenceNumber = sequenceNumber;
            this.cfl.cflHeader.createrCompany = creator;
        }

        public static CflBuilder createCflBuilder(Date batchDate, long sequenceNumber, String creator) {
            return new CflBuilder(batchDate, sequenceNumber, creator);
        }

        public CflBuilder addCfl22Item(String dealerCode, String invoiceNumber, String vin, long invoiceAmount, String model, String planCode) {
            return this.addCfl22Item(dealerCode, invoiceNumber, vin, invoiceAmount, invoiceAmount, invoiceAmount, "", "", "", "RUR", null, null, model, planCode, null);
        }

        public CflBuilder addCfl22Item(String dealerCode, String invoiceNumber, String vin, long invoiceAmount, long paymentAmount, long vatAmount, String orderNumber, String plateNumber, String businessType, String currency, Date financeDate, Date whosaleDate, String model, String planCode, Car car) {
            Cfl22Item cfl22Item = new Cfl22Item();
            cfl22Item.recordId = "22";
            cfl22Item.creator = this.creator;
            cfl22Item.dealerCode = dealerCode;
            cfl22Item.invoiceNumber = invoiceNumber;
            cfl22Item.invoiceAmount = invoiceAmount;
            cfl22Item.paymentAmount = paymentAmount;
            cfl22Item.vatAmount = vatAmount;
            cfl22Item.financeDate = financeDate;
            cfl22Item.whosaleDate = whosaleDate;
            cfl22Item.orderNumber = orderNumber;
            cfl22Item.plateNumber = plateNumber;
            cfl22Item.businessType = businessType;
            cfl22Item.currency = currency;
            cfl22Item.vin = vin;
            cfl22Item.model = vin != null && !"".equals(vin.trim()) ? vin.substring(6, 10) : model;
            cfl22Item.planCode = planCode;
            cfl22Item.car = car;
            this.cfl.cfl22Items.add(cfl22Item);
            return this;
        }

        public CflBuilder addCfl11Item(String dealerCode, String invoiceNumber, String vin, long paymentAmount) {
            return this.addCfl11Item(dealerCode, invoiceNumber, vin, null, null, "RUR", paymentAmount, null);
        }

        public CflBuilder addCfl11Item(String dealerCode, String invoiceNumber, String vin, Date financeDate, Date processingDate, String currency, long paymentAmount, Car car) {
            Cfl11Item cfl11Item = new Cfl11Item();
            cfl11Item.recordId = "11";
            cfl11Item.creator = this.creator;
            cfl11Item.dealerCode = dealerCode;
            cfl11Item.invoiceNumber = invoiceNumber;
            cfl11Item.paymentAmount = paymentAmount;
            cfl11Item.vin = vin;
            cfl11Item.financeDate = financeDate;
            cfl11Item.processingDate = processingDate;
            cfl11Item.creator = this.creator;
            cfl11Item.currency = currency;
            cfl11Item.car = car;
            this.cfl.cfl11Items.add(cfl11Item);
            return this;
        }

        public Cfl build() {
            this.cfl.cfl11Trail = this.cfl.cfl11Items.size() > 0 ? new Cfl11Trail(this.creator, this.cfl.cfl11Items) : new Cfl11Trail(this.creator);
            this.cfl.cfl22Trail = this.cfl.cfl22Items.size() > 0 ? new Cfl22Trail(this.creator, this.cfl.cfl22Items) : new Cfl22Trail(this.creator);
            this.cfl.cfl33Trail = new Cfl33Trail(this.creator);
            this.cfl.cfl44Trail = new Cfl44Trail(this.creator);
            this.cfl.cflTrail = new CflTrail(this.cfl, this.creator);
            return this.cfl;
        }
    }
}

