(ns jsonschema.okl
  (:use jsonschema.core))


(defn okl-yoda-html-extra-quote [json-str]
  (clojure.string/replace json-str #"\"HTTP/1.1\"\"" "\"HTTP/1.1\""))

(defn okl-yoda-dash-as-null [json-str]
  (clojure.string/replace json-str #"\"-\"" "null"))



(defn show-x-okl-utm-campaign-when-string [some-map should-show?]
  (when (and
         (string? (get some-map "X-Okl-Utm-Campaign"))
         (should-show?))
    (println some-map))
  some-map)

;; (map #(show-x-okl-utm-campaign-when-string % ten-times) ... )

(def okl-line-xform
  (comp okl-yoda-html-extra-quote
        okl-yoda-dash-as-null))



;; (def a (first (analyze-schema ["/Users/Roxxi/Desktop/2013012504_1.log"]
;;                               :line-xform okl-line-xform)))



;; docs ::= (document-types union)
;; (def prop=>types (extract-map properties :value-extractor (fn [key]  (reduce clojure.set/union (map set (filter identity (map #(get-in % [:map key]) docs)))))))

;; (def properties (reduce clojure.set/union (map set (map :properties (jsonschema.type-system.types/document-types union)))))


;; img_click_view sometiems is an empty list

;; 76.24.181.17 - - [01/Feb/2013:15:49:02 -0800] 3jdnj1f91gmh3b2iaulsoj85h0 768591 - 11122 "POST /tracking HTTP/1.1" 200 60 "https://www.onekingslane.com/vintage-market-finds/product/1069981" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.57 Safari/537.17" www.onekingslane.com 768591 se_pdp - "-" "-" "-" "-" "-" "{\"img_click_view\":\"[]\",\"sales_event_id\":\"12847\",\"product_id\":\"1069981\"}" track_img_view "-" bd62dd6c3bec3d8f00046d97b77210dd - -

;; but sometimes it has a list of JSON objects

;; 71.197.130.108 - - [01/Feb/2013:16:12:05 -0800] fkhshov93o22fq75hob3i9rbh2 4229505 - 14169 "POST /tracking HTTP/1.1" 200 60 "https://www.onekingslane.com/product/18824/906463?utm_campaign=Search_Cushions_and_Pillows-NonMembers_RFSA&utm_content=pillows_throw_decorative%7Cgoognb%7Cmkwid%7Cs00yBurs9%7Cpcrid%7C20827837582&utm_medium=search&utm_source=google&utm_term=decorative%20throw%20pillows%7Cb" "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_4_11; en) AppleWebKit/533.19.4 (KHTML, like Gecko) Version/4.1.3 Safari/533.19.4" www.onekingslane.com 4229505 se_pdp - "-" "-" "-" "-" "-" "{\"img_click_view\":\"[{\\\"image_num\\\":1,\\\"zoom\\\":0},{\\\"image_num\\\":3,\\\"zoom\\\":1},{\\\"image_num\\\":2,\\\"zoom\\\":1},{\\\"image_num\\\":4,\\\"zoom\\\":1}]\",\"sales_event_id\":\"18824\",\"product_id\":\"906463\"}" track_img_view "-" 07ef23d5d97b41b083bb75a96ca7d390 unknown_link se_pdp

;; but that's resulting in which is wrong

;;       {"img_click_view"
;;        {:union-of #{{:coll-of :nothing} {:properties [], :map {}}}},
;;        "sales_event_id" {:type :number},
;;        "product_id" {:type :number}}}


