(ns jsonschema.core
  (:use clojure.java.io
        roxxi.utils.map
        jsonschema.parser
        jsonschema.type-system.extract
        jsonschema.type-system.merge))


(defn file-to-schema [filepath & {:keys [line-xform]
                                  :or {line-xform identity}}]
  (with-open [rdr (reader filepath :encoding "UTF-8")]
    (let [lines (line-seq rdr)]
      (reduce merge-types
              (map extract-type
                   (parse-json-strings lines
                                       :string-transform line-xform))))))

(defn files-to-schema [filepaths & {:keys [line-xform]
                                    :or {line-xform identity}}]
  (reduce merge-types
          (map #(file-to-schema % :line-xform line-xform)
               filepaths)))

(defn analyze-schema [filepaths & {:keys [line-xform]
                                   :or {line-xform identity}} ]
  (let [schema (files-to-schema filepaths :line-xform line-xform)]
    (clojure.pprint/pprint schema)
    (println (str "Analyzed " @line-number " entries. "
                  (count @failed-lines) " failed."))
    schema))

