(ns common.db.migrate
  "Database migrations management alternative main/entry-point.
  This is runnable using `lein run -m common.db.migrate` or compiled using
  `java -cp uberjar.jar common.db.migrate`. See usage below for more details."
  (:require
    [common.convert :refer [str->int]]
    [conf.core :as conf]
    [ragtime.jdbc :as jdbc]
    [ragtime.repl :as repl])
  (:gen-class))

(def ^:private config
  {:datastore (jdbc/sql-database {:connection-uri (conf/get :database-url)})
   :migrations (jdbc/load-resources (conf/get :migrations-dir "migrations"))})

(def usage
  "Manage database migrations.

Usage: lein run -m common.db.migrate <COMMAND> <ARGS>

Commands:
  migrate       Migrate to the latest version
  rollback      Rollback 1 versions")

(defn run-migrate []
  (repl/migrate config))

(defn run-rollback []
  (repl/rollback config 1))

(defn -main
  "Run the migrations or rollbacks"
  [& args]
  (case (first args)
    "migrate" (run-migrate)
    "rollback" (run-rollback)
    (do (println usage)
        (System/exit 1))))
