package rojat.math;

import java.util.ArrayList;

public class Factorial {
	public static Factorial instance;
	public static Factorial getInstance() {
		if (instance == null)
			instance = new Factorial(10);
		return instance;
	}
	ArrayList<Double> data;
	public Factorial(int size) {
		data = new ArrayList<Double>(size + 1);
		data.add(1.0);
		extendTo(size);
	}
	public double getFactorial(int v) {
		if (v >= getSize())
			extendTo(v);
		return data.get(v);
	}
	public int getSize() {
		return data.size();
	}
	public void extendTo(int v) {
		double last = data.get(data.size() - 1);
		for (int i = getSize(); i <= v; i++) {
			 last = last * i;
			data.add(last);
		}
	}
	public static void main(String[] args) {
		Factorial f = new Factorial(5);
		System.out.println(f.getFactorial(4));
		System.out.println(f.getFactorial(5));
		System.out.println(f.getFactorial(6));
		System.out.println(f.getFactorial(10));
	}
}
