
(ns rojat-arrphys.core (:require [rojat-arrows.hughes :as h] [rojat-arrows.afrp :as afrp])
 (:use rojat-math.core rojat-arrows.extra))

(def arr-to-spherical (h/arr to-spherical))
(def arr-from-spherical (h/arr (partial from-spherical 5))) 
(defn arr-cross [f & options] (h/arr-strict (fn [[s1 s2]] (apply cross (concat [f s1 s2] options))))
)
(defn arr-dot [f] (h/arr-strict (fn [[s1 s2]] (dot f s1 s2))))
(ns rojat-arrphys.core)
(defn arr-translate [& options]
  (h/arr (fn [[dv v x] [dv-dash v-dash x-dash]]
        (let [spin (some #{:spherical-in} options)
              spout (some #{:spherical-out} options)
              xc (if spin (apply from-spherical x) x)
;              boost (c- [0 0 0] xc)
              x-dashc (if spin (apply from-spherical x-dash) x-dash)]
         [xc [[dv v [0 0 0]] [dv-dash v-dash (if spout (apply to-spherical (c- x-dashc xc)) (c- x-dashc xc))]]]
)
)
)
)
(defn arr-translate-dash [& options]
 (h/arr (fn [boost [[dv v x] [dv-dash v-dash x-dash]]]
     (let [spin (some #{:spherical-in} options)
           spout (some #{:spherical-out} options)
           x-dashc (if spin (apply from-spherical x-dash) x-dash)]
     [[dv v (if spout (apply to-spherical boost) boost)] [dv-dash v-dash (if spout (apply to-spherical (c+ x-dashc boost)) (c+ x-dashc boost))]])
  
))
)

(defn arr-translate-invariance [af & options]
 (let [spin (some #{:spherical-in} options)
       spaf (some #{:spherical-af} options)
       options1 [(if spin :spherical-in) (if spaf :spherical-out)]
       options2 [(if spin :spherical-out) (if spaf :spherical-in)]]
       
 (h/>>> (apply arr-translate options1) (h/h-second af) (apply arr-translate-dash options2))
)
)

(def arr-fdt (h/arr (fn [dt [dv v x]] [dt [dv (+ (* dv dt) v) (+ (* v dt) x)]])))
(def arr-fdt3d (afrp/app arr-fdt))

(defn arr-apply-types-to-interaction [af] (h/app (h/h-first af) :eager))
(defn add-state [s1 s2] (dot (partial dot +) s1 s2))
(ns rojat-arrphys.core (:use rojat-math.core) (:require [rojat-arrows.hughes :as h]))
(def g0 9.8)


(defn point-mass-interaction [[mass mass1] state state1]
(let [
         ;ms (> mass mass1)
         mss (+ mass mass1)
         md (/ mass1 mss)
         md-dash (/ mass mss)
         [_ _ x1] state1
         r1 (first x1)
         g0r1-squared (* g0 (* r1 r1))
         ;let's calculate the magnitude of state's dv
         state-dv (/ md g0r1-squared)
         state1-dv (/ md-dash g0r1-squared)
         ;state's dv is in the direction of x1
         state-dv-vec (dot * x1 [state-dv 1 1])
        ; whereas state1's dv is in the direction of - x1
         state1-dv-vec (dot * (apply inverse-spherical x1) [state1-dv 1 1])
     ]
     [[state-dv-vec 0 0] [state1-dv-vec 0 0]]
)
)

(def arr-point-mass-interaction (h/arr (fn [[_ mass] [_ mass1]]
 
 (partial point-mass-interaction [mass mass1])

)
)

)
