/*
 * Decompiled with CFR 0.152.
 */
package com.leapmotion.leap;

import com.leapmotion.leap.Hand;
import com.leapmotion.leap.Interface;
import com.leapmotion.leap.LeapJNI;
import java.util.Iterator;

public class HandList
extends Interface
implements Iterable<Hand> {
    private long swigCPtr;

    public HandList(long l, boolean bl) {
        super(LeapJNI.HandList_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    public static long getCPtr(HandList handList) {
        return handList == null ? 0L : handList.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LeapJNI.delete_HandList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    @Override
    public Iterator<Hand> iterator() {
        return new HandListIterator();
    }

    public HandList() {
        this(LeapJNI.new_HandList(), true);
    }

    public int count() {
        return LeapJNI.HandList_count(this.swigCPtr, this);
    }

    public boolean isEmpty() {
        return LeapJNI.HandList_isEmpty(this.swigCPtr, this);
    }

    public Hand get(int n) {
        return new Hand(LeapJNI.HandList_get(this.swigCPtr, this, n), true);
    }

    public HandList append(HandList handList) {
        return new HandList(LeapJNI.HandList_append(this.swigCPtr, this, HandList.getCPtr(handList), handList), false);
    }

    public Hand leftmost() {
        return new Hand(LeapJNI.HandList_leftmost(this.swigCPtr, this), true);
    }

    public Hand rightmost() {
        return new Hand(LeapJNI.HandList_rightmost(this.swigCPtr, this), true);
    }

    public Hand frontmost() {
        return new Hand(LeapJNI.HandList_frontmost(this.swigCPtr, this), true);
    }

    public class HandListIterator
    implements Iterator<Hand> {
        int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < HandList.this.count();
        }

        @Override
        public Hand next() {
            return HandList.this.get(this.index++);
        }

        @Override
        public void remove() {
        }
    }
}

