/*
 * Decompiled with CFR 0.152.
 */
package com.leapmotion.leap;

import com.leapmotion.leap.Finger;
import com.leapmotion.leap.FingerList;
import com.leapmotion.leap.Frame;
import com.leapmotion.leap.Interface;
import com.leapmotion.leap.LeapJNI;
import com.leapmotion.leap.Matrix;
import com.leapmotion.leap.Pointable;
import com.leapmotion.leap.PointableList;
import com.leapmotion.leap.Tool;
import com.leapmotion.leap.ToolList;
import com.leapmotion.leap.Vector;

public class Hand
extends Interface {
    private long swigCPtr;

    public Hand(long l, boolean bl) {
        super(LeapJNI.Hand_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    public static long getCPtr(Hand hand) {
        return hand == null ? 0L : hand.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LeapJNI.delete_Hand(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Hand() {
        this(LeapJNI.new_Hand(), true);
    }

    public int id() {
        return LeapJNI.Hand_id(this.swigCPtr, this);
    }

    public Frame frame() {
        return new Frame(LeapJNI.Hand_frame(this.swigCPtr, this), true);
    }

    public PointableList pointables() {
        return new PointableList(LeapJNI.Hand_pointables(this.swigCPtr, this), true);
    }

    public Pointable pointable(int n) {
        return new Pointable(LeapJNI.Hand_pointable(this.swigCPtr, this, n), true);
    }

    public FingerList fingers() {
        return new FingerList(LeapJNI.Hand_fingers(this.swigCPtr, this), true);
    }

    public Finger finger(int n) {
        return new Finger(LeapJNI.Hand_finger(this.swigCPtr, this, n), true);
    }

    public ToolList tools() {
        return new ToolList(LeapJNI.Hand_tools(this.swigCPtr, this), true);
    }

    public Tool tool(int n) {
        return new Tool(LeapJNI.Hand_tool(this.swigCPtr, this, n), true);
    }

    public Vector palmPosition() {
        return new Vector(LeapJNI.Hand_palmPosition(this.swigCPtr, this), true);
    }

    public Vector stabilizedPalmPosition() {
        return new Vector(LeapJNI.Hand_stabilizedPalmPosition(this.swigCPtr, this), true);
    }

    public Vector palmVelocity() {
        return new Vector(LeapJNI.Hand_palmVelocity(this.swigCPtr, this), true);
    }

    public Vector palmNormal() {
        return new Vector(LeapJNI.Hand_palmNormal(this.swigCPtr, this), true);
    }

    public Vector direction() {
        return new Vector(LeapJNI.Hand_direction(this.swigCPtr, this), true);
    }

    public Vector sphereCenter() {
        return new Vector(LeapJNI.Hand_sphereCenter(this.swigCPtr, this), true);
    }

    public float sphereRadius() {
        return LeapJNI.Hand_sphereRadius(this.swigCPtr, this);
    }

    public Vector translation(Frame frame) {
        return new Vector(LeapJNI.Hand_translation(this.swigCPtr, this, Frame.getCPtr(frame), frame), true);
    }

    public float translationProbability(Frame frame) {
        return LeapJNI.Hand_translationProbability(this.swigCPtr, this, Frame.getCPtr(frame), frame);
    }

    public Vector rotationAxis(Frame frame) {
        return new Vector(LeapJNI.Hand_rotationAxis(this.swigCPtr, this, Frame.getCPtr(frame), frame), true);
    }

    public float rotationAngle(Frame frame) {
        return LeapJNI.Hand_rotationAngle__SWIG_0(this.swigCPtr, this, Frame.getCPtr(frame), frame);
    }

    public float rotationAngle(Frame frame, Vector vector) {
        return LeapJNI.Hand_rotationAngle__SWIG_1(this.swigCPtr, this, Frame.getCPtr(frame), frame, Vector.getCPtr(vector), vector);
    }

    public Matrix rotationMatrix(Frame frame) {
        return new Matrix(LeapJNI.Hand_rotationMatrix(this.swigCPtr, this, Frame.getCPtr(frame), frame), true);
    }

    public float rotationProbability(Frame frame) {
        return LeapJNI.Hand_rotationProbability(this.swigCPtr, this, Frame.getCPtr(frame), frame);
    }

    public float scaleFactor(Frame frame) {
        return LeapJNI.Hand_scaleFactor(this.swigCPtr, this, Frame.getCPtr(frame), frame);
    }

    public float scaleProbability(Frame frame) {
        return LeapJNI.Hand_scaleProbability(this.swigCPtr, this, Frame.getCPtr(frame), frame);
    }

    public float timeVisible() {
        return LeapJNI.Hand_timeVisible(this.swigCPtr, this);
    }

    public boolean isValid() {
        return LeapJNI.Hand_isValid(this.swigCPtr, this);
    }

    public static Hand invalid() {
        return new Hand(LeapJNI.Hand_invalid(), false);
    }

    public boolean equals(Hand hand) {
        return LeapJNI.Hand_equals(this.swigCPtr, this, Hand.getCPtr(hand), hand);
    }

    public String toString() {
        return LeapJNI.Hand_toString(this.swigCPtr, this);
    }
}

