/*
 * Decompiled with CFR 0.152.
 */
package rocks.veer66;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import rocks.veer66.CharPrefixTree;
import rocks.veer66.Dag;
import rocks.veer66.DagEdge;
import rocks.veer66.Dix;
import rocks.veer66.Edge;
import rocks.veer66.TextRange;

public class Wordcut {
    CharPrefixTree dix;

    public static List<String> pathToStrList(List<Edge> path, char[] text) {
        return TextRange.fromPath(path).stream().map(r -> String.valueOf(text, r.s, r.e - r.s)).collect(Collectors.toList());
    }

    public Wordcut(CharPrefixTree dix) {
        this.dix = dix;
    }

    public List<TextRange> segment(String text) {
        char[] ch_text = text.toCharArray();
        List<Edge> path = Dag.buildPath(this.dix, ch_text);
        return TextRange.fromPath(path);
    }

    public List<String> segmentToStrList(String text) {
        char[] ch_text = text.toCharArray();
        List<Edge> path = Dag.buildPath(this.dix, ch_text);
        return Wordcut.pathToStrList(path, ch_text);
    }

    public List<List<DagEdge>> buildDag(String text) {
        char[] ch_text = text.toCharArray();
        return Dag.buildDag((CharPrefixTree)this.dix, (char[])ch_text).dag;
    }

    public String putDelimiter(String text, String delim) {
        List<String> strList = this.segmentToStrList(text);
        return String.join((CharSequence)delim, strList);
    }

    public static Wordcut fromDixUrl(URL url) throws IOException {
        InputStreamReader isr = new InputStreamReader(url.openStream(), "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        List<String> lines = br.lines().collect(Collectors.toList());
        CharPrefixTree dix = Dix.createDix(lines);
        return new Wordcut(dix);
    }
}

