/*
 * Decompiled with CFR 0.152.
 */
package rocks.veer66;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import rocks.veer66.DagEdge;
import rocks.veer66.DagEdgeBuilder;
import rocks.veer66.Edge;
import rocks.veer66.EdgeBuilder;
import rocks.veer66.EdgeBuildingContext;
import rocks.veer66.EdgeType;
import rocks.veer66.State;

public class PatEdgeBuilder
implements EdgeBuilder,
DagEdgeBuilder {
    public int start = 0;
    public int i = 0;
    public State state = State.INIT;
    public Predicate<Character> isPatChar;
    public EdgeType etype;
    public static Set<Character> PUNC_SET = new HashSet<Character>();

    PatEdgeBuilder(Predicate<Character> isPatChar, EdgeType etype) {
        this.isPatChar = isPatChar;
        this.etype = etype;
    }

    public State toTextState(Character nch) {
        if (nch != null) {
            return this.isPatChar.test(nch) ? State.NON_PAT_FINAL : State.NON_PAT;
        }
        return State.NON_PAT_FINAL;
    }

    public State toSpaceState(Character nch) {
        if (nch != null) {
            return this.isPatChar.test(nch) ? State.PAT : State.PAT_FINAL;
        }
        return State.PAT_FINAL;
    }

    public State toAnotherState(Character ch, Character nch) {
        return this.isPatChar.test(ch) ? this.toSpaceState(nch) : this.toTextState(nch);
    }

    public boolean isPatFinal() {
        return this.state == State.PAT_FINAL;
    }

    public void transit(Character ch, Character nch) {
        switch (this.state) {
            case INIT: {
                this.start = this.i;
                this.state = this.toAnotherState(ch, nch);
                break;
            }
            case NON_PAT: {
                this.state = this.toAnotherState(ch, nch);
                break;
            }
            case NON_PAT_FINAL: {
                this.start = this.i;
                this.state = this.toSpaceState(nch);
                break;
            }
            case PAT_FINAL: {
                this.start = this.i;
                this.state = this.toTextState(nch);
                break;
            }
            case PAT: {
                this.state = this.toAnotherState(ch, nch);
            }
        }
        ++this.i;
    }

    @Override
    public Edge build(EdgeBuildingContext context, List<Edge> path) {
        Character nextChar = context.i + 1 == context.text.length ? null : Character.valueOf(context.text[context.i + 1]);
        this.transit(Character.valueOf(context.ch), nextChar);
        if (!this.isPatFinal()) {
            return null;
        }
        Edge source = path.get(this.start);
        return new Edge(this.start, this.etype, source.w + 1, source.unk);
    }

    public static PatEdgeBuilder createLatinEdgeBuilder() {
        return new PatEdgeBuilder(ch -> ch.charValue() >= 'A' && ch.charValue() <= 'Z' || ch.charValue() >= 'a' && ch.charValue() <= 'z', EdgeType.LATIN);
    }

    public static PatEdgeBuilder createPuncEdgeBuilder() {
        return new PatEdgeBuilder(ch -> PUNC_SET.contains(ch), EdgeType.PUNC);
    }

    @Override
    public List<DagEdge> buildDagEdges(EdgeBuildingContext context) {
        Character nch = context.i + 1 == context.text.length ? null : Character.valueOf(context.text[context.i + 1]);
        this.transit(Character.valueOf(context.ch), nch);
        if (this.isPatFinal()) {
            return Arrays.asList(new DagEdge(this.start, context.i + 1, this.etype));
        }
        return Arrays.asList(new DagEdge[0]);
    }

    static {
        Arrays.asList(Character.valueOf(' '), Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\"'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('\"'), Character.valueOf('\u201d')).stream().forEach(ch -> PUNC_SET.add((Character)ch));
    }
}

