// Compiled by ClojureScript 1.9.908 {}
goog.provide('reagent.session');
goog.require('cljs.core');
goog.require('reagent.core');
reagent.session.state = reagent.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
 * Returns a cursor from the state atom.
 */
reagent.session.cursor = (function reagent$session$cursor(ks){
return reagent.core.cursor.call(null,reagent.session.state,ks);
});
/**
 * Get the key's value from the session, returns nil if it doesn't exist.
 */
reagent.session.get = (function reagent$session$get(var_args){
var args__55361__auto__ = [];
var len__55354__auto___63373 = arguments.length;
var i__55355__auto___63374 = (0);
while(true){
if((i__55355__auto___63374 < len__55354__auto___63373)){
args__55361__auto__.push((arguments[i__55355__auto___63374]));

var G__63375 = (i__55355__auto___63374 + (1));
i__55355__auto___63374 = G__63375;
continue;
} else {
}
break;
}

var argseq__55362__auto__ = ((((1) < args__55361__auto__.length))?(new cljs.core.IndexedSeq(args__55361__auto__.slice((1)),(0),null)):null);
return reagent.session.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__55362__auto__);
});

reagent.session.get.cljs$core$IFn$_invoke$arity$variadic = (function (k,p__63369){
var vec__63370 = p__63369;
var default$ = cljs.core.nth.call(null,vec__63370,(0),null);
var temp_a = reagent.session.cursor.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null));
if(!((cljs.core.deref.call(null,temp_a) == null))){
return cljs.core.deref.call(null,temp_a);
} else {
return default$;
}
});

reagent.session.get.cljs$lang$maxFixedArity = (1);

reagent.session.get.cljs$lang$applyTo = (function (seq63367){
var G__63368 = cljs.core.first.call(null,seq63367);
var seq63367__$1 = cljs.core.next.call(null,seq63367);
return reagent.session.get.cljs$core$IFn$_invoke$arity$variadic(G__63368,seq63367__$1);
});

reagent.session.put_BANG_ = (function reagent$session$put_BANG_(k,v){
return cljs.core.swap_BANG_.call(null,reagent.session.state,cljs.core.assoc,k,v);
});
/**
 * Gets the value at the path specified by the vector ks from the session,
 *   returns nil if it doesn't exist.
 */
reagent.session.get_in = (function reagent$session$get_in(var_args){
var args__55361__auto__ = [];
var len__55354__auto___63382 = arguments.length;
var i__55355__auto___63383 = (0);
while(true){
if((i__55355__auto___63383 < len__55354__auto___63382)){
args__55361__auto__.push((arguments[i__55355__auto___63383]));

var G__63384 = (i__55355__auto___63383 + (1));
i__55355__auto___63383 = G__63384;
continue;
} else {
}
break;
}

var argseq__55362__auto__ = ((((1) < args__55361__auto__.length))?(new cljs.core.IndexedSeq(args__55361__auto__.slice((1)),(0),null)):null);
return reagent.session.get_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__55362__auto__);
});

reagent.session.get_in.cljs$core$IFn$_invoke$arity$variadic = (function (ks,p__63378){
var vec__63379 = p__63378;
var default$ = cljs.core.nth.call(null,vec__63379,(0),null);
var or__54185__auto__ = cljs.core.deref.call(null,reagent.session.cursor.call(null,ks));
if(cljs.core.truth_(or__54185__auto__)){
return or__54185__auto__;
} else {
return default$;
}
});

reagent.session.get_in.cljs$lang$maxFixedArity = (1);

reagent.session.get_in.cljs$lang$applyTo = (function (seq63376){
var G__63377 = cljs.core.first.call(null,seq63376);
var seq63376__$1 = cljs.core.next.call(null,seq63376);
return reagent.session.get_in.cljs$core$IFn$_invoke$arity$variadic(G__63377,seq63376__$1);
});

/**
 * Replace the current session's value with the result of executing f with
 *   the current value and args.
 */
reagent.session.swap_BANG_ = (function reagent$session$swap_BANG_(var_args){
var args__55361__auto__ = [];
var len__55354__auto___63387 = arguments.length;
var i__55355__auto___63388 = (0);
while(true){
if((i__55355__auto___63388 < len__55354__auto___63387)){
args__55361__auto__.push((arguments[i__55355__auto___63388]));

var G__63389 = (i__55355__auto___63388 + (1));
i__55355__auto___63388 = G__63389;
continue;
} else {
}
break;
}

var argseq__55362__auto__ = ((((1) < args__55361__auto__.length))?(new cljs.core.IndexedSeq(args__55361__auto__.slice((1)),(0),null)):null);
return reagent.session.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__55362__auto__);
});

reagent.session.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.apply.call(null,cljs.core.swap_BANG_,reagent.session.state,f,args);
});

reagent.session.swap_BANG_.cljs$lang$maxFixedArity = (1);

reagent.session.swap_BANG_.cljs$lang$applyTo = (function (seq63385){
var G__63386 = cljs.core.first.call(null,seq63385);
var seq63385__$1 = cljs.core.next.call(null,seq63385);
return reagent.session.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__63386,seq63385__$1);
});

/**
 * Remove all data from the session and start over cleanly.
 */
reagent.session.clear_BANG_ = (function reagent$session$clear_BANG_(){
return cljs.core.reset_BANG_.call(null,reagent.session.state,cljs.core.PersistentArrayMap.EMPTY);
});
reagent.session.reset_BANG_ = (function reagent$session$reset_BANG_(m){
return cljs.core.reset_BANG_.call(null,reagent.session.state,m);
});
/**
 * Remove a key from the session
 */
reagent.session.remove_BANG_ = (function reagent$session$remove_BANG_(k){
return cljs.core.swap_BANG_.call(null,reagent.session.state,cljs.core.dissoc,k);
});
/**
 * Associates a value in the session, where ks is a
 * sequence of keys and v is the new value and returns
 * a new nested structure. If any levels do not exist,
 * hash-maps will be created.
 */
reagent.session.assoc_in_BANG_ = (function reagent$session$assoc_in_BANG_(ks,v){
return cljs.core.swap_BANG_.call(null,reagent.session.state,cljs.core.assoc_in,ks,v);
});
/**
 * Destructive get from the session. This returns the current value of the key
 *   and then removes it from the session.
 */
reagent.session.get_BANG_ = (function reagent$session$get_BANG_(var_args){
var args__55361__auto__ = [];
var len__55354__auto___63396 = arguments.length;
var i__55355__auto___63397 = (0);
while(true){
if((i__55355__auto___63397 < len__55354__auto___63396)){
args__55361__auto__.push((arguments[i__55355__auto___63397]));

var G__63398 = (i__55355__auto___63397 + (1));
i__55355__auto___63397 = G__63398;
continue;
} else {
}
break;
}

var argseq__55362__auto__ = ((((1) < args__55361__auto__.length))?(new cljs.core.IndexedSeq(args__55361__auto__.slice((1)),(0),null)):null);
return reagent.session.get_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__55362__auto__);
});

reagent.session.get_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (k,p__63392){
var vec__63393 = p__63392;
var default$ = cljs.core.nth.call(null,vec__63393,(0),null);
var cur = reagent.session.get.call(null,k,default$);
reagent.session.remove_BANG_.call(null,k);

return cur;
});

reagent.session.get_BANG_.cljs$lang$maxFixedArity = (1);

reagent.session.get_BANG_.cljs$lang$applyTo = (function (seq63390){
var G__63391 = cljs.core.first.call(null,seq63390);
var seq63390__$1 = cljs.core.next.call(null,seq63390);
return reagent.session.get_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__63391,seq63390__$1);
});

/**
 * Destructive get from the session. This returns the current value of the path
 *   specified by the vector ks and then removes it from the session.
 */
reagent.session.get_in_BANG_ = (function reagent$session$get_in_BANG_(var_args){
var args__55361__auto__ = [];
var len__55354__auto___63405 = arguments.length;
var i__55355__auto___63406 = (0);
while(true){
if((i__55355__auto___63406 < len__55354__auto___63405)){
args__55361__auto__.push((arguments[i__55355__auto___63406]));

var G__63407 = (i__55355__auto___63406 + (1));
i__55355__auto___63406 = G__63407;
continue;
} else {
}
break;
}

var argseq__55362__auto__ = ((((1) < args__55361__auto__.length))?(new cljs.core.IndexedSeq(args__55361__auto__.slice((1)),(0),null)):null);
return reagent.session.get_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__55362__auto__);
});

reagent.session.get_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ks,p__63401){
var vec__63402 = p__63401;
var default$ = cljs.core.nth.call(null,vec__63402,(0),null);
var cur = reagent.session.get_in.call(null,ks,default$);
reagent.session.assoc_in_BANG_.call(null,ks,null);

return cur;
});

reagent.session.get_in_BANG_.cljs$lang$maxFixedArity = (1);

reagent.session.get_in_BANG_.cljs$lang$applyTo = (function (seq63399){
var G__63400 = cljs.core.first.call(null,seq63399);
var seq63399__$1 = cljs.core.next.call(null,seq63399);
return reagent.session.get_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__63400,seq63399__$1);
});

/**
 * Updates a value in session where k is a key and f
 * is the function that takes the old value along with any
 * supplied args and return the new value. If key is not
 * present it will be added.
 */
reagent.session.update_BANG_ = (function reagent$session$update_BANG_(var_args){
var args__55361__auto__ = [];
var len__55354__auto___63412 = arguments.length;
var i__55355__auto___63413 = (0);
while(true){
if((i__55355__auto___63413 < len__55354__auto___63412)){
args__55361__auto__.push((arguments[i__55355__auto___63413]));

var G__63414 = (i__55355__auto___63413 + (1));
i__55355__auto___63413 = G__63414;
continue;
} else {
}
break;
}

var argseq__55362__auto__ = ((((2) < args__55361__auto__.length))?(new cljs.core.IndexedSeq(args__55361__auto__.slice((2)),(0),null)):null);
return reagent.session.update_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__55362__auto__);
});

reagent.session.update_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (k,f,args){
return cljs.core.swap_BANG_.call(null,reagent.session.state,(function (p1__63408_SHARP_){
return cljs.core.apply.call(null,cljs.core.partial.call(null,cljs.core.update,p1__63408_SHARP_,k,f),args);
}));
});

reagent.session.update_BANG_.cljs$lang$maxFixedArity = (2);

reagent.session.update_BANG_.cljs$lang$applyTo = (function (seq63409){
var G__63410 = cljs.core.first.call(null,seq63409);
var seq63409__$1 = cljs.core.next.call(null,seq63409);
var G__63411 = cljs.core.first.call(null,seq63409__$1);
var seq63409__$2 = cljs.core.next.call(null,seq63409__$1);
return reagent.session.update_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__63410,G__63411,seq63409__$2);
});

/**
 * 'Updates a value in the session, where ks is a
 * sequence of keys and f is a function that will
 * take the old value along with any supplied args and return
 * the new value. If any levels do not exist, hash-maps
 * will be created.
 */
reagent.session.update_in_BANG_ = (function reagent$session$update_in_BANG_(var_args){
var args__55361__auto__ = [];
var len__55354__auto___63419 = arguments.length;
var i__55355__auto___63420 = (0);
while(true){
if((i__55355__auto___63420 < len__55354__auto___63419)){
args__55361__auto__.push((arguments[i__55355__auto___63420]));

var G__63421 = (i__55355__auto___63420 + (1));
i__55355__auto___63420 = G__63421;
continue;
} else {
}
break;
}

var argseq__55362__auto__ = ((((2) < args__55361__auto__.length))?(new cljs.core.IndexedSeq(args__55361__auto__.slice((2)),(0),null)):null);
return reagent.session.update_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__55362__auto__);
});

reagent.session.update_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ks,f,args){
return cljs.core.swap_BANG_.call(null,reagent.session.state,(function (p1__63415_SHARP_){
return cljs.core.apply.call(null,cljs.core.partial.call(null,cljs.core.update_in,p1__63415_SHARP_,ks,f),args);
}));
});

reagent.session.update_in_BANG_.cljs$lang$maxFixedArity = (2);

reagent.session.update_in_BANG_.cljs$lang$applyTo = (function (seq63416){
var G__63417 = cljs.core.first.call(null,seq63416);
var seq63416__$1 = cljs.core.next.call(null,seq63416);
var G__63418 = cljs.core.first.call(null,seq63416__$1);
var seq63416__$2 = cljs.core.next.call(null,seq63416__$1);
return reagent.session.update_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__63417,G__63418,seq63416__$2);
});


//# sourceMappingURL=session.js.map?rel=1518787489019
