// Compiled by ClojureScript 1.9.908 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__58923 = arguments.length;
switch (G__58923) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async58924 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async58924 = (function (f,blockable,meta58925){
this.f = f;
this.blockable = blockable;
this.meta58925 = meta58925;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async58924.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_58926,meta58925__$1){
var self__ = this;
var _58926__$1 = this;
return (new cljs.core.async.t_cljs$core$async58924(self__.f,self__.blockable,meta58925__$1));
});

cljs.core.async.t_cljs$core$async58924.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_58926){
var self__ = this;
var _58926__$1 = this;
return self__.meta58925;
});

cljs.core.async.t_cljs$core$async58924.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async58924.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async58924.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async58924.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async58924.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta58925","meta58925",-1914201971,null)], null);
});

cljs.core.async.t_cljs$core$async58924.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async58924.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async58924";

cljs.core.async.t_cljs$core$async58924.cljs$lang$ctorPrWriter = (function (this__54810__auto__,writer__54811__auto__,opt__54812__auto__){
return cljs.core._write.call(null,writer__54811__auto__,"cljs.core.async/t_cljs$core$async58924");
});

cljs.core.async.__GT_t_cljs$core$async58924 = (function cljs$core$async$__GT_t_cljs$core$async58924(f__$1,blockable__$1,meta58925){
return (new cljs.core.async.t_cljs$core$async58924(f__$1,blockable__$1,meta58925));
});

}

return (new cljs.core.async.t_cljs$core$async58924(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__58930 = arguments.length;
switch (G__58930) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__58933 = arguments.length;
switch (G__58933) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__58936 = arguments.length;
switch (G__58936) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_58938 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_58938);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_58938,ret){
return (function (){
return fn1.call(null,val_58938);
});})(val_58938,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__58940 = arguments.length;
switch (G__58940) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__55130__auto___58942 = n;
var x_58943 = (0);
while(true){
if((x_58943 < n__55130__auto___58942)){
(a[x_58943] = (0));

var G__58944 = (x_58943 + (1));
x_58943 = G__58944;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__58945 = (i + (1));
i = G__58945;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async58946 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async58946 = (function (flag,meta58947){
this.flag = flag;
this.meta58947 = meta58947;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async58946.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_58948,meta58947__$1){
var self__ = this;
var _58948__$1 = this;
return (new cljs.core.async.t_cljs$core$async58946(self__.flag,meta58947__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async58946.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_58948){
var self__ = this;
var _58948__$1 = this;
return self__.meta58947;
});})(flag))
;

cljs.core.async.t_cljs$core$async58946.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async58946.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async58946.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async58946.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async58946.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta58947","meta58947",-981294898,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async58946.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async58946.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async58946";

cljs.core.async.t_cljs$core$async58946.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__54810__auto__,writer__54811__auto__,opt__54812__auto__){
return cljs.core._write.call(null,writer__54811__auto__,"cljs.core.async/t_cljs$core$async58946");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async58946 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async58946(flag__$1,meta58947){
return (new cljs.core.async.t_cljs$core$async58946(flag__$1,meta58947));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async58946(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async58949 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async58949 = (function (flag,cb,meta58950){
this.flag = flag;
this.cb = cb;
this.meta58950 = meta58950;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async58949.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_58951,meta58950__$1){
var self__ = this;
var _58951__$1 = this;
return (new cljs.core.async.t_cljs$core$async58949(self__.flag,self__.cb,meta58950__$1));
});

cljs.core.async.t_cljs$core$async58949.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_58951){
var self__ = this;
var _58951__$1 = this;
return self__.meta58950;
});

cljs.core.async.t_cljs$core$async58949.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async58949.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async58949.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async58949.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async58949.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta58950","meta58950",106304394,null)], null);
});

cljs.core.async.t_cljs$core$async58949.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async58949.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async58949";

cljs.core.async.t_cljs$core$async58949.cljs$lang$ctorPrWriter = (function (this__54810__auto__,writer__54811__auto__,opt__54812__auto__){
return cljs.core._write.call(null,writer__54811__auto__,"cljs.core.async/t_cljs$core$async58949");
});

cljs.core.async.__GT_t_cljs$core$async58949 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async58949(flag__$1,cb__$1,meta58950){
return (new cljs.core.async.t_cljs$core$async58949(flag__$1,cb__$1,meta58950));
});

}

return (new cljs.core.async.t_cljs$core$async58949(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__58952_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__58952_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__58953_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__58953_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__54185__auto__ = wport;
if(cljs.core.truth_(or__54185__auto__)){
return or__54185__auto__;
} else {
return port;
}
})()], null));
} else {
var G__58954 = (i + (1));
i = G__58954;
continue;
}
} else {
return null;
}
break;
}
})();
var or__54185__auto__ = ret;
if(cljs.core.truth_(or__54185__auto__)){
return or__54185__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__54173__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__54173__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__54173__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__55361__auto__ = [];
var len__55354__auto___58960 = arguments.length;
var i__55355__auto___58961 = (0);
while(true){
if((i__55355__auto___58961 < len__55354__auto___58960)){
args__55361__auto__.push((arguments[i__55355__auto___58961]));

var G__58962 = (i__55355__auto___58961 + (1));
i__55355__auto___58961 = G__58962;
continue;
} else {
}
break;
}

var argseq__55362__auto__ = ((((1) < args__55361__auto__.length))?(new cljs.core.IndexedSeq(args__55361__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__55362__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__58957){
var map__58958 = p__58957;
var map__58958__$1 = ((((!((map__58958 == null)))?((((map__58958.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58958.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58958):map__58958);
var opts = map__58958__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq58955){
var G__58956 = cljs.core.first.call(null,seq58955);
var seq58955__$1 = cljs.core.next.call(null,seq58955);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__58956,seq58955__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__58964 = arguments.length;
switch (G__58964) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__58877__auto___59010 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___59010){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___59010){
return (function (state_58988){
var state_val_58989 = (state_58988[(1)]);
if((state_val_58989 === (7))){
var inst_58984 = (state_58988[(2)]);
var state_58988__$1 = state_58988;
var statearr_58990_59011 = state_58988__$1;
(statearr_58990_59011[(2)] = inst_58984);

(statearr_58990_59011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58989 === (1))){
var state_58988__$1 = state_58988;
var statearr_58991_59012 = state_58988__$1;
(statearr_58991_59012[(2)] = null);

(statearr_58991_59012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58989 === (4))){
var inst_58967 = (state_58988[(7)]);
var inst_58967__$1 = (state_58988[(2)]);
var inst_58968 = (inst_58967__$1 == null);
var state_58988__$1 = (function (){var statearr_58992 = state_58988;
(statearr_58992[(7)] = inst_58967__$1);

return statearr_58992;
})();
if(cljs.core.truth_(inst_58968)){
var statearr_58993_59013 = state_58988__$1;
(statearr_58993_59013[(1)] = (5));

} else {
var statearr_58994_59014 = state_58988__$1;
(statearr_58994_59014[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58989 === (13))){
var state_58988__$1 = state_58988;
var statearr_58995_59015 = state_58988__$1;
(statearr_58995_59015[(2)] = null);

(statearr_58995_59015[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58989 === (6))){
var inst_58967 = (state_58988[(7)]);
var state_58988__$1 = state_58988;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58988__$1,(11),to,inst_58967);
} else {
if((state_val_58989 === (3))){
var inst_58986 = (state_58988[(2)]);
var state_58988__$1 = state_58988;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58988__$1,inst_58986);
} else {
if((state_val_58989 === (12))){
var state_58988__$1 = state_58988;
var statearr_58996_59016 = state_58988__$1;
(statearr_58996_59016[(2)] = null);

(statearr_58996_59016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58989 === (2))){
var state_58988__$1 = state_58988;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58988__$1,(4),from);
} else {
if((state_val_58989 === (11))){
var inst_58977 = (state_58988[(2)]);
var state_58988__$1 = state_58988;
if(cljs.core.truth_(inst_58977)){
var statearr_58997_59017 = state_58988__$1;
(statearr_58997_59017[(1)] = (12));

} else {
var statearr_58998_59018 = state_58988__$1;
(statearr_58998_59018[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58989 === (9))){
var state_58988__$1 = state_58988;
var statearr_58999_59019 = state_58988__$1;
(statearr_58999_59019[(2)] = null);

(statearr_58999_59019[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58989 === (5))){
var state_58988__$1 = state_58988;
if(cljs.core.truth_(close_QMARK_)){
var statearr_59000_59020 = state_58988__$1;
(statearr_59000_59020[(1)] = (8));

} else {
var statearr_59001_59021 = state_58988__$1;
(statearr_59001_59021[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58989 === (14))){
var inst_58982 = (state_58988[(2)]);
var state_58988__$1 = state_58988;
var statearr_59002_59022 = state_58988__$1;
(statearr_59002_59022[(2)] = inst_58982);

(statearr_59002_59022[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58989 === (10))){
var inst_58974 = (state_58988[(2)]);
var state_58988__$1 = state_58988;
var statearr_59003_59023 = state_58988__$1;
(statearr_59003_59023[(2)] = inst_58974);

(statearr_59003_59023[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58989 === (8))){
var inst_58971 = cljs.core.async.close_BANG_.call(null,to);
var state_58988__$1 = state_58988;
var statearr_59004_59024 = state_58988__$1;
(statearr_59004_59024[(2)] = inst_58971);

(statearr_59004_59024[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___59010))
;
return ((function (switch__58824__auto__,c__58877__auto___59010){
return (function() {
var cljs$core$async$state_machine__58825__auto__ = null;
var cljs$core$async$state_machine__58825__auto____0 = (function (){
var statearr_59005 = [null,null,null,null,null,null,null,null];
(statearr_59005[(0)] = cljs$core$async$state_machine__58825__auto__);

(statearr_59005[(1)] = (1));

return statearr_59005;
});
var cljs$core$async$state_machine__58825__auto____1 = (function (state_58988){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_58988);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e59006){if((e59006 instanceof Object)){
var ex__58828__auto__ = e59006;
var statearr_59007_59025 = state_58988;
(statearr_59007_59025[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58988);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59006;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59026 = state_58988;
state_58988 = G__59026;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$state_machine__58825__auto__ = function(state_58988){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__58825__auto____1.call(this,state_58988);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__58825__auto____0;
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__58825__auto____1;
return cljs$core$async$state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___59010))
})();
var state__58879__auto__ = (function (){var statearr_59008 = f__58878__auto__.call(null);
(statearr_59008[(6)] = c__58877__auto___59010);

return statearr_59008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___59010))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__59027){
var vec__59028 = p__59027;
var v = cljs.core.nth.call(null,vec__59028,(0),null);
var p = cljs.core.nth.call(null,vec__59028,(1),null);
var job = vec__59028;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__58877__auto___59199 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___59199,res,vec__59028,v,p,job,jobs,results){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___59199,res,vec__59028,v,p,job,jobs,results){
return (function (state_59035){
var state_val_59036 = (state_59035[(1)]);
if((state_val_59036 === (1))){
var state_59035__$1 = state_59035;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59035__$1,(2),res,v);
} else {
if((state_val_59036 === (2))){
var inst_59032 = (state_59035[(2)]);
var inst_59033 = cljs.core.async.close_BANG_.call(null,res);
var state_59035__$1 = (function (){var statearr_59037 = state_59035;
(statearr_59037[(7)] = inst_59032);

return statearr_59037;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59035__$1,inst_59033);
} else {
return null;
}
}
});})(c__58877__auto___59199,res,vec__59028,v,p,job,jobs,results))
;
return ((function (switch__58824__auto__,c__58877__auto___59199,res,vec__59028,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0 = (function (){
var statearr_59038 = [null,null,null,null,null,null,null,null];
(statearr_59038[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__);

(statearr_59038[(1)] = (1));

return statearr_59038;
});
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1 = (function (state_59035){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_59035);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e59039){if((e59039 instanceof Object)){
var ex__58828__auto__ = e59039;
var statearr_59040_59200 = state_59035;
(statearr_59040_59200[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59035);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59039;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59201 = state_59035;
state_59035 = G__59201;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__ = function(state_59035){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1.call(this,state_59035);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___59199,res,vec__59028,v,p,job,jobs,results))
})();
var state__58879__auto__ = (function (){var statearr_59041 = f__58878__auto__.call(null);
(statearr_59041[(6)] = c__58877__auto___59199);

return statearr_59041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___59199,res,vec__59028,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__59042){
var vec__59043 = p__59042;
var v = cljs.core.nth.call(null,vec__59043,(0),null);
var p = cljs.core.nth.call(null,vec__59043,(1),null);
var job = vec__59043;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__55130__auto___59202 = n;
var __59203 = (0);
while(true){
if((__59203 < n__55130__auto___59202)){
var G__59046_59204 = type;
var G__59046_59205__$1 = (((G__59046_59204 instanceof cljs.core.Keyword))?G__59046_59204.fqn:null);
switch (G__59046_59205__$1) {
case "compute":
var c__58877__auto___59207 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__59203,c__58877__auto___59207,G__59046_59204,G__59046_59205__$1,n__55130__auto___59202,jobs,results,process,async){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (__59203,c__58877__auto___59207,G__59046_59204,G__59046_59205__$1,n__55130__auto___59202,jobs,results,process,async){
return (function (state_59059){
var state_val_59060 = (state_59059[(1)]);
if((state_val_59060 === (1))){
var state_59059__$1 = state_59059;
var statearr_59061_59208 = state_59059__$1;
(statearr_59061_59208[(2)] = null);

(statearr_59061_59208[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59060 === (2))){
var state_59059__$1 = state_59059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59059__$1,(4),jobs);
} else {
if((state_val_59060 === (3))){
var inst_59057 = (state_59059[(2)]);
var state_59059__$1 = state_59059;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59059__$1,inst_59057);
} else {
if((state_val_59060 === (4))){
var inst_59049 = (state_59059[(2)]);
var inst_59050 = process.call(null,inst_59049);
var state_59059__$1 = state_59059;
if(cljs.core.truth_(inst_59050)){
var statearr_59062_59209 = state_59059__$1;
(statearr_59062_59209[(1)] = (5));

} else {
var statearr_59063_59210 = state_59059__$1;
(statearr_59063_59210[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59060 === (5))){
var state_59059__$1 = state_59059;
var statearr_59064_59211 = state_59059__$1;
(statearr_59064_59211[(2)] = null);

(statearr_59064_59211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59060 === (6))){
var state_59059__$1 = state_59059;
var statearr_59065_59212 = state_59059__$1;
(statearr_59065_59212[(2)] = null);

(statearr_59065_59212[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59060 === (7))){
var inst_59055 = (state_59059[(2)]);
var state_59059__$1 = state_59059;
var statearr_59066_59213 = state_59059__$1;
(statearr_59066_59213[(2)] = inst_59055);

(statearr_59066_59213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__59203,c__58877__auto___59207,G__59046_59204,G__59046_59205__$1,n__55130__auto___59202,jobs,results,process,async))
;
return ((function (__59203,switch__58824__auto__,c__58877__auto___59207,G__59046_59204,G__59046_59205__$1,n__55130__auto___59202,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0 = (function (){
var statearr_59067 = [null,null,null,null,null,null,null];
(statearr_59067[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__);

(statearr_59067[(1)] = (1));

return statearr_59067;
});
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1 = (function (state_59059){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_59059);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e59068){if((e59068 instanceof Object)){
var ex__58828__auto__ = e59068;
var statearr_59069_59214 = state_59059;
(statearr_59069_59214[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59059);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59068;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59215 = state_59059;
state_59059 = G__59215;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__ = function(state_59059){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1.call(this,state_59059);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__;
})()
;})(__59203,switch__58824__auto__,c__58877__auto___59207,G__59046_59204,G__59046_59205__$1,n__55130__auto___59202,jobs,results,process,async))
})();
var state__58879__auto__ = (function (){var statearr_59070 = f__58878__auto__.call(null);
(statearr_59070[(6)] = c__58877__auto___59207);

return statearr_59070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(__59203,c__58877__auto___59207,G__59046_59204,G__59046_59205__$1,n__55130__auto___59202,jobs,results,process,async))
);


break;
case "async":
var c__58877__auto___59216 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__59203,c__58877__auto___59216,G__59046_59204,G__59046_59205__$1,n__55130__auto___59202,jobs,results,process,async){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (__59203,c__58877__auto___59216,G__59046_59204,G__59046_59205__$1,n__55130__auto___59202,jobs,results,process,async){
return (function (state_59083){
var state_val_59084 = (state_59083[(1)]);
if((state_val_59084 === (1))){
var state_59083__$1 = state_59083;
var statearr_59085_59217 = state_59083__$1;
(statearr_59085_59217[(2)] = null);

(statearr_59085_59217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59084 === (2))){
var state_59083__$1 = state_59083;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59083__$1,(4),jobs);
} else {
if((state_val_59084 === (3))){
var inst_59081 = (state_59083[(2)]);
var state_59083__$1 = state_59083;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59083__$1,inst_59081);
} else {
if((state_val_59084 === (4))){
var inst_59073 = (state_59083[(2)]);
var inst_59074 = async.call(null,inst_59073);
var state_59083__$1 = state_59083;
if(cljs.core.truth_(inst_59074)){
var statearr_59086_59218 = state_59083__$1;
(statearr_59086_59218[(1)] = (5));

} else {
var statearr_59087_59219 = state_59083__$1;
(statearr_59087_59219[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59084 === (5))){
var state_59083__$1 = state_59083;
var statearr_59088_59220 = state_59083__$1;
(statearr_59088_59220[(2)] = null);

(statearr_59088_59220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59084 === (6))){
var state_59083__$1 = state_59083;
var statearr_59089_59221 = state_59083__$1;
(statearr_59089_59221[(2)] = null);

(statearr_59089_59221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59084 === (7))){
var inst_59079 = (state_59083[(2)]);
var state_59083__$1 = state_59083;
var statearr_59090_59222 = state_59083__$1;
(statearr_59090_59222[(2)] = inst_59079);

(statearr_59090_59222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__59203,c__58877__auto___59216,G__59046_59204,G__59046_59205__$1,n__55130__auto___59202,jobs,results,process,async))
;
return ((function (__59203,switch__58824__auto__,c__58877__auto___59216,G__59046_59204,G__59046_59205__$1,n__55130__auto___59202,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0 = (function (){
var statearr_59091 = [null,null,null,null,null,null,null];
(statearr_59091[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__);

(statearr_59091[(1)] = (1));

return statearr_59091;
});
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1 = (function (state_59083){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_59083);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e59092){if((e59092 instanceof Object)){
var ex__58828__auto__ = e59092;
var statearr_59093_59223 = state_59083;
(statearr_59093_59223[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59083);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59092;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59224 = state_59083;
state_59083 = G__59224;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__ = function(state_59083){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1.call(this,state_59083);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__;
})()
;})(__59203,switch__58824__auto__,c__58877__auto___59216,G__59046_59204,G__59046_59205__$1,n__55130__auto___59202,jobs,results,process,async))
})();
var state__58879__auto__ = (function (){var statearr_59094 = f__58878__auto__.call(null);
(statearr_59094[(6)] = c__58877__auto___59216);

return statearr_59094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(__59203,c__58877__auto___59216,G__59046_59204,G__59046_59205__$1,n__55130__auto___59202,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__59046_59205__$1)].join('')));

}

var G__59225 = (__59203 + (1));
__59203 = G__59225;
continue;
} else {
}
break;
}

var c__58877__auto___59226 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___59226,jobs,results,process,async){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___59226,jobs,results,process,async){
return (function (state_59116){
var state_val_59117 = (state_59116[(1)]);
if((state_val_59117 === (1))){
var state_59116__$1 = state_59116;
var statearr_59118_59227 = state_59116__$1;
(statearr_59118_59227[(2)] = null);

(statearr_59118_59227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59117 === (2))){
var state_59116__$1 = state_59116;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59116__$1,(4),from);
} else {
if((state_val_59117 === (3))){
var inst_59114 = (state_59116[(2)]);
var state_59116__$1 = state_59116;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59116__$1,inst_59114);
} else {
if((state_val_59117 === (4))){
var inst_59097 = (state_59116[(7)]);
var inst_59097__$1 = (state_59116[(2)]);
var inst_59098 = (inst_59097__$1 == null);
var state_59116__$1 = (function (){var statearr_59119 = state_59116;
(statearr_59119[(7)] = inst_59097__$1);

return statearr_59119;
})();
if(cljs.core.truth_(inst_59098)){
var statearr_59120_59228 = state_59116__$1;
(statearr_59120_59228[(1)] = (5));

} else {
var statearr_59121_59229 = state_59116__$1;
(statearr_59121_59229[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59117 === (5))){
var inst_59100 = cljs.core.async.close_BANG_.call(null,jobs);
var state_59116__$1 = state_59116;
var statearr_59122_59230 = state_59116__$1;
(statearr_59122_59230[(2)] = inst_59100);

(statearr_59122_59230[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59117 === (6))){
var inst_59097 = (state_59116[(7)]);
var inst_59102 = (state_59116[(8)]);
var inst_59102__$1 = cljs.core.async.chan.call(null,(1));
var inst_59103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59104 = [inst_59097,inst_59102__$1];
var inst_59105 = (new cljs.core.PersistentVector(null,2,(5),inst_59103,inst_59104,null));
var state_59116__$1 = (function (){var statearr_59123 = state_59116;
(statearr_59123[(8)] = inst_59102__$1);

return statearr_59123;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59116__$1,(8),jobs,inst_59105);
} else {
if((state_val_59117 === (7))){
var inst_59112 = (state_59116[(2)]);
var state_59116__$1 = state_59116;
var statearr_59124_59231 = state_59116__$1;
(statearr_59124_59231[(2)] = inst_59112);

(statearr_59124_59231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59117 === (8))){
var inst_59102 = (state_59116[(8)]);
var inst_59107 = (state_59116[(2)]);
var state_59116__$1 = (function (){var statearr_59125 = state_59116;
(statearr_59125[(9)] = inst_59107);

return statearr_59125;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59116__$1,(9),results,inst_59102);
} else {
if((state_val_59117 === (9))){
var inst_59109 = (state_59116[(2)]);
var state_59116__$1 = (function (){var statearr_59126 = state_59116;
(statearr_59126[(10)] = inst_59109);

return statearr_59126;
})();
var statearr_59127_59232 = state_59116__$1;
(statearr_59127_59232[(2)] = null);

(statearr_59127_59232[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___59226,jobs,results,process,async))
;
return ((function (switch__58824__auto__,c__58877__auto___59226,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0 = (function (){
var statearr_59128 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_59128[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__);

(statearr_59128[(1)] = (1));

return statearr_59128;
});
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1 = (function (state_59116){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_59116);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e59129){if((e59129 instanceof Object)){
var ex__58828__auto__ = e59129;
var statearr_59130_59233 = state_59116;
(statearr_59130_59233[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59116);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59129;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59234 = state_59116;
state_59116 = G__59234;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__ = function(state_59116){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1.call(this,state_59116);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___59226,jobs,results,process,async))
})();
var state__58879__auto__ = (function (){var statearr_59131 = f__58878__auto__.call(null);
(statearr_59131[(6)] = c__58877__auto___59226);

return statearr_59131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___59226,jobs,results,process,async))
);


var c__58877__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto__,jobs,results,process,async){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto__,jobs,results,process,async){
return (function (state_59169){
var state_val_59170 = (state_59169[(1)]);
if((state_val_59170 === (7))){
var inst_59165 = (state_59169[(2)]);
var state_59169__$1 = state_59169;
var statearr_59171_59235 = state_59169__$1;
(statearr_59171_59235[(2)] = inst_59165);

(statearr_59171_59235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (20))){
var state_59169__$1 = state_59169;
var statearr_59172_59236 = state_59169__$1;
(statearr_59172_59236[(2)] = null);

(statearr_59172_59236[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (1))){
var state_59169__$1 = state_59169;
var statearr_59173_59237 = state_59169__$1;
(statearr_59173_59237[(2)] = null);

(statearr_59173_59237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (4))){
var inst_59134 = (state_59169[(7)]);
var inst_59134__$1 = (state_59169[(2)]);
var inst_59135 = (inst_59134__$1 == null);
var state_59169__$1 = (function (){var statearr_59174 = state_59169;
(statearr_59174[(7)] = inst_59134__$1);

return statearr_59174;
})();
if(cljs.core.truth_(inst_59135)){
var statearr_59175_59238 = state_59169__$1;
(statearr_59175_59238[(1)] = (5));

} else {
var statearr_59176_59239 = state_59169__$1;
(statearr_59176_59239[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (15))){
var inst_59147 = (state_59169[(8)]);
var state_59169__$1 = state_59169;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59169__$1,(18),to,inst_59147);
} else {
if((state_val_59170 === (21))){
var inst_59160 = (state_59169[(2)]);
var state_59169__$1 = state_59169;
var statearr_59177_59240 = state_59169__$1;
(statearr_59177_59240[(2)] = inst_59160);

(statearr_59177_59240[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (13))){
var inst_59162 = (state_59169[(2)]);
var state_59169__$1 = (function (){var statearr_59178 = state_59169;
(statearr_59178[(9)] = inst_59162);

return statearr_59178;
})();
var statearr_59179_59241 = state_59169__$1;
(statearr_59179_59241[(2)] = null);

(statearr_59179_59241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (6))){
var inst_59134 = (state_59169[(7)]);
var state_59169__$1 = state_59169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59169__$1,(11),inst_59134);
} else {
if((state_val_59170 === (17))){
var inst_59155 = (state_59169[(2)]);
var state_59169__$1 = state_59169;
if(cljs.core.truth_(inst_59155)){
var statearr_59180_59242 = state_59169__$1;
(statearr_59180_59242[(1)] = (19));

} else {
var statearr_59181_59243 = state_59169__$1;
(statearr_59181_59243[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (3))){
var inst_59167 = (state_59169[(2)]);
var state_59169__$1 = state_59169;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59169__$1,inst_59167);
} else {
if((state_val_59170 === (12))){
var inst_59144 = (state_59169[(10)]);
var state_59169__$1 = state_59169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59169__$1,(14),inst_59144);
} else {
if((state_val_59170 === (2))){
var state_59169__$1 = state_59169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59169__$1,(4),results);
} else {
if((state_val_59170 === (19))){
var state_59169__$1 = state_59169;
var statearr_59182_59244 = state_59169__$1;
(statearr_59182_59244[(2)] = null);

(statearr_59182_59244[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (11))){
var inst_59144 = (state_59169[(2)]);
var state_59169__$1 = (function (){var statearr_59183 = state_59169;
(statearr_59183[(10)] = inst_59144);

return statearr_59183;
})();
var statearr_59184_59245 = state_59169__$1;
(statearr_59184_59245[(2)] = null);

(statearr_59184_59245[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (9))){
var state_59169__$1 = state_59169;
var statearr_59185_59246 = state_59169__$1;
(statearr_59185_59246[(2)] = null);

(statearr_59185_59246[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (5))){
var state_59169__$1 = state_59169;
if(cljs.core.truth_(close_QMARK_)){
var statearr_59186_59247 = state_59169__$1;
(statearr_59186_59247[(1)] = (8));

} else {
var statearr_59187_59248 = state_59169__$1;
(statearr_59187_59248[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (14))){
var inst_59147 = (state_59169[(8)]);
var inst_59149 = (state_59169[(11)]);
var inst_59147__$1 = (state_59169[(2)]);
var inst_59148 = (inst_59147__$1 == null);
var inst_59149__$1 = cljs.core.not.call(null,inst_59148);
var state_59169__$1 = (function (){var statearr_59188 = state_59169;
(statearr_59188[(8)] = inst_59147__$1);

(statearr_59188[(11)] = inst_59149__$1);

return statearr_59188;
})();
if(inst_59149__$1){
var statearr_59189_59249 = state_59169__$1;
(statearr_59189_59249[(1)] = (15));

} else {
var statearr_59190_59250 = state_59169__$1;
(statearr_59190_59250[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (16))){
var inst_59149 = (state_59169[(11)]);
var state_59169__$1 = state_59169;
var statearr_59191_59251 = state_59169__$1;
(statearr_59191_59251[(2)] = inst_59149);

(statearr_59191_59251[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (10))){
var inst_59141 = (state_59169[(2)]);
var state_59169__$1 = state_59169;
var statearr_59192_59252 = state_59169__$1;
(statearr_59192_59252[(2)] = inst_59141);

(statearr_59192_59252[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (18))){
var inst_59152 = (state_59169[(2)]);
var state_59169__$1 = state_59169;
var statearr_59193_59253 = state_59169__$1;
(statearr_59193_59253[(2)] = inst_59152);

(statearr_59193_59253[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59170 === (8))){
var inst_59138 = cljs.core.async.close_BANG_.call(null,to);
var state_59169__$1 = state_59169;
var statearr_59194_59254 = state_59169__$1;
(statearr_59194_59254[(2)] = inst_59138);

(statearr_59194_59254[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto__,jobs,results,process,async))
;
return ((function (switch__58824__auto__,c__58877__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0 = (function (){
var statearr_59195 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59195[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__);

(statearr_59195[(1)] = (1));

return statearr_59195;
});
var cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1 = (function (state_59169){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_59169);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e59196){if((e59196 instanceof Object)){
var ex__58828__auto__ = e59196;
var statearr_59197_59255 = state_59169;
(statearr_59197_59255[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59169);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59196;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59256 = state_59169;
state_59169 = G__59256;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__ = function(state_59169){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1.call(this,state_59169);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__58825__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto__,jobs,results,process,async))
})();
var state__58879__auto__ = (function (){var statearr_59198 = f__58878__auto__.call(null);
(statearr_59198[(6)] = c__58877__auto__);

return statearr_59198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto__,jobs,results,process,async))
);

return c__58877__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__59258 = arguments.length;
switch (G__59258) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__59261 = arguments.length;
switch (G__59261) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__59264 = arguments.length;
switch (G__59264) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__58877__auto___59313 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___59313,tc,fc){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___59313,tc,fc){
return (function (state_59290){
var state_val_59291 = (state_59290[(1)]);
if((state_val_59291 === (7))){
var inst_59286 = (state_59290[(2)]);
var state_59290__$1 = state_59290;
var statearr_59292_59314 = state_59290__$1;
(statearr_59292_59314[(2)] = inst_59286);

(statearr_59292_59314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59291 === (1))){
var state_59290__$1 = state_59290;
var statearr_59293_59315 = state_59290__$1;
(statearr_59293_59315[(2)] = null);

(statearr_59293_59315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59291 === (4))){
var inst_59267 = (state_59290[(7)]);
var inst_59267__$1 = (state_59290[(2)]);
var inst_59268 = (inst_59267__$1 == null);
var state_59290__$1 = (function (){var statearr_59294 = state_59290;
(statearr_59294[(7)] = inst_59267__$1);

return statearr_59294;
})();
if(cljs.core.truth_(inst_59268)){
var statearr_59295_59316 = state_59290__$1;
(statearr_59295_59316[(1)] = (5));

} else {
var statearr_59296_59317 = state_59290__$1;
(statearr_59296_59317[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59291 === (13))){
var state_59290__$1 = state_59290;
var statearr_59297_59318 = state_59290__$1;
(statearr_59297_59318[(2)] = null);

(statearr_59297_59318[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59291 === (6))){
var inst_59267 = (state_59290[(7)]);
var inst_59273 = p.call(null,inst_59267);
var state_59290__$1 = state_59290;
if(cljs.core.truth_(inst_59273)){
var statearr_59298_59319 = state_59290__$1;
(statearr_59298_59319[(1)] = (9));

} else {
var statearr_59299_59320 = state_59290__$1;
(statearr_59299_59320[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59291 === (3))){
var inst_59288 = (state_59290[(2)]);
var state_59290__$1 = state_59290;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59290__$1,inst_59288);
} else {
if((state_val_59291 === (12))){
var state_59290__$1 = state_59290;
var statearr_59300_59321 = state_59290__$1;
(statearr_59300_59321[(2)] = null);

(statearr_59300_59321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59291 === (2))){
var state_59290__$1 = state_59290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59290__$1,(4),ch);
} else {
if((state_val_59291 === (11))){
var inst_59267 = (state_59290[(7)]);
var inst_59277 = (state_59290[(2)]);
var state_59290__$1 = state_59290;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59290__$1,(8),inst_59277,inst_59267);
} else {
if((state_val_59291 === (9))){
var state_59290__$1 = state_59290;
var statearr_59301_59322 = state_59290__$1;
(statearr_59301_59322[(2)] = tc);

(statearr_59301_59322[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59291 === (5))){
var inst_59270 = cljs.core.async.close_BANG_.call(null,tc);
var inst_59271 = cljs.core.async.close_BANG_.call(null,fc);
var state_59290__$1 = (function (){var statearr_59302 = state_59290;
(statearr_59302[(8)] = inst_59270);

return statearr_59302;
})();
var statearr_59303_59323 = state_59290__$1;
(statearr_59303_59323[(2)] = inst_59271);

(statearr_59303_59323[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59291 === (14))){
var inst_59284 = (state_59290[(2)]);
var state_59290__$1 = state_59290;
var statearr_59304_59324 = state_59290__$1;
(statearr_59304_59324[(2)] = inst_59284);

(statearr_59304_59324[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59291 === (10))){
var state_59290__$1 = state_59290;
var statearr_59305_59325 = state_59290__$1;
(statearr_59305_59325[(2)] = fc);

(statearr_59305_59325[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59291 === (8))){
var inst_59279 = (state_59290[(2)]);
var state_59290__$1 = state_59290;
if(cljs.core.truth_(inst_59279)){
var statearr_59306_59326 = state_59290__$1;
(statearr_59306_59326[(1)] = (12));

} else {
var statearr_59307_59327 = state_59290__$1;
(statearr_59307_59327[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___59313,tc,fc))
;
return ((function (switch__58824__auto__,c__58877__auto___59313,tc,fc){
return (function() {
var cljs$core$async$state_machine__58825__auto__ = null;
var cljs$core$async$state_machine__58825__auto____0 = (function (){
var statearr_59308 = [null,null,null,null,null,null,null,null,null];
(statearr_59308[(0)] = cljs$core$async$state_machine__58825__auto__);

(statearr_59308[(1)] = (1));

return statearr_59308;
});
var cljs$core$async$state_machine__58825__auto____1 = (function (state_59290){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_59290);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e59309){if((e59309 instanceof Object)){
var ex__58828__auto__ = e59309;
var statearr_59310_59328 = state_59290;
(statearr_59310_59328[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59290);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59309;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59329 = state_59290;
state_59290 = G__59329;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$state_machine__58825__auto__ = function(state_59290){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__58825__auto____1.call(this,state_59290);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__58825__auto____0;
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__58825__auto____1;
return cljs$core$async$state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___59313,tc,fc))
})();
var state__58879__auto__ = (function (){var statearr_59311 = f__58878__auto__.call(null);
(statearr_59311[(6)] = c__58877__auto___59313);

return statearr_59311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___59313,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__58877__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto__){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto__){
return (function (state_59350){
var state_val_59351 = (state_59350[(1)]);
if((state_val_59351 === (7))){
var inst_59346 = (state_59350[(2)]);
var state_59350__$1 = state_59350;
var statearr_59352_59370 = state_59350__$1;
(statearr_59352_59370[(2)] = inst_59346);

(statearr_59352_59370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59351 === (1))){
var inst_59330 = init;
var state_59350__$1 = (function (){var statearr_59353 = state_59350;
(statearr_59353[(7)] = inst_59330);

return statearr_59353;
})();
var statearr_59354_59371 = state_59350__$1;
(statearr_59354_59371[(2)] = null);

(statearr_59354_59371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59351 === (4))){
var inst_59333 = (state_59350[(8)]);
var inst_59333__$1 = (state_59350[(2)]);
var inst_59334 = (inst_59333__$1 == null);
var state_59350__$1 = (function (){var statearr_59355 = state_59350;
(statearr_59355[(8)] = inst_59333__$1);

return statearr_59355;
})();
if(cljs.core.truth_(inst_59334)){
var statearr_59356_59372 = state_59350__$1;
(statearr_59356_59372[(1)] = (5));

} else {
var statearr_59357_59373 = state_59350__$1;
(statearr_59357_59373[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59351 === (6))){
var inst_59330 = (state_59350[(7)]);
var inst_59333 = (state_59350[(8)]);
var inst_59337 = (state_59350[(9)]);
var inst_59337__$1 = f.call(null,inst_59330,inst_59333);
var inst_59338 = cljs.core.reduced_QMARK_.call(null,inst_59337__$1);
var state_59350__$1 = (function (){var statearr_59358 = state_59350;
(statearr_59358[(9)] = inst_59337__$1);

return statearr_59358;
})();
if(inst_59338){
var statearr_59359_59374 = state_59350__$1;
(statearr_59359_59374[(1)] = (8));

} else {
var statearr_59360_59375 = state_59350__$1;
(statearr_59360_59375[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59351 === (3))){
var inst_59348 = (state_59350[(2)]);
var state_59350__$1 = state_59350;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59350__$1,inst_59348);
} else {
if((state_val_59351 === (2))){
var state_59350__$1 = state_59350;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59350__$1,(4),ch);
} else {
if((state_val_59351 === (9))){
var inst_59337 = (state_59350[(9)]);
var inst_59330 = inst_59337;
var state_59350__$1 = (function (){var statearr_59361 = state_59350;
(statearr_59361[(7)] = inst_59330);

return statearr_59361;
})();
var statearr_59362_59376 = state_59350__$1;
(statearr_59362_59376[(2)] = null);

(statearr_59362_59376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59351 === (5))){
var inst_59330 = (state_59350[(7)]);
var state_59350__$1 = state_59350;
var statearr_59363_59377 = state_59350__$1;
(statearr_59363_59377[(2)] = inst_59330);

(statearr_59363_59377[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59351 === (10))){
var inst_59344 = (state_59350[(2)]);
var state_59350__$1 = state_59350;
var statearr_59364_59378 = state_59350__$1;
(statearr_59364_59378[(2)] = inst_59344);

(statearr_59364_59378[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59351 === (8))){
var inst_59337 = (state_59350[(9)]);
var inst_59340 = cljs.core.deref.call(null,inst_59337);
var state_59350__$1 = state_59350;
var statearr_59365_59379 = state_59350__$1;
(statearr_59365_59379[(2)] = inst_59340);

(statearr_59365_59379[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto__))
;
return ((function (switch__58824__auto__,c__58877__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__58825__auto__ = null;
var cljs$core$async$reduce_$_state_machine__58825__auto____0 = (function (){
var statearr_59366 = [null,null,null,null,null,null,null,null,null,null];
(statearr_59366[(0)] = cljs$core$async$reduce_$_state_machine__58825__auto__);

(statearr_59366[(1)] = (1));

return statearr_59366;
});
var cljs$core$async$reduce_$_state_machine__58825__auto____1 = (function (state_59350){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_59350);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e59367){if((e59367 instanceof Object)){
var ex__58828__auto__ = e59367;
var statearr_59368_59380 = state_59350;
(statearr_59368_59380[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59350);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59367;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59381 = state_59350;
state_59350 = G__59381;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__58825__auto__ = function(state_59350){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__58825__auto____1.call(this,state_59350);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__58825__auto____0;
cljs$core$async$reduce_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__58825__auto____1;
return cljs$core$async$reduce_$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto__))
})();
var state__58879__auto__ = (function (){var statearr_59369 = f__58878__auto__.call(null);
(statearr_59369[(6)] = c__58877__auto__);

return statearr_59369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto__))
);

return c__58877__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__58877__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto__,f__$1){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto__,f__$1){
return (function (state_59387){
var state_val_59388 = (state_59387[(1)]);
if((state_val_59388 === (1))){
var inst_59382 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_59387__$1 = state_59387;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59387__$1,(2),inst_59382);
} else {
if((state_val_59388 === (2))){
var inst_59384 = (state_59387[(2)]);
var inst_59385 = f__$1.call(null,inst_59384);
var state_59387__$1 = state_59387;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59387__$1,inst_59385);
} else {
return null;
}
}
});})(c__58877__auto__,f__$1))
;
return ((function (switch__58824__auto__,c__58877__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__58825__auto__ = null;
var cljs$core$async$transduce_$_state_machine__58825__auto____0 = (function (){
var statearr_59389 = [null,null,null,null,null,null,null];
(statearr_59389[(0)] = cljs$core$async$transduce_$_state_machine__58825__auto__);

(statearr_59389[(1)] = (1));

return statearr_59389;
});
var cljs$core$async$transduce_$_state_machine__58825__auto____1 = (function (state_59387){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_59387);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e59390){if((e59390 instanceof Object)){
var ex__58828__auto__ = e59390;
var statearr_59391_59393 = state_59387;
(statearr_59391_59393[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59387);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59390;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59394 = state_59387;
state_59387 = G__59394;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__58825__auto__ = function(state_59387){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__58825__auto____1.call(this,state_59387);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__58825__auto____0;
cljs$core$async$transduce_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__58825__auto____1;
return cljs$core$async$transduce_$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto__,f__$1))
})();
var state__58879__auto__ = (function (){var statearr_59392 = f__58878__auto__.call(null);
(statearr_59392[(6)] = c__58877__auto__);

return statearr_59392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto__,f__$1))
);

return c__58877__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__59396 = arguments.length;
switch (G__59396) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__58877__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto__){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto__){
return (function (state_59421){
var state_val_59422 = (state_59421[(1)]);
if((state_val_59422 === (7))){
var inst_59403 = (state_59421[(2)]);
var state_59421__$1 = state_59421;
var statearr_59423_59444 = state_59421__$1;
(statearr_59423_59444[(2)] = inst_59403);

(statearr_59423_59444[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59422 === (1))){
var inst_59397 = cljs.core.seq.call(null,coll);
var inst_59398 = inst_59397;
var state_59421__$1 = (function (){var statearr_59424 = state_59421;
(statearr_59424[(7)] = inst_59398);

return statearr_59424;
})();
var statearr_59425_59445 = state_59421__$1;
(statearr_59425_59445[(2)] = null);

(statearr_59425_59445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59422 === (4))){
var inst_59398 = (state_59421[(7)]);
var inst_59401 = cljs.core.first.call(null,inst_59398);
var state_59421__$1 = state_59421;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59421__$1,(7),ch,inst_59401);
} else {
if((state_val_59422 === (13))){
var inst_59415 = (state_59421[(2)]);
var state_59421__$1 = state_59421;
var statearr_59426_59446 = state_59421__$1;
(statearr_59426_59446[(2)] = inst_59415);

(statearr_59426_59446[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59422 === (6))){
var inst_59406 = (state_59421[(2)]);
var state_59421__$1 = state_59421;
if(cljs.core.truth_(inst_59406)){
var statearr_59427_59447 = state_59421__$1;
(statearr_59427_59447[(1)] = (8));

} else {
var statearr_59428_59448 = state_59421__$1;
(statearr_59428_59448[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59422 === (3))){
var inst_59419 = (state_59421[(2)]);
var state_59421__$1 = state_59421;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59421__$1,inst_59419);
} else {
if((state_val_59422 === (12))){
var state_59421__$1 = state_59421;
var statearr_59429_59449 = state_59421__$1;
(statearr_59429_59449[(2)] = null);

(statearr_59429_59449[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59422 === (2))){
var inst_59398 = (state_59421[(7)]);
var state_59421__$1 = state_59421;
if(cljs.core.truth_(inst_59398)){
var statearr_59430_59450 = state_59421__$1;
(statearr_59430_59450[(1)] = (4));

} else {
var statearr_59431_59451 = state_59421__$1;
(statearr_59431_59451[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59422 === (11))){
var inst_59412 = cljs.core.async.close_BANG_.call(null,ch);
var state_59421__$1 = state_59421;
var statearr_59432_59452 = state_59421__$1;
(statearr_59432_59452[(2)] = inst_59412);

(statearr_59432_59452[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59422 === (9))){
var state_59421__$1 = state_59421;
if(cljs.core.truth_(close_QMARK_)){
var statearr_59433_59453 = state_59421__$1;
(statearr_59433_59453[(1)] = (11));

} else {
var statearr_59434_59454 = state_59421__$1;
(statearr_59434_59454[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59422 === (5))){
var inst_59398 = (state_59421[(7)]);
var state_59421__$1 = state_59421;
var statearr_59435_59455 = state_59421__$1;
(statearr_59435_59455[(2)] = inst_59398);

(statearr_59435_59455[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59422 === (10))){
var inst_59417 = (state_59421[(2)]);
var state_59421__$1 = state_59421;
var statearr_59436_59456 = state_59421__$1;
(statearr_59436_59456[(2)] = inst_59417);

(statearr_59436_59456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59422 === (8))){
var inst_59398 = (state_59421[(7)]);
var inst_59408 = cljs.core.next.call(null,inst_59398);
var inst_59398__$1 = inst_59408;
var state_59421__$1 = (function (){var statearr_59437 = state_59421;
(statearr_59437[(7)] = inst_59398__$1);

return statearr_59437;
})();
var statearr_59438_59457 = state_59421__$1;
(statearr_59438_59457[(2)] = null);

(statearr_59438_59457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto__))
;
return ((function (switch__58824__auto__,c__58877__auto__){
return (function() {
var cljs$core$async$state_machine__58825__auto__ = null;
var cljs$core$async$state_machine__58825__auto____0 = (function (){
var statearr_59439 = [null,null,null,null,null,null,null,null];
(statearr_59439[(0)] = cljs$core$async$state_machine__58825__auto__);

(statearr_59439[(1)] = (1));

return statearr_59439;
});
var cljs$core$async$state_machine__58825__auto____1 = (function (state_59421){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_59421);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e59440){if((e59440 instanceof Object)){
var ex__58828__auto__ = e59440;
var statearr_59441_59458 = state_59421;
(statearr_59441_59458[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59421);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59440;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59459 = state_59421;
state_59421 = G__59459;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$state_machine__58825__auto__ = function(state_59421){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__58825__auto____1.call(this,state_59421);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__58825__auto____0;
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__58825__auto____1;
return cljs$core$async$state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto__))
})();
var state__58879__auto__ = (function (){var statearr_59442 = f__58878__auto__.call(null);
(statearr_59442[(6)] = c__58877__auto__);

return statearr_59442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto__))
);

return c__58877__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__54868__auto__ = (((_ == null))?null:_);
var m__54869__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__54868__auto__)]);
if(!((m__54869__auto__ == null))){
return m__54869__auto__.call(null,_);
} else {
var m__54869__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__54869__auto____$1 == null))){
return m__54869__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__54868__auto__ = (((m == null))?null:m);
var m__54869__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__54868__auto__)]);
if(!((m__54869__auto__ == null))){
return m__54869__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__54869__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__54869__auto____$1 == null))){
return m__54869__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__54868__auto__ = (((m == null))?null:m);
var m__54869__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__54868__auto__)]);
if(!((m__54869__auto__ == null))){
return m__54869__auto__.call(null,m,ch);
} else {
var m__54869__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__54869__auto____$1 == null))){
return m__54869__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__54868__auto__ = (((m == null))?null:m);
var m__54869__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__54868__auto__)]);
if(!((m__54869__auto__ == null))){
return m__54869__auto__.call(null,m);
} else {
var m__54869__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__54869__auto____$1 == null))){
return m__54869__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async59460 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59460 = (function (ch,cs,meta59461){
this.ch = ch;
this.cs = cs;
this.meta59461 = meta59461;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async59460.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_59462,meta59461__$1){
var self__ = this;
var _59462__$1 = this;
return (new cljs.core.async.t_cljs$core$async59460(self__.ch,self__.cs,meta59461__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async59460.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_59462){
var self__ = this;
var _59462__$1 = this;
return self__.meta59461;
});})(cs))
;

cljs.core.async.t_cljs$core$async59460.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59460.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async59460.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59460.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async59460.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async59460.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async59460.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta59461","meta59461",-1678383888,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async59460.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59460.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59460";

cljs.core.async.t_cljs$core$async59460.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__54810__auto__,writer__54811__auto__,opt__54812__auto__){
return cljs.core._write.call(null,writer__54811__auto__,"cljs.core.async/t_cljs$core$async59460");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async59460 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async59460(ch__$1,cs__$1,meta59461){
return (new cljs.core.async.t_cljs$core$async59460(ch__$1,cs__$1,meta59461));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async59460(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__58877__auto___59682 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___59682,cs,m,dchan,dctr,done){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___59682,cs,m,dchan,dctr,done){
return (function (state_59597){
var state_val_59598 = (state_59597[(1)]);
if((state_val_59598 === (7))){
var inst_59593 = (state_59597[(2)]);
var state_59597__$1 = state_59597;
var statearr_59599_59683 = state_59597__$1;
(statearr_59599_59683[(2)] = inst_59593);

(statearr_59599_59683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (20))){
var inst_59496 = (state_59597[(7)]);
var inst_59508 = cljs.core.first.call(null,inst_59496);
var inst_59509 = cljs.core.nth.call(null,inst_59508,(0),null);
var inst_59510 = cljs.core.nth.call(null,inst_59508,(1),null);
var state_59597__$1 = (function (){var statearr_59600 = state_59597;
(statearr_59600[(8)] = inst_59509);

return statearr_59600;
})();
if(cljs.core.truth_(inst_59510)){
var statearr_59601_59684 = state_59597__$1;
(statearr_59601_59684[(1)] = (22));

} else {
var statearr_59602_59685 = state_59597__$1;
(statearr_59602_59685[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (27))){
var inst_59465 = (state_59597[(9)]);
var inst_59538 = (state_59597[(10)]);
var inst_59545 = (state_59597[(11)]);
var inst_59540 = (state_59597[(12)]);
var inst_59545__$1 = cljs.core._nth.call(null,inst_59538,inst_59540);
var inst_59546 = cljs.core.async.put_BANG_.call(null,inst_59545__$1,inst_59465,done);
var state_59597__$1 = (function (){var statearr_59603 = state_59597;
(statearr_59603[(11)] = inst_59545__$1);

return statearr_59603;
})();
if(cljs.core.truth_(inst_59546)){
var statearr_59604_59686 = state_59597__$1;
(statearr_59604_59686[(1)] = (30));

} else {
var statearr_59605_59687 = state_59597__$1;
(statearr_59605_59687[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (1))){
var state_59597__$1 = state_59597;
var statearr_59606_59688 = state_59597__$1;
(statearr_59606_59688[(2)] = null);

(statearr_59606_59688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (24))){
var inst_59496 = (state_59597[(7)]);
var inst_59515 = (state_59597[(2)]);
var inst_59516 = cljs.core.next.call(null,inst_59496);
var inst_59474 = inst_59516;
var inst_59475 = null;
var inst_59476 = (0);
var inst_59477 = (0);
var state_59597__$1 = (function (){var statearr_59607 = state_59597;
(statearr_59607[(13)] = inst_59477);

(statearr_59607[(14)] = inst_59515);

(statearr_59607[(15)] = inst_59476);

(statearr_59607[(16)] = inst_59474);

(statearr_59607[(17)] = inst_59475);

return statearr_59607;
})();
var statearr_59608_59689 = state_59597__$1;
(statearr_59608_59689[(2)] = null);

(statearr_59608_59689[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (39))){
var state_59597__$1 = state_59597;
var statearr_59612_59690 = state_59597__$1;
(statearr_59612_59690[(2)] = null);

(statearr_59612_59690[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (4))){
var inst_59465 = (state_59597[(9)]);
var inst_59465__$1 = (state_59597[(2)]);
var inst_59466 = (inst_59465__$1 == null);
var state_59597__$1 = (function (){var statearr_59613 = state_59597;
(statearr_59613[(9)] = inst_59465__$1);

return statearr_59613;
})();
if(cljs.core.truth_(inst_59466)){
var statearr_59614_59691 = state_59597__$1;
(statearr_59614_59691[(1)] = (5));

} else {
var statearr_59615_59692 = state_59597__$1;
(statearr_59615_59692[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (15))){
var inst_59477 = (state_59597[(13)]);
var inst_59476 = (state_59597[(15)]);
var inst_59474 = (state_59597[(16)]);
var inst_59475 = (state_59597[(17)]);
var inst_59492 = (state_59597[(2)]);
var inst_59493 = (inst_59477 + (1));
var tmp59609 = inst_59476;
var tmp59610 = inst_59474;
var tmp59611 = inst_59475;
var inst_59474__$1 = tmp59610;
var inst_59475__$1 = tmp59611;
var inst_59476__$1 = tmp59609;
var inst_59477__$1 = inst_59493;
var state_59597__$1 = (function (){var statearr_59616 = state_59597;
(statearr_59616[(13)] = inst_59477__$1);

(statearr_59616[(15)] = inst_59476__$1);

(statearr_59616[(18)] = inst_59492);

(statearr_59616[(16)] = inst_59474__$1);

(statearr_59616[(17)] = inst_59475__$1);

return statearr_59616;
})();
var statearr_59617_59693 = state_59597__$1;
(statearr_59617_59693[(2)] = null);

(statearr_59617_59693[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (21))){
var inst_59519 = (state_59597[(2)]);
var state_59597__$1 = state_59597;
var statearr_59621_59694 = state_59597__$1;
(statearr_59621_59694[(2)] = inst_59519);

(statearr_59621_59694[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (31))){
var inst_59545 = (state_59597[(11)]);
var inst_59549 = done.call(null,null);
var inst_59550 = cljs.core.async.untap_STAR_.call(null,m,inst_59545);
var state_59597__$1 = (function (){var statearr_59622 = state_59597;
(statearr_59622[(19)] = inst_59549);

return statearr_59622;
})();
var statearr_59623_59695 = state_59597__$1;
(statearr_59623_59695[(2)] = inst_59550);

(statearr_59623_59695[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (32))){
var inst_59537 = (state_59597[(20)]);
var inst_59538 = (state_59597[(10)]);
var inst_59539 = (state_59597[(21)]);
var inst_59540 = (state_59597[(12)]);
var inst_59552 = (state_59597[(2)]);
var inst_59553 = (inst_59540 + (1));
var tmp59618 = inst_59537;
var tmp59619 = inst_59538;
var tmp59620 = inst_59539;
var inst_59537__$1 = tmp59618;
var inst_59538__$1 = tmp59619;
var inst_59539__$1 = tmp59620;
var inst_59540__$1 = inst_59553;
var state_59597__$1 = (function (){var statearr_59624 = state_59597;
(statearr_59624[(20)] = inst_59537__$1);

(statearr_59624[(10)] = inst_59538__$1);

(statearr_59624[(21)] = inst_59539__$1);

(statearr_59624[(22)] = inst_59552);

(statearr_59624[(12)] = inst_59540__$1);

return statearr_59624;
})();
var statearr_59625_59696 = state_59597__$1;
(statearr_59625_59696[(2)] = null);

(statearr_59625_59696[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (40))){
var inst_59565 = (state_59597[(23)]);
var inst_59569 = done.call(null,null);
var inst_59570 = cljs.core.async.untap_STAR_.call(null,m,inst_59565);
var state_59597__$1 = (function (){var statearr_59626 = state_59597;
(statearr_59626[(24)] = inst_59569);

return statearr_59626;
})();
var statearr_59627_59697 = state_59597__$1;
(statearr_59627_59697[(2)] = inst_59570);

(statearr_59627_59697[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (33))){
var inst_59556 = (state_59597[(25)]);
var inst_59558 = cljs.core.chunked_seq_QMARK_.call(null,inst_59556);
var state_59597__$1 = state_59597;
if(inst_59558){
var statearr_59628_59698 = state_59597__$1;
(statearr_59628_59698[(1)] = (36));

} else {
var statearr_59629_59699 = state_59597__$1;
(statearr_59629_59699[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (13))){
var inst_59486 = (state_59597[(26)]);
var inst_59489 = cljs.core.async.close_BANG_.call(null,inst_59486);
var state_59597__$1 = state_59597;
var statearr_59630_59700 = state_59597__$1;
(statearr_59630_59700[(2)] = inst_59489);

(statearr_59630_59700[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (22))){
var inst_59509 = (state_59597[(8)]);
var inst_59512 = cljs.core.async.close_BANG_.call(null,inst_59509);
var state_59597__$1 = state_59597;
var statearr_59631_59701 = state_59597__$1;
(statearr_59631_59701[(2)] = inst_59512);

(statearr_59631_59701[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (36))){
var inst_59556 = (state_59597[(25)]);
var inst_59560 = cljs.core.chunk_first.call(null,inst_59556);
var inst_59561 = cljs.core.chunk_rest.call(null,inst_59556);
var inst_59562 = cljs.core.count.call(null,inst_59560);
var inst_59537 = inst_59561;
var inst_59538 = inst_59560;
var inst_59539 = inst_59562;
var inst_59540 = (0);
var state_59597__$1 = (function (){var statearr_59632 = state_59597;
(statearr_59632[(20)] = inst_59537);

(statearr_59632[(10)] = inst_59538);

(statearr_59632[(21)] = inst_59539);

(statearr_59632[(12)] = inst_59540);

return statearr_59632;
})();
var statearr_59633_59702 = state_59597__$1;
(statearr_59633_59702[(2)] = null);

(statearr_59633_59702[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (41))){
var inst_59556 = (state_59597[(25)]);
var inst_59572 = (state_59597[(2)]);
var inst_59573 = cljs.core.next.call(null,inst_59556);
var inst_59537 = inst_59573;
var inst_59538 = null;
var inst_59539 = (0);
var inst_59540 = (0);
var state_59597__$1 = (function (){var statearr_59634 = state_59597;
(statearr_59634[(20)] = inst_59537);

(statearr_59634[(10)] = inst_59538);

(statearr_59634[(21)] = inst_59539);

(statearr_59634[(27)] = inst_59572);

(statearr_59634[(12)] = inst_59540);

return statearr_59634;
})();
var statearr_59635_59703 = state_59597__$1;
(statearr_59635_59703[(2)] = null);

(statearr_59635_59703[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (43))){
var state_59597__$1 = state_59597;
var statearr_59636_59704 = state_59597__$1;
(statearr_59636_59704[(2)] = null);

(statearr_59636_59704[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (29))){
var inst_59581 = (state_59597[(2)]);
var state_59597__$1 = state_59597;
var statearr_59637_59705 = state_59597__$1;
(statearr_59637_59705[(2)] = inst_59581);

(statearr_59637_59705[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (44))){
var inst_59590 = (state_59597[(2)]);
var state_59597__$1 = (function (){var statearr_59638 = state_59597;
(statearr_59638[(28)] = inst_59590);

return statearr_59638;
})();
var statearr_59639_59706 = state_59597__$1;
(statearr_59639_59706[(2)] = null);

(statearr_59639_59706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (6))){
var inst_59529 = (state_59597[(29)]);
var inst_59528 = cljs.core.deref.call(null,cs);
var inst_59529__$1 = cljs.core.keys.call(null,inst_59528);
var inst_59530 = cljs.core.count.call(null,inst_59529__$1);
var inst_59531 = cljs.core.reset_BANG_.call(null,dctr,inst_59530);
var inst_59536 = cljs.core.seq.call(null,inst_59529__$1);
var inst_59537 = inst_59536;
var inst_59538 = null;
var inst_59539 = (0);
var inst_59540 = (0);
var state_59597__$1 = (function (){var statearr_59640 = state_59597;
(statearr_59640[(20)] = inst_59537);

(statearr_59640[(29)] = inst_59529__$1);

(statearr_59640[(10)] = inst_59538);

(statearr_59640[(21)] = inst_59539);

(statearr_59640[(30)] = inst_59531);

(statearr_59640[(12)] = inst_59540);

return statearr_59640;
})();
var statearr_59641_59707 = state_59597__$1;
(statearr_59641_59707[(2)] = null);

(statearr_59641_59707[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (28))){
var inst_59537 = (state_59597[(20)]);
var inst_59556 = (state_59597[(25)]);
var inst_59556__$1 = cljs.core.seq.call(null,inst_59537);
var state_59597__$1 = (function (){var statearr_59642 = state_59597;
(statearr_59642[(25)] = inst_59556__$1);

return statearr_59642;
})();
if(inst_59556__$1){
var statearr_59643_59708 = state_59597__$1;
(statearr_59643_59708[(1)] = (33));

} else {
var statearr_59644_59709 = state_59597__$1;
(statearr_59644_59709[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (25))){
var inst_59539 = (state_59597[(21)]);
var inst_59540 = (state_59597[(12)]);
var inst_59542 = (inst_59540 < inst_59539);
var inst_59543 = inst_59542;
var state_59597__$1 = state_59597;
if(cljs.core.truth_(inst_59543)){
var statearr_59645_59710 = state_59597__$1;
(statearr_59645_59710[(1)] = (27));

} else {
var statearr_59646_59711 = state_59597__$1;
(statearr_59646_59711[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (34))){
var state_59597__$1 = state_59597;
var statearr_59647_59712 = state_59597__$1;
(statearr_59647_59712[(2)] = null);

(statearr_59647_59712[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (17))){
var state_59597__$1 = state_59597;
var statearr_59648_59713 = state_59597__$1;
(statearr_59648_59713[(2)] = null);

(statearr_59648_59713[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (3))){
var inst_59595 = (state_59597[(2)]);
var state_59597__$1 = state_59597;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59597__$1,inst_59595);
} else {
if((state_val_59598 === (12))){
var inst_59524 = (state_59597[(2)]);
var state_59597__$1 = state_59597;
var statearr_59649_59714 = state_59597__$1;
(statearr_59649_59714[(2)] = inst_59524);

(statearr_59649_59714[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (2))){
var state_59597__$1 = state_59597;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59597__$1,(4),ch);
} else {
if((state_val_59598 === (23))){
var state_59597__$1 = state_59597;
var statearr_59650_59715 = state_59597__$1;
(statearr_59650_59715[(2)] = null);

(statearr_59650_59715[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (35))){
var inst_59579 = (state_59597[(2)]);
var state_59597__$1 = state_59597;
var statearr_59651_59716 = state_59597__$1;
(statearr_59651_59716[(2)] = inst_59579);

(statearr_59651_59716[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (19))){
var inst_59496 = (state_59597[(7)]);
var inst_59500 = cljs.core.chunk_first.call(null,inst_59496);
var inst_59501 = cljs.core.chunk_rest.call(null,inst_59496);
var inst_59502 = cljs.core.count.call(null,inst_59500);
var inst_59474 = inst_59501;
var inst_59475 = inst_59500;
var inst_59476 = inst_59502;
var inst_59477 = (0);
var state_59597__$1 = (function (){var statearr_59652 = state_59597;
(statearr_59652[(13)] = inst_59477);

(statearr_59652[(15)] = inst_59476);

(statearr_59652[(16)] = inst_59474);

(statearr_59652[(17)] = inst_59475);

return statearr_59652;
})();
var statearr_59653_59717 = state_59597__$1;
(statearr_59653_59717[(2)] = null);

(statearr_59653_59717[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (11))){
var inst_59474 = (state_59597[(16)]);
var inst_59496 = (state_59597[(7)]);
var inst_59496__$1 = cljs.core.seq.call(null,inst_59474);
var state_59597__$1 = (function (){var statearr_59654 = state_59597;
(statearr_59654[(7)] = inst_59496__$1);

return statearr_59654;
})();
if(inst_59496__$1){
var statearr_59655_59718 = state_59597__$1;
(statearr_59655_59718[(1)] = (16));

} else {
var statearr_59656_59719 = state_59597__$1;
(statearr_59656_59719[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (9))){
var inst_59526 = (state_59597[(2)]);
var state_59597__$1 = state_59597;
var statearr_59657_59720 = state_59597__$1;
(statearr_59657_59720[(2)] = inst_59526);

(statearr_59657_59720[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (5))){
var inst_59472 = cljs.core.deref.call(null,cs);
var inst_59473 = cljs.core.seq.call(null,inst_59472);
var inst_59474 = inst_59473;
var inst_59475 = null;
var inst_59476 = (0);
var inst_59477 = (0);
var state_59597__$1 = (function (){var statearr_59658 = state_59597;
(statearr_59658[(13)] = inst_59477);

(statearr_59658[(15)] = inst_59476);

(statearr_59658[(16)] = inst_59474);

(statearr_59658[(17)] = inst_59475);

return statearr_59658;
})();
var statearr_59659_59721 = state_59597__$1;
(statearr_59659_59721[(2)] = null);

(statearr_59659_59721[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (14))){
var state_59597__$1 = state_59597;
var statearr_59660_59722 = state_59597__$1;
(statearr_59660_59722[(2)] = null);

(statearr_59660_59722[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (45))){
var inst_59587 = (state_59597[(2)]);
var state_59597__$1 = state_59597;
var statearr_59661_59723 = state_59597__$1;
(statearr_59661_59723[(2)] = inst_59587);

(statearr_59661_59723[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (26))){
var inst_59529 = (state_59597[(29)]);
var inst_59583 = (state_59597[(2)]);
var inst_59584 = cljs.core.seq.call(null,inst_59529);
var state_59597__$1 = (function (){var statearr_59662 = state_59597;
(statearr_59662[(31)] = inst_59583);

return statearr_59662;
})();
if(inst_59584){
var statearr_59663_59724 = state_59597__$1;
(statearr_59663_59724[(1)] = (42));

} else {
var statearr_59664_59725 = state_59597__$1;
(statearr_59664_59725[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (16))){
var inst_59496 = (state_59597[(7)]);
var inst_59498 = cljs.core.chunked_seq_QMARK_.call(null,inst_59496);
var state_59597__$1 = state_59597;
if(inst_59498){
var statearr_59665_59726 = state_59597__$1;
(statearr_59665_59726[(1)] = (19));

} else {
var statearr_59666_59727 = state_59597__$1;
(statearr_59666_59727[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (38))){
var inst_59576 = (state_59597[(2)]);
var state_59597__$1 = state_59597;
var statearr_59667_59728 = state_59597__$1;
(statearr_59667_59728[(2)] = inst_59576);

(statearr_59667_59728[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (30))){
var state_59597__$1 = state_59597;
var statearr_59668_59729 = state_59597__$1;
(statearr_59668_59729[(2)] = null);

(statearr_59668_59729[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (10))){
var inst_59477 = (state_59597[(13)]);
var inst_59475 = (state_59597[(17)]);
var inst_59485 = cljs.core._nth.call(null,inst_59475,inst_59477);
var inst_59486 = cljs.core.nth.call(null,inst_59485,(0),null);
var inst_59487 = cljs.core.nth.call(null,inst_59485,(1),null);
var state_59597__$1 = (function (){var statearr_59669 = state_59597;
(statearr_59669[(26)] = inst_59486);

return statearr_59669;
})();
if(cljs.core.truth_(inst_59487)){
var statearr_59670_59730 = state_59597__$1;
(statearr_59670_59730[(1)] = (13));

} else {
var statearr_59671_59731 = state_59597__$1;
(statearr_59671_59731[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (18))){
var inst_59522 = (state_59597[(2)]);
var state_59597__$1 = state_59597;
var statearr_59672_59732 = state_59597__$1;
(statearr_59672_59732[(2)] = inst_59522);

(statearr_59672_59732[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (42))){
var state_59597__$1 = state_59597;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59597__$1,(45),dchan);
} else {
if((state_val_59598 === (37))){
var inst_59556 = (state_59597[(25)]);
var inst_59565 = (state_59597[(23)]);
var inst_59465 = (state_59597[(9)]);
var inst_59565__$1 = cljs.core.first.call(null,inst_59556);
var inst_59566 = cljs.core.async.put_BANG_.call(null,inst_59565__$1,inst_59465,done);
var state_59597__$1 = (function (){var statearr_59673 = state_59597;
(statearr_59673[(23)] = inst_59565__$1);

return statearr_59673;
})();
if(cljs.core.truth_(inst_59566)){
var statearr_59674_59733 = state_59597__$1;
(statearr_59674_59733[(1)] = (39));

} else {
var statearr_59675_59734 = state_59597__$1;
(statearr_59675_59734[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59598 === (8))){
var inst_59477 = (state_59597[(13)]);
var inst_59476 = (state_59597[(15)]);
var inst_59479 = (inst_59477 < inst_59476);
var inst_59480 = inst_59479;
var state_59597__$1 = state_59597;
if(cljs.core.truth_(inst_59480)){
var statearr_59676_59735 = state_59597__$1;
(statearr_59676_59735[(1)] = (10));

} else {
var statearr_59677_59736 = state_59597__$1;
(statearr_59677_59736[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___59682,cs,m,dchan,dctr,done))
;
return ((function (switch__58824__auto__,c__58877__auto___59682,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__58825__auto__ = null;
var cljs$core$async$mult_$_state_machine__58825__auto____0 = (function (){
var statearr_59678 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59678[(0)] = cljs$core$async$mult_$_state_machine__58825__auto__);

(statearr_59678[(1)] = (1));

return statearr_59678;
});
var cljs$core$async$mult_$_state_machine__58825__auto____1 = (function (state_59597){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_59597);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e59679){if((e59679 instanceof Object)){
var ex__58828__auto__ = e59679;
var statearr_59680_59737 = state_59597;
(statearr_59680_59737[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59597);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59679;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59738 = state_59597;
state_59597 = G__59738;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__58825__auto__ = function(state_59597){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__58825__auto____1.call(this,state_59597);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__58825__auto____0;
cljs$core$async$mult_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__58825__auto____1;
return cljs$core$async$mult_$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___59682,cs,m,dchan,dctr,done))
})();
var state__58879__auto__ = (function (){var statearr_59681 = f__58878__auto__.call(null);
(statearr_59681[(6)] = c__58877__auto___59682);

return statearr_59681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___59682,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__59740 = arguments.length;
switch (G__59740) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__54868__auto__ = (((m == null))?null:m);
var m__54869__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__54868__auto__)]);
if(!((m__54869__auto__ == null))){
return m__54869__auto__.call(null,m,ch);
} else {
var m__54869__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__54869__auto____$1 == null))){
return m__54869__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__54868__auto__ = (((m == null))?null:m);
var m__54869__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__54868__auto__)]);
if(!((m__54869__auto__ == null))){
return m__54869__auto__.call(null,m,ch);
} else {
var m__54869__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__54869__auto____$1 == null))){
return m__54869__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__54868__auto__ = (((m == null))?null:m);
var m__54869__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__54868__auto__)]);
if(!((m__54869__auto__ == null))){
return m__54869__auto__.call(null,m);
} else {
var m__54869__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__54869__auto____$1 == null))){
return m__54869__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__54868__auto__ = (((m == null))?null:m);
var m__54869__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__54868__auto__)]);
if(!((m__54869__auto__ == null))){
return m__54869__auto__.call(null,m,state_map);
} else {
var m__54869__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__54869__auto____$1 == null))){
return m__54869__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__54868__auto__ = (((m == null))?null:m);
var m__54869__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__54868__auto__)]);
if(!((m__54869__auto__ == null))){
return m__54869__auto__.call(null,m,mode);
} else {
var m__54869__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__54869__auto____$1 == null))){
return m__54869__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__55361__auto__ = [];
var len__55354__auto___59752 = arguments.length;
var i__55355__auto___59753 = (0);
while(true){
if((i__55355__auto___59753 < len__55354__auto___59752)){
args__55361__auto__.push((arguments[i__55355__auto___59753]));

var G__59754 = (i__55355__auto___59753 + (1));
i__55355__auto___59753 = G__59754;
continue;
} else {
}
break;
}

var argseq__55362__auto__ = ((((3) < args__55361__auto__.length))?(new cljs.core.IndexedSeq(args__55361__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__55362__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__59746){
var map__59747 = p__59746;
var map__59747__$1 = ((((!((map__59747 == null)))?((((map__59747.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__59747.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__59747):map__59747);
var opts = map__59747__$1;
var statearr_59749_59755 = state;
(statearr_59749_59755[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__59747,map__59747__$1,opts){
return (function (val){
var statearr_59750_59756 = state;
(statearr_59750_59756[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__59747,map__59747__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_59751_59757 = state;
(statearr_59751_59757[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq59742){
var G__59743 = cljs.core.first.call(null,seq59742);
var seq59742__$1 = cljs.core.next.call(null,seq59742);
var G__59744 = cljs.core.first.call(null,seq59742__$1);
var seq59742__$2 = cljs.core.next.call(null,seq59742__$1);
var G__59745 = cljs.core.first.call(null,seq59742__$2);
var seq59742__$3 = cljs.core.next.call(null,seq59742__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__59743,G__59744,G__59745,seq59742__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async59758 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59758 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta59759){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta59759 = meta59759;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async59758.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_59760,meta59759__$1){
var self__ = this;
var _59760__$1 = this;
return (new cljs.core.async.t_cljs$core$async59758(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta59759__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59758.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_59760){
var self__ = this;
var _59760__$1 = this;
return self__.meta59759;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59758.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59758.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59758.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59758.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59758.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59758.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59758.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59758.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59758.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta59759","meta59759",-1470194912,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59758.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59758.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59758";

cljs.core.async.t_cljs$core$async59758.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__54810__auto__,writer__54811__auto__,opt__54812__auto__){
return cljs.core._write.call(null,writer__54811__auto__,"cljs.core.async/t_cljs$core$async59758");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async59758 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async59758(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta59759){
return (new cljs.core.async.t_cljs$core$async59758(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta59759));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async59758(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__58877__auto___59922 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___59922,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___59922,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_59862){
var state_val_59863 = (state_59862[(1)]);
if((state_val_59863 === (7))){
var inst_59777 = (state_59862[(2)]);
var state_59862__$1 = state_59862;
var statearr_59864_59923 = state_59862__$1;
(statearr_59864_59923[(2)] = inst_59777);

(statearr_59864_59923[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (20))){
var inst_59789 = (state_59862[(7)]);
var state_59862__$1 = state_59862;
var statearr_59865_59924 = state_59862__$1;
(statearr_59865_59924[(2)] = inst_59789);

(statearr_59865_59924[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (27))){
var state_59862__$1 = state_59862;
var statearr_59866_59925 = state_59862__$1;
(statearr_59866_59925[(2)] = null);

(statearr_59866_59925[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (1))){
var inst_59764 = (state_59862[(8)]);
var inst_59764__$1 = calc_state.call(null);
var inst_59766 = (inst_59764__$1 == null);
var inst_59767 = cljs.core.not.call(null,inst_59766);
var state_59862__$1 = (function (){var statearr_59867 = state_59862;
(statearr_59867[(8)] = inst_59764__$1);

return statearr_59867;
})();
if(inst_59767){
var statearr_59868_59926 = state_59862__$1;
(statearr_59868_59926[(1)] = (2));

} else {
var statearr_59869_59927 = state_59862__$1;
(statearr_59869_59927[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (24))){
var inst_59836 = (state_59862[(9)]);
var inst_59822 = (state_59862[(10)]);
var inst_59813 = (state_59862[(11)]);
var inst_59836__$1 = inst_59813.call(null,inst_59822);
var state_59862__$1 = (function (){var statearr_59870 = state_59862;
(statearr_59870[(9)] = inst_59836__$1);

return statearr_59870;
})();
if(cljs.core.truth_(inst_59836__$1)){
var statearr_59871_59928 = state_59862__$1;
(statearr_59871_59928[(1)] = (29));

} else {
var statearr_59872_59929 = state_59862__$1;
(statearr_59872_59929[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (4))){
var inst_59780 = (state_59862[(2)]);
var state_59862__$1 = state_59862;
if(cljs.core.truth_(inst_59780)){
var statearr_59873_59930 = state_59862__$1;
(statearr_59873_59930[(1)] = (8));

} else {
var statearr_59874_59931 = state_59862__$1;
(statearr_59874_59931[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (15))){
var inst_59807 = (state_59862[(2)]);
var state_59862__$1 = state_59862;
if(cljs.core.truth_(inst_59807)){
var statearr_59875_59932 = state_59862__$1;
(statearr_59875_59932[(1)] = (19));

} else {
var statearr_59876_59933 = state_59862__$1;
(statearr_59876_59933[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (21))){
var inst_59812 = (state_59862[(12)]);
var inst_59812__$1 = (state_59862[(2)]);
var inst_59813 = cljs.core.get.call(null,inst_59812__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_59814 = cljs.core.get.call(null,inst_59812__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_59815 = cljs.core.get.call(null,inst_59812__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_59862__$1 = (function (){var statearr_59877 = state_59862;
(statearr_59877[(12)] = inst_59812__$1);

(statearr_59877[(13)] = inst_59814);

(statearr_59877[(11)] = inst_59813);

return statearr_59877;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_59862__$1,(22),inst_59815);
} else {
if((state_val_59863 === (31))){
var inst_59844 = (state_59862[(2)]);
var state_59862__$1 = state_59862;
if(cljs.core.truth_(inst_59844)){
var statearr_59878_59934 = state_59862__$1;
(statearr_59878_59934[(1)] = (32));

} else {
var statearr_59879_59935 = state_59862__$1;
(statearr_59879_59935[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (32))){
var inst_59821 = (state_59862[(14)]);
var state_59862__$1 = state_59862;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59862__$1,(35),out,inst_59821);
} else {
if((state_val_59863 === (33))){
var inst_59812 = (state_59862[(12)]);
var inst_59789 = inst_59812;
var state_59862__$1 = (function (){var statearr_59880 = state_59862;
(statearr_59880[(7)] = inst_59789);

return statearr_59880;
})();
var statearr_59881_59936 = state_59862__$1;
(statearr_59881_59936[(2)] = null);

(statearr_59881_59936[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (13))){
var inst_59789 = (state_59862[(7)]);
var inst_59796 = inst_59789.cljs$lang$protocol_mask$partition0$;
var inst_59797 = (inst_59796 & (64));
var inst_59798 = inst_59789.cljs$core$ISeq$;
var inst_59799 = (cljs.core.PROTOCOL_SENTINEL === inst_59798);
var inst_59800 = (inst_59797) || (inst_59799);
var state_59862__$1 = state_59862;
if(cljs.core.truth_(inst_59800)){
var statearr_59882_59937 = state_59862__$1;
(statearr_59882_59937[(1)] = (16));

} else {
var statearr_59883_59938 = state_59862__$1;
(statearr_59883_59938[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (22))){
var inst_59821 = (state_59862[(14)]);
var inst_59822 = (state_59862[(10)]);
var inst_59820 = (state_59862[(2)]);
var inst_59821__$1 = cljs.core.nth.call(null,inst_59820,(0),null);
var inst_59822__$1 = cljs.core.nth.call(null,inst_59820,(1),null);
var inst_59823 = (inst_59821__$1 == null);
var inst_59824 = cljs.core._EQ_.call(null,inst_59822__$1,change);
var inst_59825 = (inst_59823) || (inst_59824);
var state_59862__$1 = (function (){var statearr_59884 = state_59862;
(statearr_59884[(14)] = inst_59821__$1);

(statearr_59884[(10)] = inst_59822__$1);

return statearr_59884;
})();
if(cljs.core.truth_(inst_59825)){
var statearr_59885_59939 = state_59862__$1;
(statearr_59885_59939[(1)] = (23));

} else {
var statearr_59886_59940 = state_59862__$1;
(statearr_59886_59940[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (36))){
var inst_59812 = (state_59862[(12)]);
var inst_59789 = inst_59812;
var state_59862__$1 = (function (){var statearr_59887 = state_59862;
(statearr_59887[(7)] = inst_59789);

return statearr_59887;
})();
var statearr_59888_59941 = state_59862__$1;
(statearr_59888_59941[(2)] = null);

(statearr_59888_59941[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (29))){
var inst_59836 = (state_59862[(9)]);
var state_59862__$1 = state_59862;
var statearr_59889_59942 = state_59862__$1;
(statearr_59889_59942[(2)] = inst_59836);

(statearr_59889_59942[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (6))){
var state_59862__$1 = state_59862;
var statearr_59890_59943 = state_59862__$1;
(statearr_59890_59943[(2)] = false);

(statearr_59890_59943[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (28))){
var inst_59832 = (state_59862[(2)]);
var inst_59833 = calc_state.call(null);
var inst_59789 = inst_59833;
var state_59862__$1 = (function (){var statearr_59891 = state_59862;
(statearr_59891[(15)] = inst_59832);

(statearr_59891[(7)] = inst_59789);

return statearr_59891;
})();
var statearr_59892_59944 = state_59862__$1;
(statearr_59892_59944[(2)] = null);

(statearr_59892_59944[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (25))){
var inst_59858 = (state_59862[(2)]);
var state_59862__$1 = state_59862;
var statearr_59893_59945 = state_59862__$1;
(statearr_59893_59945[(2)] = inst_59858);

(statearr_59893_59945[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (34))){
var inst_59856 = (state_59862[(2)]);
var state_59862__$1 = state_59862;
var statearr_59894_59946 = state_59862__$1;
(statearr_59894_59946[(2)] = inst_59856);

(statearr_59894_59946[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (17))){
var state_59862__$1 = state_59862;
var statearr_59895_59947 = state_59862__$1;
(statearr_59895_59947[(2)] = false);

(statearr_59895_59947[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (3))){
var state_59862__$1 = state_59862;
var statearr_59896_59948 = state_59862__$1;
(statearr_59896_59948[(2)] = false);

(statearr_59896_59948[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (12))){
var inst_59860 = (state_59862[(2)]);
var state_59862__$1 = state_59862;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59862__$1,inst_59860);
} else {
if((state_val_59863 === (2))){
var inst_59764 = (state_59862[(8)]);
var inst_59769 = inst_59764.cljs$lang$protocol_mask$partition0$;
var inst_59770 = (inst_59769 & (64));
var inst_59771 = inst_59764.cljs$core$ISeq$;
var inst_59772 = (cljs.core.PROTOCOL_SENTINEL === inst_59771);
var inst_59773 = (inst_59770) || (inst_59772);
var state_59862__$1 = state_59862;
if(cljs.core.truth_(inst_59773)){
var statearr_59897_59949 = state_59862__$1;
(statearr_59897_59949[(1)] = (5));

} else {
var statearr_59898_59950 = state_59862__$1;
(statearr_59898_59950[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (23))){
var inst_59821 = (state_59862[(14)]);
var inst_59827 = (inst_59821 == null);
var state_59862__$1 = state_59862;
if(cljs.core.truth_(inst_59827)){
var statearr_59899_59951 = state_59862__$1;
(statearr_59899_59951[(1)] = (26));

} else {
var statearr_59900_59952 = state_59862__$1;
(statearr_59900_59952[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (35))){
var inst_59847 = (state_59862[(2)]);
var state_59862__$1 = state_59862;
if(cljs.core.truth_(inst_59847)){
var statearr_59901_59953 = state_59862__$1;
(statearr_59901_59953[(1)] = (36));

} else {
var statearr_59902_59954 = state_59862__$1;
(statearr_59902_59954[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (19))){
var inst_59789 = (state_59862[(7)]);
var inst_59809 = cljs.core.apply.call(null,cljs.core.hash_map,inst_59789);
var state_59862__$1 = state_59862;
var statearr_59903_59955 = state_59862__$1;
(statearr_59903_59955[(2)] = inst_59809);

(statearr_59903_59955[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (11))){
var inst_59789 = (state_59862[(7)]);
var inst_59793 = (inst_59789 == null);
var inst_59794 = cljs.core.not.call(null,inst_59793);
var state_59862__$1 = state_59862;
if(inst_59794){
var statearr_59904_59956 = state_59862__$1;
(statearr_59904_59956[(1)] = (13));

} else {
var statearr_59905_59957 = state_59862__$1;
(statearr_59905_59957[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (9))){
var inst_59764 = (state_59862[(8)]);
var state_59862__$1 = state_59862;
var statearr_59906_59958 = state_59862__$1;
(statearr_59906_59958[(2)] = inst_59764);

(statearr_59906_59958[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (5))){
var state_59862__$1 = state_59862;
var statearr_59907_59959 = state_59862__$1;
(statearr_59907_59959[(2)] = true);

(statearr_59907_59959[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (14))){
var state_59862__$1 = state_59862;
var statearr_59908_59960 = state_59862__$1;
(statearr_59908_59960[(2)] = false);

(statearr_59908_59960[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (26))){
var inst_59822 = (state_59862[(10)]);
var inst_59829 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_59822);
var state_59862__$1 = state_59862;
var statearr_59909_59961 = state_59862__$1;
(statearr_59909_59961[(2)] = inst_59829);

(statearr_59909_59961[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (16))){
var state_59862__$1 = state_59862;
var statearr_59910_59962 = state_59862__$1;
(statearr_59910_59962[(2)] = true);

(statearr_59910_59962[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (38))){
var inst_59852 = (state_59862[(2)]);
var state_59862__$1 = state_59862;
var statearr_59911_59963 = state_59862__$1;
(statearr_59911_59963[(2)] = inst_59852);

(statearr_59911_59963[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (30))){
var inst_59822 = (state_59862[(10)]);
var inst_59814 = (state_59862[(13)]);
var inst_59813 = (state_59862[(11)]);
var inst_59839 = cljs.core.empty_QMARK_.call(null,inst_59813);
var inst_59840 = inst_59814.call(null,inst_59822);
var inst_59841 = cljs.core.not.call(null,inst_59840);
var inst_59842 = (inst_59839) && (inst_59841);
var state_59862__$1 = state_59862;
var statearr_59912_59964 = state_59862__$1;
(statearr_59912_59964[(2)] = inst_59842);

(statearr_59912_59964[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (10))){
var inst_59764 = (state_59862[(8)]);
var inst_59785 = (state_59862[(2)]);
var inst_59786 = cljs.core.get.call(null,inst_59785,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_59787 = cljs.core.get.call(null,inst_59785,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_59788 = cljs.core.get.call(null,inst_59785,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_59789 = inst_59764;
var state_59862__$1 = (function (){var statearr_59913 = state_59862;
(statearr_59913[(16)] = inst_59787);

(statearr_59913[(7)] = inst_59789);

(statearr_59913[(17)] = inst_59788);

(statearr_59913[(18)] = inst_59786);

return statearr_59913;
})();
var statearr_59914_59965 = state_59862__$1;
(statearr_59914_59965[(2)] = null);

(statearr_59914_59965[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (18))){
var inst_59804 = (state_59862[(2)]);
var state_59862__$1 = state_59862;
var statearr_59915_59966 = state_59862__$1;
(statearr_59915_59966[(2)] = inst_59804);

(statearr_59915_59966[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (37))){
var state_59862__$1 = state_59862;
var statearr_59916_59967 = state_59862__$1;
(statearr_59916_59967[(2)] = null);

(statearr_59916_59967[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59863 === (8))){
var inst_59764 = (state_59862[(8)]);
var inst_59782 = cljs.core.apply.call(null,cljs.core.hash_map,inst_59764);
var state_59862__$1 = state_59862;
var statearr_59917_59968 = state_59862__$1;
(statearr_59917_59968[(2)] = inst_59782);

(statearr_59917_59968[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___59922,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__58824__auto__,c__58877__auto___59922,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__58825__auto__ = null;
var cljs$core$async$mix_$_state_machine__58825__auto____0 = (function (){
var statearr_59918 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59918[(0)] = cljs$core$async$mix_$_state_machine__58825__auto__);

(statearr_59918[(1)] = (1));

return statearr_59918;
});
var cljs$core$async$mix_$_state_machine__58825__auto____1 = (function (state_59862){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_59862);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e59919){if((e59919 instanceof Object)){
var ex__58828__auto__ = e59919;
var statearr_59920_59969 = state_59862;
(statearr_59920_59969[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59862);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59919;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59970 = state_59862;
state_59862 = G__59970;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__58825__auto__ = function(state_59862){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__58825__auto____1.call(this,state_59862);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__58825__auto____0;
cljs$core$async$mix_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__58825__auto____1;
return cljs$core$async$mix_$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___59922,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__58879__auto__ = (function (){var statearr_59921 = f__58878__auto__.call(null);
(statearr_59921[(6)] = c__58877__auto___59922);

return statearr_59921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___59922,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__54868__auto__ = (((p == null))?null:p);
var m__54869__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__54868__auto__)]);
if(!((m__54869__auto__ == null))){
return m__54869__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__54869__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__54869__auto____$1 == null))){
return m__54869__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__54868__auto__ = (((p == null))?null:p);
var m__54869__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__54868__auto__)]);
if(!((m__54869__auto__ == null))){
return m__54869__auto__.call(null,p,v,ch);
} else {
var m__54869__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__54869__auto____$1 == null))){
return m__54869__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__59972 = arguments.length;
switch (G__59972) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__54868__auto__ = (((p == null))?null:p);
var m__54869__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__54868__auto__)]);
if(!((m__54869__auto__ == null))){
return m__54869__auto__.call(null,p);
} else {
var m__54869__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__54869__auto____$1 == null))){
return m__54869__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__54868__auto__ = (((p == null))?null:p);
var m__54869__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__54868__auto__)]);
if(!((m__54869__auto__ == null))){
return m__54869__auto__.call(null,p,v);
} else {
var m__54869__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__54869__auto____$1 == null))){
return m__54869__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__59976 = arguments.length;
switch (G__59976) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__54185__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__54185__auto__)){
return or__54185__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__54185__auto__,mults){
return (function (p1__59974_SHARP_){
if(cljs.core.truth_(p1__59974_SHARP_.call(null,topic))){
return p1__59974_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__59974_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__54185__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async59977 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59977 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta59978){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta59978 = meta59978;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async59977.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_59979,meta59978__$1){
var self__ = this;
var _59979__$1 = this;
return (new cljs.core.async.t_cljs$core$async59977(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta59978__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59977.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_59979){
var self__ = this;
var _59979__$1 = this;
return self__.meta59978;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59977.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59977.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59977.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59977.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59977.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59977.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59977.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59977.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta59978","meta59978",1073170703,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59977.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59977.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59977";

cljs.core.async.t_cljs$core$async59977.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__54810__auto__,writer__54811__auto__,opt__54812__auto__){
return cljs.core._write.call(null,writer__54811__auto__,"cljs.core.async/t_cljs$core$async59977");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async59977 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async59977(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta59978){
return (new cljs.core.async.t_cljs$core$async59977(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta59978));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async59977(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__58877__auto___60097 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___60097,mults,ensure_mult,p){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___60097,mults,ensure_mult,p){
return (function (state_60051){
var state_val_60052 = (state_60051[(1)]);
if((state_val_60052 === (7))){
var inst_60047 = (state_60051[(2)]);
var state_60051__$1 = state_60051;
var statearr_60053_60098 = state_60051__$1;
(statearr_60053_60098[(2)] = inst_60047);

(statearr_60053_60098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (20))){
var state_60051__$1 = state_60051;
var statearr_60054_60099 = state_60051__$1;
(statearr_60054_60099[(2)] = null);

(statearr_60054_60099[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (1))){
var state_60051__$1 = state_60051;
var statearr_60055_60100 = state_60051__$1;
(statearr_60055_60100[(2)] = null);

(statearr_60055_60100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (24))){
var inst_60030 = (state_60051[(7)]);
var inst_60039 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_60030);
var state_60051__$1 = state_60051;
var statearr_60056_60101 = state_60051__$1;
(statearr_60056_60101[(2)] = inst_60039);

(statearr_60056_60101[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (4))){
var inst_59982 = (state_60051[(8)]);
var inst_59982__$1 = (state_60051[(2)]);
var inst_59983 = (inst_59982__$1 == null);
var state_60051__$1 = (function (){var statearr_60057 = state_60051;
(statearr_60057[(8)] = inst_59982__$1);

return statearr_60057;
})();
if(cljs.core.truth_(inst_59983)){
var statearr_60058_60102 = state_60051__$1;
(statearr_60058_60102[(1)] = (5));

} else {
var statearr_60059_60103 = state_60051__$1;
(statearr_60059_60103[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (15))){
var inst_60024 = (state_60051[(2)]);
var state_60051__$1 = state_60051;
var statearr_60060_60104 = state_60051__$1;
(statearr_60060_60104[(2)] = inst_60024);

(statearr_60060_60104[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (21))){
var inst_60044 = (state_60051[(2)]);
var state_60051__$1 = (function (){var statearr_60061 = state_60051;
(statearr_60061[(9)] = inst_60044);

return statearr_60061;
})();
var statearr_60062_60105 = state_60051__$1;
(statearr_60062_60105[(2)] = null);

(statearr_60062_60105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (13))){
var inst_60006 = (state_60051[(10)]);
var inst_60008 = cljs.core.chunked_seq_QMARK_.call(null,inst_60006);
var state_60051__$1 = state_60051;
if(inst_60008){
var statearr_60063_60106 = state_60051__$1;
(statearr_60063_60106[(1)] = (16));

} else {
var statearr_60064_60107 = state_60051__$1;
(statearr_60064_60107[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (22))){
var inst_60036 = (state_60051[(2)]);
var state_60051__$1 = state_60051;
if(cljs.core.truth_(inst_60036)){
var statearr_60065_60108 = state_60051__$1;
(statearr_60065_60108[(1)] = (23));

} else {
var statearr_60066_60109 = state_60051__$1;
(statearr_60066_60109[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (6))){
var inst_60032 = (state_60051[(11)]);
var inst_59982 = (state_60051[(8)]);
var inst_60030 = (state_60051[(7)]);
var inst_60030__$1 = topic_fn.call(null,inst_59982);
var inst_60031 = cljs.core.deref.call(null,mults);
var inst_60032__$1 = cljs.core.get.call(null,inst_60031,inst_60030__$1);
var state_60051__$1 = (function (){var statearr_60067 = state_60051;
(statearr_60067[(11)] = inst_60032__$1);

(statearr_60067[(7)] = inst_60030__$1);

return statearr_60067;
})();
if(cljs.core.truth_(inst_60032__$1)){
var statearr_60068_60110 = state_60051__$1;
(statearr_60068_60110[(1)] = (19));

} else {
var statearr_60069_60111 = state_60051__$1;
(statearr_60069_60111[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (25))){
var inst_60041 = (state_60051[(2)]);
var state_60051__$1 = state_60051;
var statearr_60070_60112 = state_60051__$1;
(statearr_60070_60112[(2)] = inst_60041);

(statearr_60070_60112[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (17))){
var inst_60006 = (state_60051[(10)]);
var inst_60015 = cljs.core.first.call(null,inst_60006);
var inst_60016 = cljs.core.async.muxch_STAR_.call(null,inst_60015);
var inst_60017 = cljs.core.async.close_BANG_.call(null,inst_60016);
var inst_60018 = cljs.core.next.call(null,inst_60006);
var inst_59992 = inst_60018;
var inst_59993 = null;
var inst_59994 = (0);
var inst_59995 = (0);
var state_60051__$1 = (function (){var statearr_60071 = state_60051;
(statearr_60071[(12)] = inst_60017);

(statearr_60071[(13)] = inst_59993);

(statearr_60071[(14)] = inst_59995);

(statearr_60071[(15)] = inst_59994);

(statearr_60071[(16)] = inst_59992);

return statearr_60071;
})();
var statearr_60072_60113 = state_60051__$1;
(statearr_60072_60113[(2)] = null);

(statearr_60072_60113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (3))){
var inst_60049 = (state_60051[(2)]);
var state_60051__$1 = state_60051;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60051__$1,inst_60049);
} else {
if((state_val_60052 === (12))){
var inst_60026 = (state_60051[(2)]);
var state_60051__$1 = state_60051;
var statearr_60073_60114 = state_60051__$1;
(statearr_60073_60114[(2)] = inst_60026);

(statearr_60073_60114[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (2))){
var state_60051__$1 = state_60051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60051__$1,(4),ch);
} else {
if((state_val_60052 === (23))){
var state_60051__$1 = state_60051;
var statearr_60074_60115 = state_60051__$1;
(statearr_60074_60115[(2)] = null);

(statearr_60074_60115[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (19))){
var inst_60032 = (state_60051[(11)]);
var inst_59982 = (state_60051[(8)]);
var inst_60034 = cljs.core.async.muxch_STAR_.call(null,inst_60032);
var state_60051__$1 = state_60051;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60051__$1,(22),inst_60034,inst_59982);
} else {
if((state_val_60052 === (11))){
var inst_60006 = (state_60051[(10)]);
var inst_59992 = (state_60051[(16)]);
var inst_60006__$1 = cljs.core.seq.call(null,inst_59992);
var state_60051__$1 = (function (){var statearr_60075 = state_60051;
(statearr_60075[(10)] = inst_60006__$1);

return statearr_60075;
})();
if(inst_60006__$1){
var statearr_60076_60116 = state_60051__$1;
(statearr_60076_60116[(1)] = (13));

} else {
var statearr_60077_60117 = state_60051__$1;
(statearr_60077_60117[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (9))){
var inst_60028 = (state_60051[(2)]);
var state_60051__$1 = state_60051;
var statearr_60078_60118 = state_60051__$1;
(statearr_60078_60118[(2)] = inst_60028);

(statearr_60078_60118[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (5))){
var inst_59989 = cljs.core.deref.call(null,mults);
var inst_59990 = cljs.core.vals.call(null,inst_59989);
var inst_59991 = cljs.core.seq.call(null,inst_59990);
var inst_59992 = inst_59991;
var inst_59993 = null;
var inst_59994 = (0);
var inst_59995 = (0);
var state_60051__$1 = (function (){var statearr_60079 = state_60051;
(statearr_60079[(13)] = inst_59993);

(statearr_60079[(14)] = inst_59995);

(statearr_60079[(15)] = inst_59994);

(statearr_60079[(16)] = inst_59992);

return statearr_60079;
})();
var statearr_60080_60119 = state_60051__$1;
(statearr_60080_60119[(2)] = null);

(statearr_60080_60119[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (14))){
var state_60051__$1 = state_60051;
var statearr_60084_60120 = state_60051__$1;
(statearr_60084_60120[(2)] = null);

(statearr_60084_60120[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (16))){
var inst_60006 = (state_60051[(10)]);
var inst_60010 = cljs.core.chunk_first.call(null,inst_60006);
var inst_60011 = cljs.core.chunk_rest.call(null,inst_60006);
var inst_60012 = cljs.core.count.call(null,inst_60010);
var inst_59992 = inst_60011;
var inst_59993 = inst_60010;
var inst_59994 = inst_60012;
var inst_59995 = (0);
var state_60051__$1 = (function (){var statearr_60085 = state_60051;
(statearr_60085[(13)] = inst_59993);

(statearr_60085[(14)] = inst_59995);

(statearr_60085[(15)] = inst_59994);

(statearr_60085[(16)] = inst_59992);

return statearr_60085;
})();
var statearr_60086_60121 = state_60051__$1;
(statearr_60086_60121[(2)] = null);

(statearr_60086_60121[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (10))){
var inst_59993 = (state_60051[(13)]);
var inst_59995 = (state_60051[(14)]);
var inst_59994 = (state_60051[(15)]);
var inst_59992 = (state_60051[(16)]);
var inst_60000 = cljs.core._nth.call(null,inst_59993,inst_59995);
var inst_60001 = cljs.core.async.muxch_STAR_.call(null,inst_60000);
var inst_60002 = cljs.core.async.close_BANG_.call(null,inst_60001);
var inst_60003 = (inst_59995 + (1));
var tmp60081 = inst_59993;
var tmp60082 = inst_59994;
var tmp60083 = inst_59992;
var inst_59992__$1 = tmp60083;
var inst_59993__$1 = tmp60081;
var inst_59994__$1 = tmp60082;
var inst_59995__$1 = inst_60003;
var state_60051__$1 = (function (){var statearr_60087 = state_60051;
(statearr_60087[(17)] = inst_60002);

(statearr_60087[(13)] = inst_59993__$1);

(statearr_60087[(14)] = inst_59995__$1);

(statearr_60087[(15)] = inst_59994__$1);

(statearr_60087[(16)] = inst_59992__$1);

return statearr_60087;
})();
var statearr_60088_60122 = state_60051__$1;
(statearr_60088_60122[(2)] = null);

(statearr_60088_60122[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (18))){
var inst_60021 = (state_60051[(2)]);
var state_60051__$1 = state_60051;
var statearr_60089_60123 = state_60051__$1;
(statearr_60089_60123[(2)] = inst_60021);

(statearr_60089_60123[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60052 === (8))){
var inst_59995 = (state_60051[(14)]);
var inst_59994 = (state_60051[(15)]);
var inst_59997 = (inst_59995 < inst_59994);
var inst_59998 = inst_59997;
var state_60051__$1 = state_60051;
if(cljs.core.truth_(inst_59998)){
var statearr_60090_60124 = state_60051__$1;
(statearr_60090_60124[(1)] = (10));

} else {
var statearr_60091_60125 = state_60051__$1;
(statearr_60091_60125[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___60097,mults,ensure_mult,p))
;
return ((function (switch__58824__auto__,c__58877__auto___60097,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__58825__auto__ = null;
var cljs$core$async$state_machine__58825__auto____0 = (function (){
var statearr_60092 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60092[(0)] = cljs$core$async$state_machine__58825__auto__);

(statearr_60092[(1)] = (1));

return statearr_60092;
});
var cljs$core$async$state_machine__58825__auto____1 = (function (state_60051){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_60051);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e60093){if((e60093 instanceof Object)){
var ex__58828__auto__ = e60093;
var statearr_60094_60126 = state_60051;
(statearr_60094_60126[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60051);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60093;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60127 = state_60051;
state_60051 = G__60127;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$state_machine__58825__auto__ = function(state_60051){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__58825__auto____1.call(this,state_60051);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__58825__auto____0;
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__58825__auto____1;
return cljs$core$async$state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___60097,mults,ensure_mult,p))
})();
var state__58879__auto__ = (function (){var statearr_60095 = f__58878__auto__.call(null);
(statearr_60095[(6)] = c__58877__auto___60097);

return statearr_60095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___60097,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__60129 = arguments.length;
switch (G__60129) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__60132 = arguments.length;
switch (G__60132) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__60135 = arguments.length;
switch (G__60135) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__58877__auto___60202 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___60202,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___60202,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_60174){
var state_val_60175 = (state_60174[(1)]);
if((state_val_60175 === (7))){
var state_60174__$1 = state_60174;
var statearr_60176_60203 = state_60174__$1;
(statearr_60176_60203[(2)] = null);

(statearr_60176_60203[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60175 === (1))){
var state_60174__$1 = state_60174;
var statearr_60177_60204 = state_60174__$1;
(statearr_60177_60204[(2)] = null);

(statearr_60177_60204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60175 === (4))){
var inst_60138 = (state_60174[(7)]);
var inst_60140 = (inst_60138 < cnt);
var state_60174__$1 = state_60174;
if(cljs.core.truth_(inst_60140)){
var statearr_60178_60205 = state_60174__$1;
(statearr_60178_60205[(1)] = (6));

} else {
var statearr_60179_60206 = state_60174__$1;
(statearr_60179_60206[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60175 === (15))){
var inst_60170 = (state_60174[(2)]);
var state_60174__$1 = state_60174;
var statearr_60180_60207 = state_60174__$1;
(statearr_60180_60207[(2)] = inst_60170);

(statearr_60180_60207[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60175 === (13))){
var inst_60163 = cljs.core.async.close_BANG_.call(null,out);
var state_60174__$1 = state_60174;
var statearr_60181_60208 = state_60174__$1;
(statearr_60181_60208[(2)] = inst_60163);

(statearr_60181_60208[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60175 === (6))){
var state_60174__$1 = state_60174;
var statearr_60182_60209 = state_60174__$1;
(statearr_60182_60209[(2)] = null);

(statearr_60182_60209[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60175 === (3))){
var inst_60172 = (state_60174[(2)]);
var state_60174__$1 = state_60174;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60174__$1,inst_60172);
} else {
if((state_val_60175 === (12))){
var inst_60160 = (state_60174[(8)]);
var inst_60160__$1 = (state_60174[(2)]);
var inst_60161 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_60160__$1);
var state_60174__$1 = (function (){var statearr_60183 = state_60174;
(statearr_60183[(8)] = inst_60160__$1);

return statearr_60183;
})();
if(cljs.core.truth_(inst_60161)){
var statearr_60184_60210 = state_60174__$1;
(statearr_60184_60210[(1)] = (13));

} else {
var statearr_60185_60211 = state_60174__$1;
(statearr_60185_60211[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60175 === (2))){
var inst_60137 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_60138 = (0);
var state_60174__$1 = (function (){var statearr_60186 = state_60174;
(statearr_60186[(9)] = inst_60137);

(statearr_60186[(7)] = inst_60138);

return statearr_60186;
})();
var statearr_60187_60212 = state_60174__$1;
(statearr_60187_60212[(2)] = null);

(statearr_60187_60212[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60175 === (11))){
var inst_60138 = (state_60174[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_60174,(10),Object,null,(9));
var inst_60147 = chs__$1.call(null,inst_60138);
var inst_60148 = done.call(null,inst_60138);
var inst_60149 = cljs.core.async.take_BANG_.call(null,inst_60147,inst_60148);
var state_60174__$1 = state_60174;
var statearr_60188_60213 = state_60174__$1;
(statearr_60188_60213[(2)] = inst_60149);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60174__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60175 === (9))){
var inst_60138 = (state_60174[(7)]);
var inst_60151 = (state_60174[(2)]);
var inst_60152 = (inst_60138 + (1));
var inst_60138__$1 = inst_60152;
var state_60174__$1 = (function (){var statearr_60189 = state_60174;
(statearr_60189[(7)] = inst_60138__$1);

(statearr_60189[(10)] = inst_60151);

return statearr_60189;
})();
var statearr_60190_60214 = state_60174__$1;
(statearr_60190_60214[(2)] = null);

(statearr_60190_60214[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60175 === (5))){
var inst_60158 = (state_60174[(2)]);
var state_60174__$1 = (function (){var statearr_60191 = state_60174;
(statearr_60191[(11)] = inst_60158);

return statearr_60191;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60174__$1,(12),dchan);
} else {
if((state_val_60175 === (14))){
var inst_60160 = (state_60174[(8)]);
var inst_60165 = cljs.core.apply.call(null,f,inst_60160);
var state_60174__$1 = state_60174;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60174__$1,(16),out,inst_60165);
} else {
if((state_val_60175 === (16))){
var inst_60167 = (state_60174[(2)]);
var state_60174__$1 = (function (){var statearr_60192 = state_60174;
(statearr_60192[(12)] = inst_60167);

return statearr_60192;
})();
var statearr_60193_60215 = state_60174__$1;
(statearr_60193_60215[(2)] = null);

(statearr_60193_60215[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60175 === (10))){
var inst_60142 = (state_60174[(2)]);
var inst_60143 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_60174__$1 = (function (){var statearr_60194 = state_60174;
(statearr_60194[(13)] = inst_60142);

return statearr_60194;
})();
var statearr_60195_60216 = state_60174__$1;
(statearr_60195_60216[(2)] = inst_60143);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60174__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60175 === (8))){
var inst_60156 = (state_60174[(2)]);
var state_60174__$1 = state_60174;
var statearr_60196_60217 = state_60174__$1;
(statearr_60196_60217[(2)] = inst_60156);

(statearr_60196_60217[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___60202,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__58824__auto__,c__58877__auto___60202,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__58825__auto__ = null;
var cljs$core$async$state_machine__58825__auto____0 = (function (){
var statearr_60197 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60197[(0)] = cljs$core$async$state_machine__58825__auto__);

(statearr_60197[(1)] = (1));

return statearr_60197;
});
var cljs$core$async$state_machine__58825__auto____1 = (function (state_60174){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_60174);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e60198){if((e60198 instanceof Object)){
var ex__58828__auto__ = e60198;
var statearr_60199_60218 = state_60174;
(statearr_60199_60218[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60174);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60198;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60219 = state_60174;
state_60174 = G__60219;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$state_machine__58825__auto__ = function(state_60174){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__58825__auto____1.call(this,state_60174);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__58825__auto____0;
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__58825__auto____1;
return cljs$core$async$state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___60202,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__58879__auto__ = (function (){var statearr_60200 = f__58878__auto__.call(null);
(statearr_60200[(6)] = c__58877__auto___60202);

return statearr_60200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___60202,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__60222 = arguments.length;
switch (G__60222) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__58877__auto___60276 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___60276,out){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___60276,out){
return (function (state_60254){
var state_val_60255 = (state_60254[(1)]);
if((state_val_60255 === (7))){
var inst_60234 = (state_60254[(7)]);
var inst_60233 = (state_60254[(8)]);
var inst_60233__$1 = (state_60254[(2)]);
var inst_60234__$1 = cljs.core.nth.call(null,inst_60233__$1,(0),null);
var inst_60235 = cljs.core.nth.call(null,inst_60233__$1,(1),null);
var inst_60236 = (inst_60234__$1 == null);
var state_60254__$1 = (function (){var statearr_60256 = state_60254;
(statearr_60256[(9)] = inst_60235);

(statearr_60256[(7)] = inst_60234__$1);

(statearr_60256[(8)] = inst_60233__$1);

return statearr_60256;
})();
if(cljs.core.truth_(inst_60236)){
var statearr_60257_60277 = state_60254__$1;
(statearr_60257_60277[(1)] = (8));

} else {
var statearr_60258_60278 = state_60254__$1;
(statearr_60258_60278[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60255 === (1))){
var inst_60223 = cljs.core.vec.call(null,chs);
var inst_60224 = inst_60223;
var state_60254__$1 = (function (){var statearr_60259 = state_60254;
(statearr_60259[(10)] = inst_60224);

return statearr_60259;
})();
var statearr_60260_60279 = state_60254__$1;
(statearr_60260_60279[(2)] = null);

(statearr_60260_60279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60255 === (4))){
var inst_60224 = (state_60254[(10)]);
var state_60254__$1 = state_60254;
return cljs.core.async.ioc_alts_BANG_.call(null,state_60254__$1,(7),inst_60224);
} else {
if((state_val_60255 === (6))){
var inst_60250 = (state_60254[(2)]);
var state_60254__$1 = state_60254;
var statearr_60261_60280 = state_60254__$1;
(statearr_60261_60280[(2)] = inst_60250);

(statearr_60261_60280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60255 === (3))){
var inst_60252 = (state_60254[(2)]);
var state_60254__$1 = state_60254;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60254__$1,inst_60252);
} else {
if((state_val_60255 === (2))){
var inst_60224 = (state_60254[(10)]);
var inst_60226 = cljs.core.count.call(null,inst_60224);
var inst_60227 = (inst_60226 > (0));
var state_60254__$1 = state_60254;
if(cljs.core.truth_(inst_60227)){
var statearr_60263_60281 = state_60254__$1;
(statearr_60263_60281[(1)] = (4));

} else {
var statearr_60264_60282 = state_60254__$1;
(statearr_60264_60282[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60255 === (11))){
var inst_60224 = (state_60254[(10)]);
var inst_60243 = (state_60254[(2)]);
var tmp60262 = inst_60224;
var inst_60224__$1 = tmp60262;
var state_60254__$1 = (function (){var statearr_60265 = state_60254;
(statearr_60265[(11)] = inst_60243);

(statearr_60265[(10)] = inst_60224__$1);

return statearr_60265;
})();
var statearr_60266_60283 = state_60254__$1;
(statearr_60266_60283[(2)] = null);

(statearr_60266_60283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60255 === (9))){
var inst_60234 = (state_60254[(7)]);
var state_60254__$1 = state_60254;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60254__$1,(11),out,inst_60234);
} else {
if((state_val_60255 === (5))){
var inst_60248 = cljs.core.async.close_BANG_.call(null,out);
var state_60254__$1 = state_60254;
var statearr_60267_60284 = state_60254__$1;
(statearr_60267_60284[(2)] = inst_60248);

(statearr_60267_60284[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60255 === (10))){
var inst_60246 = (state_60254[(2)]);
var state_60254__$1 = state_60254;
var statearr_60268_60285 = state_60254__$1;
(statearr_60268_60285[(2)] = inst_60246);

(statearr_60268_60285[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60255 === (8))){
var inst_60235 = (state_60254[(9)]);
var inst_60234 = (state_60254[(7)]);
var inst_60233 = (state_60254[(8)]);
var inst_60224 = (state_60254[(10)]);
var inst_60238 = (function (){var cs = inst_60224;
var vec__60229 = inst_60233;
var v = inst_60234;
var c = inst_60235;
return ((function (cs,vec__60229,v,c,inst_60235,inst_60234,inst_60233,inst_60224,state_val_60255,c__58877__auto___60276,out){
return (function (p1__60220_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__60220_SHARP_);
});
;})(cs,vec__60229,v,c,inst_60235,inst_60234,inst_60233,inst_60224,state_val_60255,c__58877__auto___60276,out))
})();
var inst_60239 = cljs.core.filterv.call(null,inst_60238,inst_60224);
var inst_60224__$1 = inst_60239;
var state_60254__$1 = (function (){var statearr_60269 = state_60254;
(statearr_60269[(10)] = inst_60224__$1);

return statearr_60269;
})();
var statearr_60270_60286 = state_60254__$1;
(statearr_60270_60286[(2)] = null);

(statearr_60270_60286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___60276,out))
;
return ((function (switch__58824__auto__,c__58877__auto___60276,out){
return (function() {
var cljs$core$async$state_machine__58825__auto__ = null;
var cljs$core$async$state_machine__58825__auto____0 = (function (){
var statearr_60271 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60271[(0)] = cljs$core$async$state_machine__58825__auto__);

(statearr_60271[(1)] = (1));

return statearr_60271;
});
var cljs$core$async$state_machine__58825__auto____1 = (function (state_60254){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_60254);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e60272){if((e60272 instanceof Object)){
var ex__58828__auto__ = e60272;
var statearr_60273_60287 = state_60254;
(statearr_60273_60287[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60254);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60272;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60288 = state_60254;
state_60254 = G__60288;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$state_machine__58825__auto__ = function(state_60254){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__58825__auto____1.call(this,state_60254);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__58825__auto____0;
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__58825__auto____1;
return cljs$core$async$state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___60276,out))
})();
var state__58879__auto__ = (function (){var statearr_60274 = f__58878__auto__.call(null);
(statearr_60274[(6)] = c__58877__auto___60276);

return statearr_60274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___60276,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__60290 = arguments.length;
switch (G__60290) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__58877__auto___60335 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___60335,out){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___60335,out){
return (function (state_60314){
var state_val_60315 = (state_60314[(1)]);
if((state_val_60315 === (7))){
var inst_60296 = (state_60314[(7)]);
var inst_60296__$1 = (state_60314[(2)]);
var inst_60297 = (inst_60296__$1 == null);
var inst_60298 = cljs.core.not.call(null,inst_60297);
var state_60314__$1 = (function (){var statearr_60316 = state_60314;
(statearr_60316[(7)] = inst_60296__$1);

return statearr_60316;
})();
if(inst_60298){
var statearr_60317_60336 = state_60314__$1;
(statearr_60317_60336[(1)] = (8));

} else {
var statearr_60318_60337 = state_60314__$1;
(statearr_60318_60337[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60315 === (1))){
var inst_60291 = (0);
var state_60314__$1 = (function (){var statearr_60319 = state_60314;
(statearr_60319[(8)] = inst_60291);

return statearr_60319;
})();
var statearr_60320_60338 = state_60314__$1;
(statearr_60320_60338[(2)] = null);

(statearr_60320_60338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60315 === (4))){
var state_60314__$1 = state_60314;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60314__$1,(7),ch);
} else {
if((state_val_60315 === (6))){
var inst_60309 = (state_60314[(2)]);
var state_60314__$1 = state_60314;
var statearr_60321_60339 = state_60314__$1;
(statearr_60321_60339[(2)] = inst_60309);

(statearr_60321_60339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60315 === (3))){
var inst_60311 = (state_60314[(2)]);
var inst_60312 = cljs.core.async.close_BANG_.call(null,out);
var state_60314__$1 = (function (){var statearr_60322 = state_60314;
(statearr_60322[(9)] = inst_60311);

return statearr_60322;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60314__$1,inst_60312);
} else {
if((state_val_60315 === (2))){
var inst_60291 = (state_60314[(8)]);
var inst_60293 = (inst_60291 < n);
var state_60314__$1 = state_60314;
if(cljs.core.truth_(inst_60293)){
var statearr_60323_60340 = state_60314__$1;
(statearr_60323_60340[(1)] = (4));

} else {
var statearr_60324_60341 = state_60314__$1;
(statearr_60324_60341[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60315 === (11))){
var inst_60291 = (state_60314[(8)]);
var inst_60301 = (state_60314[(2)]);
var inst_60302 = (inst_60291 + (1));
var inst_60291__$1 = inst_60302;
var state_60314__$1 = (function (){var statearr_60325 = state_60314;
(statearr_60325[(8)] = inst_60291__$1);

(statearr_60325[(10)] = inst_60301);

return statearr_60325;
})();
var statearr_60326_60342 = state_60314__$1;
(statearr_60326_60342[(2)] = null);

(statearr_60326_60342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60315 === (9))){
var state_60314__$1 = state_60314;
var statearr_60327_60343 = state_60314__$1;
(statearr_60327_60343[(2)] = null);

(statearr_60327_60343[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60315 === (5))){
var state_60314__$1 = state_60314;
var statearr_60328_60344 = state_60314__$1;
(statearr_60328_60344[(2)] = null);

(statearr_60328_60344[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60315 === (10))){
var inst_60306 = (state_60314[(2)]);
var state_60314__$1 = state_60314;
var statearr_60329_60345 = state_60314__$1;
(statearr_60329_60345[(2)] = inst_60306);

(statearr_60329_60345[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60315 === (8))){
var inst_60296 = (state_60314[(7)]);
var state_60314__$1 = state_60314;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60314__$1,(11),out,inst_60296);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___60335,out))
;
return ((function (switch__58824__auto__,c__58877__auto___60335,out){
return (function() {
var cljs$core$async$state_machine__58825__auto__ = null;
var cljs$core$async$state_machine__58825__auto____0 = (function (){
var statearr_60330 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_60330[(0)] = cljs$core$async$state_machine__58825__auto__);

(statearr_60330[(1)] = (1));

return statearr_60330;
});
var cljs$core$async$state_machine__58825__auto____1 = (function (state_60314){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_60314);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e60331){if((e60331 instanceof Object)){
var ex__58828__auto__ = e60331;
var statearr_60332_60346 = state_60314;
(statearr_60332_60346[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60314);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60331;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60347 = state_60314;
state_60314 = G__60347;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$state_machine__58825__auto__ = function(state_60314){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__58825__auto____1.call(this,state_60314);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__58825__auto____0;
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__58825__auto____1;
return cljs$core$async$state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___60335,out))
})();
var state__58879__auto__ = (function (){var statearr_60333 = f__58878__auto__.call(null);
(statearr_60333[(6)] = c__58877__auto___60335);

return statearr_60333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___60335,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async60349 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async60349 = (function (f,ch,meta60350){
this.f = f;
this.ch = ch;
this.meta60350 = meta60350;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async60349.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_60351,meta60350__$1){
var self__ = this;
var _60351__$1 = this;
return (new cljs.core.async.t_cljs$core$async60349(self__.f,self__.ch,meta60350__$1));
});

cljs.core.async.t_cljs$core$async60349.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_60351){
var self__ = this;
var _60351__$1 = this;
return self__.meta60350;
});

cljs.core.async.t_cljs$core$async60349.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60349.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60349.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60349.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60349.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async60352 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async60352 = (function (f,ch,meta60350,_,fn1,meta60353){
this.f = f;
this.ch = ch;
this.meta60350 = meta60350;
this._ = _;
this.fn1 = fn1;
this.meta60353 = meta60353;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async60352.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_60354,meta60353__$1){
var self__ = this;
var _60354__$1 = this;
return (new cljs.core.async.t_cljs$core$async60352(self__.f,self__.ch,self__.meta60350,self__._,self__.fn1,meta60353__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async60352.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_60354){
var self__ = this;
var _60354__$1 = this;
return self__.meta60353;
});})(___$1))
;

cljs.core.async.t_cljs$core$async60352.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60352.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async60352.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async60352.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__60348_SHARP_){
return f1.call(null,(((p1__60348_SHARP_ == null))?null:self__.f.call(null,p1__60348_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async60352.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta60350","meta60350",-389471269,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async60349","cljs.core.async/t_cljs$core$async60349",679761540,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta60353","meta60353",-1033275649,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async60352.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async60352.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async60352";

cljs.core.async.t_cljs$core$async60352.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__54810__auto__,writer__54811__auto__,opt__54812__auto__){
return cljs.core._write.call(null,writer__54811__auto__,"cljs.core.async/t_cljs$core$async60352");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async60352 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async60352(f__$1,ch__$1,meta60350__$1,___$2,fn1__$1,meta60353){
return (new cljs.core.async.t_cljs$core$async60352(f__$1,ch__$1,meta60350__$1,___$2,fn1__$1,meta60353));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async60352(self__.f,self__.ch,self__.meta60350,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__54173__auto__ = ret;
if(cljs.core.truth_(and__54173__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__54173__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async60349.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60349.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async60349.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta60350","meta60350",-389471269,null)], null);
});

cljs.core.async.t_cljs$core$async60349.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async60349.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async60349";

cljs.core.async.t_cljs$core$async60349.cljs$lang$ctorPrWriter = (function (this__54810__auto__,writer__54811__auto__,opt__54812__auto__){
return cljs.core._write.call(null,writer__54811__auto__,"cljs.core.async/t_cljs$core$async60349");
});

cljs.core.async.__GT_t_cljs$core$async60349 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async60349(f__$1,ch__$1,meta60350){
return (new cljs.core.async.t_cljs$core$async60349(f__$1,ch__$1,meta60350));
});

}

return (new cljs.core.async.t_cljs$core$async60349(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async60355 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async60355 = (function (f,ch,meta60356){
this.f = f;
this.ch = ch;
this.meta60356 = meta60356;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async60355.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_60357,meta60356__$1){
var self__ = this;
var _60357__$1 = this;
return (new cljs.core.async.t_cljs$core$async60355(self__.f,self__.ch,meta60356__$1));
});

cljs.core.async.t_cljs$core$async60355.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_60357){
var self__ = this;
var _60357__$1 = this;
return self__.meta60356;
});

cljs.core.async.t_cljs$core$async60355.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60355.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60355.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60355.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async60355.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60355.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async60355.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta60356","meta60356",-461040412,null)], null);
});

cljs.core.async.t_cljs$core$async60355.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async60355.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async60355";

cljs.core.async.t_cljs$core$async60355.cljs$lang$ctorPrWriter = (function (this__54810__auto__,writer__54811__auto__,opt__54812__auto__){
return cljs.core._write.call(null,writer__54811__auto__,"cljs.core.async/t_cljs$core$async60355");
});

cljs.core.async.__GT_t_cljs$core$async60355 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async60355(f__$1,ch__$1,meta60356){
return (new cljs.core.async.t_cljs$core$async60355(f__$1,ch__$1,meta60356));
});

}

return (new cljs.core.async.t_cljs$core$async60355(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async60358 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async60358 = (function (p,ch,meta60359){
this.p = p;
this.ch = ch;
this.meta60359 = meta60359;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async60358.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_60360,meta60359__$1){
var self__ = this;
var _60360__$1 = this;
return (new cljs.core.async.t_cljs$core$async60358(self__.p,self__.ch,meta60359__$1));
});

cljs.core.async.t_cljs$core$async60358.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_60360){
var self__ = this;
var _60360__$1 = this;
return self__.meta60359;
});

cljs.core.async.t_cljs$core$async60358.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60358.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60358.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60358.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60358.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async60358.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60358.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async60358.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta60359","meta60359",-174735895,null)], null);
});

cljs.core.async.t_cljs$core$async60358.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async60358.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async60358";

cljs.core.async.t_cljs$core$async60358.cljs$lang$ctorPrWriter = (function (this__54810__auto__,writer__54811__auto__,opt__54812__auto__){
return cljs.core._write.call(null,writer__54811__auto__,"cljs.core.async/t_cljs$core$async60358");
});

cljs.core.async.__GT_t_cljs$core$async60358 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async60358(p__$1,ch__$1,meta60359){
return (new cljs.core.async.t_cljs$core$async60358(p__$1,ch__$1,meta60359));
});

}

return (new cljs.core.async.t_cljs$core$async60358(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__60362 = arguments.length;
switch (G__60362) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__58877__auto___60402 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___60402,out){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___60402,out){
return (function (state_60383){
var state_val_60384 = (state_60383[(1)]);
if((state_val_60384 === (7))){
var inst_60379 = (state_60383[(2)]);
var state_60383__$1 = state_60383;
var statearr_60385_60403 = state_60383__$1;
(statearr_60385_60403[(2)] = inst_60379);

(statearr_60385_60403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (1))){
var state_60383__$1 = state_60383;
var statearr_60386_60404 = state_60383__$1;
(statearr_60386_60404[(2)] = null);

(statearr_60386_60404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (4))){
var inst_60365 = (state_60383[(7)]);
var inst_60365__$1 = (state_60383[(2)]);
var inst_60366 = (inst_60365__$1 == null);
var state_60383__$1 = (function (){var statearr_60387 = state_60383;
(statearr_60387[(7)] = inst_60365__$1);

return statearr_60387;
})();
if(cljs.core.truth_(inst_60366)){
var statearr_60388_60405 = state_60383__$1;
(statearr_60388_60405[(1)] = (5));

} else {
var statearr_60389_60406 = state_60383__$1;
(statearr_60389_60406[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (6))){
var inst_60365 = (state_60383[(7)]);
var inst_60370 = p.call(null,inst_60365);
var state_60383__$1 = state_60383;
if(cljs.core.truth_(inst_60370)){
var statearr_60390_60407 = state_60383__$1;
(statearr_60390_60407[(1)] = (8));

} else {
var statearr_60391_60408 = state_60383__$1;
(statearr_60391_60408[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (3))){
var inst_60381 = (state_60383[(2)]);
var state_60383__$1 = state_60383;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60383__$1,inst_60381);
} else {
if((state_val_60384 === (2))){
var state_60383__$1 = state_60383;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60383__$1,(4),ch);
} else {
if((state_val_60384 === (11))){
var inst_60373 = (state_60383[(2)]);
var state_60383__$1 = state_60383;
var statearr_60392_60409 = state_60383__$1;
(statearr_60392_60409[(2)] = inst_60373);

(statearr_60392_60409[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (9))){
var state_60383__$1 = state_60383;
var statearr_60393_60410 = state_60383__$1;
(statearr_60393_60410[(2)] = null);

(statearr_60393_60410[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (5))){
var inst_60368 = cljs.core.async.close_BANG_.call(null,out);
var state_60383__$1 = state_60383;
var statearr_60394_60411 = state_60383__$1;
(statearr_60394_60411[(2)] = inst_60368);

(statearr_60394_60411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (10))){
var inst_60376 = (state_60383[(2)]);
var state_60383__$1 = (function (){var statearr_60395 = state_60383;
(statearr_60395[(8)] = inst_60376);

return statearr_60395;
})();
var statearr_60396_60412 = state_60383__$1;
(statearr_60396_60412[(2)] = null);

(statearr_60396_60412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60384 === (8))){
var inst_60365 = (state_60383[(7)]);
var state_60383__$1 = state_60383;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60383__$1,(11),out,inst_60365);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___60402,out))
;
return ((function (switch__58824__auto__,c__58877__auto___60402,out){
return (function() {
var cljs$core$async$state_machine__58825__auto__ = null;
var cljs$core$async$state_machine__58825__auto____0 = (function (){
var statearr_60397 = [null,null,null,null,null,null,null,null,null];
(statearr_60397[(0)] = cljs$core$async$state_machine__58825__auto__);

(statearr_60397[(1)] = (1));

return statearr_60397;
});
var cljs$core$async$state_machine__58825__auto____1 = (function (state_60383){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_60383);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e60398){if((e60398 instanceof Object)){
var ex__58828__auto__ = e60398;
var statearr_60399_60413 = state_60383;
(statearr_60399_60413[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60383);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60398;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60414 = state_60383;
state_60383 = G__60414;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$state_machine__58825__auto__ = function(state_60383){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__58825__auto____1.call(this,state_60383);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__58825__auto____0;
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__58825__auto____1;
return cljs$core$async$state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___60402,out))
})();
var state__58879__auto__ = (function (){var statearr_60400 = f__58878__auto__.call(null);
(statearr_60400[(6)] = c__58877__auto___60402);

return statearr_60400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___60402,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__60416 = arguments.length;
switch (G__60416) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__58877__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto__){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto__){
return (function (state_60479){
var state_val_60480 = (state_60479[(1)]);
if((state_val_60480 === (7))){
var inst_60475 = (state_60479[(2)]);
var state_60479__$1 = state_60479;
var statearr_60481_60519 = state_60479__$1;
(statearr_60481_60519[(2)] = inst_60475);

(statearr_60481_60519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (20))){
var inst_60445 = (state_60479[(7)]);
var inst_60456 = (state_60479[(2)]);
var inst_60457 = cljs.core.next.call(null,inst_60445);
var inst_60431 = inst_60457;
var inst_60432 = null;
var inst_60433 = (0);
var inst_60434 = (0);
var state_60479__$1 = (function (){var statearr_60482 = state_60479;
(statearr_60482[(8)] = inst_60431);

(statearr_60482[(9)] = inst_60432);

(statearr_60482[(10)] = inst_60434);

(statearr_60482[(11)] = inst_60433);

(statearr_60482[(12)] = inst_60456);

return statearr_60482;
})();
var statearr_60483_60520 = state_60479__$1;
(statearr_60483_60520[(2)] = null);

(statearr_60483_60520[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (1))){
var state_60479__$1 = state_60479;
var statearr_60484_60521 = state_60479__$1;
(statearr_60484_60521[(2)] = null);

(statearr_60484_60521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (4))){
var inst_60420 = (state_60479[(13)]);
var inst_60420__$1 = (state_60479[(2)]);
var inst_60421 = (inst_60420__$1 == null);
var state_60479__$1 = (function (){var statearr_60485 = state_60479;
(statearr_60485[(13)] = inst_60420__$1);

return statearr_60485;
})();
if(cljs.core.truth_(inst_60421)){
var statearr_60486_60522 = state_60479__$1;
(statearr_60486_60522[(1)] = (5));

} else {
var statearr_60487_60523 = state_60479__$1;
(statearr_60487_60523[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (15))){
var state_60479__$1 = state_60479;
var statearr_60491_60524 = state_60479__$1;
(statearr_60491_60524[(2)] = null);

(statearr_60491_60524[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (21))){
var state_60479__$1 = state_60479;
var statearr_60492_60525 = state_60479__$1;
(statearr_60492_60525[(2)] = null);

(statearr_60492_60525[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (13))){
var inst_60431 = (state_60479[(8)]);
var inst_60432 = (state_60479[(9)]);
var inst_60434 = (state_60479[(10)]);
var inst_60433 = (state_60479[(11)]);
var inst_60441 = (state_60479[(2)]);
var inst_60442 = (inst_60434 + (1));
var tmp60488 = inst_60431;
var tmp60489 = inst_60432;
var tmp60490 = inst_60433;
var inst_60431__$1 = tmp60488;
var inst_60432__$1 = tmp60489;
var inst_60433__$1 = tmp60490;
var inst_60434__$1 = inst_60442;
var state_60479__$1 = (function (){var statearr_60493 = state_60479;
(statearr_60493[(8)] = inst_60431__$1);

(statearr_60493[(9)] = inst_60432__$1);

(statearr_60493[(10)] = inst_60434__$1);

(statearr_60493[(14)] = inst_60441);

(statearr_60493[(11)] = inst_60433__$1);

return statearr_60493;
})();
var statearr_60494_60526 = state_60479__$1;
(statearr_60494_60526[(2)] = null);

(statearr_60494_60526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (22))){
var state_60479__$1 = state_60479;
var statearr_60495_60527 = state_60479__$1;
(statearr_60495_60527[(2)] = null);

(statearr_60495_60527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (6))){
var inst_60420 = (state_60479[(13)]);
var inst_60429 = f.call(null,inst_60420);
var inst_60430 = cljs.core.seq.call(null,inst_60429);
var inst_60431 = inst_60430;
var inst_60432 = null;
var inst_60433 = (0);
var inst_60434 = (0);
var state_60479__$1 = (function (){var statearr_60496 = state_60479;
(statearr_60496[(8)] = inst_60431);

(statearr_60496[(9)] = inst_60432);

(statearr_60496[(10)] = inst_60434);

(statearr_60496[(11)] = inst_60433);

return statearr_60496;
})();
var statearr_60497_60528 = state_60479__$1;
(statearr_60497_60528[(2)] = null);

(statearr_60497_60528[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (17))){
var inst_60445 = (state_60479[(7)]);
var inst_60449 = cljs.core.chunk_first.call(null,inst_60445);
var inst_60450 = cljs.core.chunk_rest.call(null,inst_60445);
var inst_60451 = cljs.core.count.call(null,inst_60449);
var inst_60431 = inst_60450;
var inst_60432 = inst_60449;
var inst_60433 = inst_60451;
var inst_60434 = (0);
var state_60479__$1 = (function (){var statearr_60498 = state_60479;
(statearr_60498[(8)] = inst_60431);

(statearr_60498[(9)] = inst_60432);

(statearr_60498[(10)] = inst_60434);

(statearr_60498[(11)] = inst_60433);

return statearr_60498;
})();
var statearr_60499_60529 = state_60479__$1;
(statearr_60499_60529[(2)] = null);

(statearr_60499_60529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (3))){
var inst_60477 = (state_60479[(2)]);
var state_60479__$1 = state_60479;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60479__$1,inst_60477);
} else {
if((state_val_60480 === (12))){
var inst_60465 = (state_60479[(2)]);
var state_60479__$1 = state_60479;
var statearr_60500_60530 = state_60479__$1;
(statearr_60500_60530[(2)] = inst_60465);

(statearr_60500_60530[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (2))){
var state_60479__$1 = state_60479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60479__$1,(4),in$);
} else {
if((state_val_60480 === (23))){
var inst_60473 = (state_60479[(2)]);
var state_60479__$1 = state_60479;
var statearr_60501_60531 = state_60479__$1;
(statearr_60501_60531[(2)] = inst_60473);

(statearr_60501_60531[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (19))){
var inst_60460 = (state_60479[(2)]);
var state_60479__$1 = state_60479;
var statearr_60502_60532 = state_60479__$1;
(statearr_60502_60532[(2)] = inst_60460);

(statearr_60502_60532[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (11))){
var inst_60445 = (state_60479[(7)]);
var inst_60431 = (state_60479[(8)]);
var inst_60445__$1 = cljs.core.seq.call(null,inst_60431);
var state_60479__$1 = (function (){var statearr_60503 = state_60479;
(statearr_60503[(7)] = inst_60445__$1);

return statearr_60503;
})();
if(inst_60445__$1){
var statearr_60504_60533 = state_60479__$1;
(statearr_60504_60533[(1)] = (14));

} else {
var statearr_60505_60534 = state_60479__$1;
(statearr_60505_60534[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (9))){
var inst_60467 = (state_60479[(2)]);
var inst_60468 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_60479__$1 = (function (){var statearr_60506 = state_60479;
(statearr_60506[(15)] = inst_60467);

return statearr_60506;
})();
if(cljs.core.truth_(inst_60468)){
var statearr_60507_60535 = state_60479__$1;
(statearr_60507_60535[(1)] = (21));

} else {
var statearr_60508_60536 = state_60479__$1;
(statearr_60508_60536[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (5))){
var inst_60423 = cljs.core.async.close_BANG_.call(null,out);
var state_60479__$1 = state_60479;
var statearr_60509_60537 = state_60479__$1;
(statearr_60509_60537[(2)] = inst_60423);

(statearr_60509_60537[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (14))){
var inst_60445 = (state_60479[(7)]);
var inst_60447 = cljs.core.chunked_seq_QMARK_.call(null,inst_60445);
var state_60479__$1 = state_60479;
if(inst_60447){
var statearr_60510_60538 = state_60479__$1;
(statearr_60510_60538[(1)] = (17));

} else {
var statearr_60511_60539 = state_60479__$1;
(statearr_60511_60539[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (16))){
var inst_60463 = (state_60479[(2)]);
var state_60479__$1 = state_60479;
var statearr_60512_60540 = state_60479__$1;
(statearr_60512_60540[(2)] = inst_60463);

(statearr_60512_60540[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60480 === (10))){
var inst_60432 = (state_60479[(9)]);
var inst_60434 = (state_60479[(10)]);
var inst_60439 = cljs.core._nth.call(null,inst_60432,inst_60434);
var state_60479__$1 = state_60479;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60479__$1,(13),out,inst_60439);
} else {
if((state_val_60480 === (18))){
var inst_60445 = (state_60479[(7)]);
var inst_60454 = cljs.core.first.call(null,inst_60445);
var state_60479__$1 = state_60479;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60479__$1,(20),out,inst_60454);
} else {
if((state_val_60480 === (8))){
var inst_60434 = (state_60479[(10)]);
var inst_60433 = (state_60479[(11)]);
var inst_60436 = (inst_60434 < inst_60433);
var inst_60437 = inst_60436;
var state_60479__$1 = state_60479;
if(cljs.core.truth_(inst_60437)){
var statearr_60513_60541 = state_60479__$1;
(statearr_60513_60541[(1)] = (10));

} else {
var statearr_60514_60542 = state_60479__$1;
(statearr_60514_60542[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto__))
;
return ((function (switch__58824__auto__,c__58877__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__58825__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__58825__auto____0 = (function (){
var statearr_60515 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60515[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__58825__auto__);

(statearr_60515[(1)] = (1));

return statearr_60515;
});
var cljs$core$async$mapcat_STAR__$_state_machine__58825__auto____1 = (function (state_60479){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_60479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e60516){if((e60516 instanceof Object)){
var ex__58828__auto__ = e60516;
var statearr_60517_60543 = state_60479;
(statearr_60517_60543[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60479);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60516;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60544 = state_60479;
state_60479 = G__60544;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__58825__auto__ = function(state_60479){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__58825__auto____1.call(this,state_60479);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__58825__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__58825__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto__))
})();
var state__58879__auto__ = (function (){var statearr_60518 = f__58878__auto__.call(null);
(statearr_60518[(6)] = c__58877__auto__);

return statearr_60518;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto__))
);

return c__58877__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__60546 = arguments.length;
switch (G__60546) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__60549 = arguments.length;
switch (G__60549) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__60552 = arguments.length;
switch (G__60552) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__58877__auto___60599 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___60599,out){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___60599,out){
return (function (state_60576){
var state_val_60577 = (state_60576[(1)]);
if((state_val_60577 === (7))){
var inst_60571 = (state_60576[(2)]);
var state_60576__$1 = state_60576;
var statearr_60578_60600 = state_60576__$1;
(statearr_60578_60600[(2)] = inst_60571);

(statearr_60578_60600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60577 === (1))){
var inst_60553 = null;
var state_60576__$1 = (function (){var statearr_60579 = state_60576;
(statearr_60579[(7)] = inst_60553);

return statearr_60579;
})();
var statearr_60580_60601 = state_60576__$1;
(statearr_60580_60601[(2)] = null);

(statearr_60580_60601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60577 === (4))){
var inst_60556 = (state_60576[(8)]);
var inst_60556__$1 = (state_60576[(2)]);
var inst_60557 = (inst_60556__$1 == null);
var inst_60558 = cljs.core.not.call(null,inst_60557);
var state_60576__$1 = (function (){var statearr_60581 = state_60576;
(statearr_60581[(8)] = inst_60556__$1);

return statearr_60581;
})();
if(inst_60558){
var statearr_60582_60602 = state_60576__$1;
(statearr_60582_60602[(1)] = (5));

} else {
var statearr_60583_60603 = state_60576__$1;
(statearr_60583_60603[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60577 === (6))){
var state_60576__$1 = state_60576;
var statearr_60584_60604 = state_60576__$1;
(statearr_60584_60604[(2)] = null);

(statearr_60584_60604[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60577 === (3))){
var inst_60573 = (state_60576[(2)]);
var inst_60574 = cljs.core.async.close_BANG_.call(null,out);
var state_60576__$1 = (function (){var statearr_60585 = state_60576;
(statearr_60585[(9)] = inst_60573);

return statearr_60585;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60576__$1,inst_60574);
} else {
if((state_val_60577 === (2))){
var state_60576__$1 = state_60576;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60576__$1,(4),ch);
} else {
if((state_val_60577 === (11))){
var inst_60556 = (state_60576[(8)]);
var inst_60565 = (state_60576[(2)]);
var inst_60553 = inst_60556;
var state_60576__$1 = (function (){var statearr_60586 = state_60576;
(statearr_60586[(7)] = inst_60553);

(statearr_60586[(10)] = inst_60565);

return statearr_60586;
})();
var statearr_60587_60605 = state_60576__$1;
(statearr_60587_60605[(2)] = null);

(statearr_60587_60605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60577 === (9))){
var inst_60556 = (state_60576[(8)]);
var state_60576__$1 = state_60576;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60576__$1,(11),out,inst_60556);
} else {
if((state_val_60577 === (5))){
var inst_60556 = (state_60576[(8)]);
var inst_60553 = (state_60576[(7)]);
var inst_60560 = cljs.core._EQ_.call(null,inst_60556,inst_60553);
var state_60576__$1 = state_60576;
if(inst_60560){
var statearr_60589_60606 = state_60576__$1;
(statearr_60589_60606[(1)] = (8));

} else {
var statearr_60590_60607 = state_60576__$1;
(statearr_60590_60607[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60577 === (10))){
var inst_60568 = (state_60576[(2)]);
var state_60576__$1 = state_60576;
var statearr_60591_60608 = state_60576__$1;
(statearr_60591_60608[(2)] = inst_60568);

(statearr_60591_60608[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60577 === (8))){
var inst_60553 = (state_60576[(7)]);
var tmp60588 = inst_60553;
var inst_60553__$1 = tmp60588;
var state_60576__$1 = (function (){var statearr_60592 = state_60576;
(statearr_60592[(7)] = inst_60553__$1);

return statearr_60592;
})();
var statearr_60593_60609 = state_60576__$1;
(statearr_60593_60609[(2)] = null);

(statearr_60593_60609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___60599,out))
;
return ((function (switch__58824__auto__,c__58877__auto___60599,out){
return (function() {
var cljs$core$async$state_machine__58825__auto__ = null;
var cljs$core$async$state_machine__58825__auto____0 = (function (){
var statearr_60594 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_60594[(0)] = cljs$core$async$state_machine__58825__auto__);

(statearr_60594[(1)] = (1));

return statearr_60594;
});
var cljs$core$async$state_machine__58825__auto____1 = (function (state_60576){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_60576);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e60595){if((e60595 instanceof Object)){
var ex__58828__auto__ = e60595;
var statearr_60596_60610 = state_60576;
(statearr_60596_60610[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60576);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60595;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60611 = state_60576;
state_60576 = G__60611;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$state_machine__58825__auto__ = function(state_60576){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__58825__auto____1.call(this,state_60576);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__58825__auto____0;
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__58825__auto____1;
return cljs$core$async$state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___60599,out))
})();
var state__58879__auto__ = (function (){var statearr_60597 = f__58878__auto__.call(null);
(statearr_60597[(6)] = c__58877__auto___60599);

return statearr_60597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___60599,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__60613 = arguments.length;
switch (G__60613) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__58877__auto___60679 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___60679,out){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___60679,out){
return (function (state_60651){
var state_val_60652 = (state_60651[(1)]);
if((state_val_60652 === (7))){
var inst_60647 = (state_60651[(2)]);
var state_60651__$1 = state_60651;
var statearr_60653_60680 = state_60651__$1;
(statearr_60653_60680[(2)] = inst_60647);

(statearr_60653_60680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60652 === (1))){
var inst_60614 = (new Array(n));
var inst_60615 = inst_60614;
var inst_60616 = (0);
var state_60651__$1 = (function (){var statearr_60654 = state_60651;
(statearr_60654[(7)] = inst_60616);

(statearr_60654[(8)] = inst_60615);

return statearr_60654;
})();
var statearr_60655_60681 = state_60651__$1;
(statearr_60655_60681[(2)] = null);

(statearr_60655_60681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60652 === (4))){
var inst_60619 = (state_60651[(9)]);
var inst_60619__$1 = (state_60651[(2)]);
var inst_60620 = (inst_60619__$1 == null);
var inst_60621 = cljs.core.not.call(null,inst_60620);
var state_60651__$1 = (function (){var statearr_60656 = state_60651;
(statearr_60656[(9)] = inst_60619__$1);

return statearr_60656;
})();
if(inst_60621){
var statearr_60657_60682 = state_60651__$1;
(statearr_60657_60682[(1)] = (5));

} else {
var statearr_60658_60683 = state_60651__$1;
(statearr_60658_60683[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60652 === (15))){
var inst_60641 = (state_60651[(2)]);
var state_60651__$1 = state_60651;
var statearr_60659_60684 = state_60651__$1;
(statearr_60659_60684[(2)] = inst_60641);

(statearr_60659_60684[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60652 === (13))){
var state_60651__$1 = state_60651;
var statearr_60660_60685 = state_60651__$1;
(statearr_60660_60685[(2)] = null);

(statearr_60660_60685[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60652 === (6))){
var inst_60616 = (state_60651[(7)]);
var inst_60637 = (inst_60616 > (0));
var state_60651__$1 = state_60651;
if(cljs.core.truth_(inst_60637)){
var statearr_60661_60686 = state_60651__$1;
(statearr_60661_60686[(1)] = (12));

} else {
var statearr_60662_60687 = state_60651__$1;
(statearr_60662_60687[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60652 === (3))){
var inst_60649 = (state_60651[(2)]);
var state_60651__$1 = state_60651;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60651__$1,inst_60649);
} else {
if((state_val_60652 === (12))){
var inst_60615 = (state_60651[(8)]);
var inst_60639 = cljs.core.vec.call(null,inst_60615);
var state_60651__$1 = state_60651;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60651__$1,(15),out,inst_60639);
} else {
if((state_val_60652 === (2))){
var state_60651__$1 = state_60651;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60651__$1,(4),ch);
} else {
if((state_val_60652 === (11))){
var inst_60631 = (state_60651[(2)]);
var inst_60632 = (new Array(n));
var inst_60615 = inst_60632;
var inst_60616 = (0);
var state_60651__$1 = (function (){var statearr_60663 = state_60651;
(statearr_60663[(7)] = inst_60616);

(statearr_60663[(8)] = inst_60615);

(statearr_60663[(10)] = inst_60631);

return statearr_60663;
})();
var statearr_60664_60688 = state_60651__$1;
(statearr_60664_60688[(2)] = null);

(statearr_60664_60688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60652 === (9))){
var inst_60615 = (state_60651[(8)]);
var inst_60629 = cljs.core.vec.call(null,inst_60615);
var state_60651__$1 = state_60651;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60651__$1,(11),out,inst_60629);
} else {
if((state_val_60652 === (5))){
var inst_60624 = (state_60651[(11)]);
var inst_60616 = (state_60651[(7)]);
var inst_60615 = (state_60651[(8)]);
var inst_60619 = (state_60651[(9)]);
var inst_60623 = (inst_60615[inst_60616] = inst_60619);
var inst_60624__$1 = (inst_60616 + (1));
var inst_60625 = (inst_60624__$1 < n);
var state_60651__$1 = (function (){var statearr_60665 = state_60651;
(statearr_60665[(11)] = inst_60624__$1);

(statearr_60665[(12)] = inst_60623);

return statearr_60665;
})();
if(cljs.core.truth_(inst_60625)){
var statearr_60666_60689 = state_60651__$1;
(statearr_60666_60689[(1)] = (8));

} else {
var statearr_60667_60690 = state_60651__$1;
(statearr_60667_60690[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60652 === (14))){
var inst_60644 = (state_60651[(2)]);
var inst_60645 = cljs.core.async.close_BANG_.call(null,out);
var state_60651__$1 = (function (){var statearr_60669 = state_60651;
(statearr_60669[(13)] = inst_60644);

return statearr_60669;
})();
var statearr_60670_60691 = state_60651__$1;
(statearr_60670_60691[(2)] = inst_60645);

(statearr_60670_60691[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60652 === (10))){
var inst_60635 = (state_60651[(2)]);
var state_60651__$1 = state_60651;
var statearr_60671_60692 = state_60651__$1;
(statearr_60671_60692[(2)] = inst_60635);

(statearr_60671_60692[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60652 === (8))){
var inst_60624 = (state_60651[(11)]);
var inst_60615 = (state_60651[(8)]);
var tmp60668 = inst_60615;
var inst_60615__$1 = tmp60668;
var inst_60616 = inst_60624;
var state_60651__$1 = (function (){var statearr_60672 = state_60651;
(statearr_60672[(7)] = inst_60616);

(statearr_60672[(8)] = inst_60615__$1);

return statearr_60672;
})();
var statearr_60673_60693 = state_60651__$1;
(statearr_60673_60693[(2)] = null);

(statearr_60673_60693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___60679,out))
;
return ((function (switch__58824__auto__,c__58877__auto___60679,out){
return (function() {
var cljs$core$async$state_machine__58825__auto__ = null;
var cljs$core$async$state_machine__58825__auto____0 = (function (){
var statearr_60674 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60674[(0)] = cljs$core$async$state_machine__58825__auto__);

(statearr_60674[(1)] = (1));

return statearr_60674;
});
var cljs$core$async$state_machine__58825__auto____1 = (function (state_60651){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_60651);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e60675){if((e60675 instanceof Object)){
var ex__58828__auto__ = e60675;
var statearr_60676_60694 = state_60651;
(statearr_60676_60694[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60651);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60675;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60695 = state_60651;
state_60651 = G__60695;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$state_machine__58825__auto__ = function(state_60651){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__58825__auto____1.call(this,state_60651);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__58825__auto____0;
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__58825__auto____1;
return cljs$core$async$state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___60679,out))
})();
var state__58879__auto__ = (function (){var statearr_60677 = f__58878__auto__.call(null);
(statearr_60677[(6)] = c__58877__auto___60679);

return statearr_60677;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___60679,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__60697 = arguments.length;
switch (G__60697) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__58877__auto___60767 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___60767,out){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___60767,out){
return (function (state_60739){
var state_val_60740 = (state_60739[(1)]);
if((state_val_60740 === (7))){
var inst_60735 = (state_60739[(2)]);
var state_60739__$1 = state_60739;
var statearr_60741_60768 = state_60739__$1;
(statearr_60741_60768[(2)] = inst_60735);

(statearr_60741_60768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60740 === (1))){
var inst_60698 = [];
var inst_60699 = inst_60698;
var inst_60700 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_60739__$1 = (function (){var statearr_60742 = state_60739;
(statearr_60742[(7)] = inst_60699);

(statearr_60742[(8)] = inst_60700);

return statearr_60742;
})();
var statearr_60743_60769 = state_60739__$1;
(statearr_60743_60769[(2)] = null);

(statearr_60743_60769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60740 === (4))){
var inst_60703 = (state_60739[(9)]);
var inst_60703__$1 = (state_60739[(2)]);
var inst_60704 = (inst_60703__$1 == null);
var inst_60705 = cljs.core.not.call(null,inst_60704);
var state_60739__$1 = (function (){var statearr_60744 = state_60739;
(statearr_60744[(9)] = inst_60703__$1);

return statearr_60744;
})();
if(inst_60705){
var statearr_60745_60770 = state_60739__$1;
(statearr_60745_60770[(1)] = (5));

} else {
var statearr_60746_60771 = state_60739__$1;
(statearr_60746_60771[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60740 === (15))){
var inst_60729 = (state_60739[(2)]);
var state_60739__$1 = state_60739;
var statearr_60747_60772 = state_60739__$1;
(statearr_60747_60772[(2)] = inst_60729);

(statearr_60747_60772[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60740 === (13))){
var state_60739__$1 = state_60739;
var statearr_60748_60773 = state_60739__$1;
(statearr_60748_60773[(2)] = null);

(statearr_60748_60773[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60740 === (6))){
var inst_60699 = (state_60739[(7)]);
var inst_60724 = inst_60699.length;
var inst_60725 = (inst_60724 > (0));
var state_60739__$1 = state_60739;
if(cljs.core.truth_(inst_60725)){
var statearr_60749_60774 = state_60739__$1;
(statearr_60749_60774[(1)] = (12));

} else {
var statearr_60750_60775 = state_60739__$1;
(statearr_60750_60775[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60740 === (3))){
var inst_60737 = (state_60739[(2)]);
var state_60739__$1 = state_60739;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60739__$1,inst_60737);
} else {
if((state_val_60740 === (12))){
var inst_60699 = (state_60739[(7)]);
var inst_60727 = cljs.core.vec.call(null,inst_60699);
var state_60739__$1 = state_60739;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60739__$1,(15),out,inst_60727);
} else {
if((state_val_60740 === (2))){
var state_60739__$1 = state_60739;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60739__$1,(4),ch);
} else {
if((state_val_60740 === (11))){
var inst_60703 = (state_60739[(9)]);
var inst_60707 = (state_60739[(10)]);
var inst_60717 = (state_60739[(2)]);
var inst_60718 = [];
var inst_60719 = inst_60718.push(inst_60703);
var inst_60699 = inst_60718;
var inst_60700 = inst_60707;
var state_60739__$1 = (function (){var statearr_60751 = state_60739;
(statearr_60751[(7)] = inst_60699);

(statearr_60751[(11)] = inst_60717);

(statearr_60751[(12)] = inst_60719);

(statearr_60751[(8)] = inst_60700);

return statearr_60751;
})();
var statearr_60752_60776 = state_60739__$1;
(statearr_60752_60776[(2)] = null);

(statearr_60752_60776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60740 === (9))){
var inst_60699 = (state_60739[(7)]);
var inst_60715 = cljs.core.vec.call(null,inst_60699);
var state_60739__$1 = state_60739;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60739__$1,(11),out,inst_60715);
} else {
if((state_val_60740 === (5))){
var inst_60703 = (state_60739[(9)]);
var inst_60707 = (state_60739[(10)]);
var inst_60700 = (state_60739[(8)]);
var inst_60707__$1 = f.call(null,inst_60703);
var inst_60708 = cljs.core._EQ_.call(null,inst_60707__$1,inst_60700);
var inst_60709 = cljs.core.keyword_identical_QMARK_.call(null,inst_60700,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_60710 = (inst_60708) || (inst_60709);
var state_60739__$1 = (function (){var statearr_60753 = state_60739;
(statearr_60753[(10)] = inst_60707__$1);

return statearr_60753;
})();
if(cljs.core.truth_(inst_60710)){
var statearr_60754_60777 = state_60739__$1;
(statearr_60754_60777[(1)] = (8));

} else {
var statearr_60755_60778 = state_60739__$1;
(statearr_60755_60778[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60740 === (14))){
var inst_60732 = (state_60739[(2)]);
var inst_60733 = cljs.core.async.close_BANG_.call(null,out);
var state_60739__$1 = (function (){var statearr_60757 = state_60739;
(statearr_60757[(13)] = inst_60732);

return statearr_60757;
})();
var statearr_60758_60779 = state_60739__$1;
(statearr_60758_60779[(2)] = inst_60733);

(statearr_60758_60779[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60740 === (10))){
var inst_60722 = (state_60739[(2)]);
var state_60739__$1 = state_60739;
var statearr_60759_60780 = state_60739__$1;
(statearr_60759_60780[(2)] = inst_60722);

(statearr_60759_60780[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60740 === (8))){
var inst_60703 = (state_60739[(9)]);
var inst_60699 = (state_60739[(7)]);
var inst_60707 = (state_60739[(10)]);
var inst_60712 = inst_60699.push(inst_60703);
var tmp60756 = inst_60699;
var inst_60699__$1 = tmp60756;
var inst_60700 = inst_60707;
var state_60739__$1 = (function (){var statearr_60760 = state_60739;
(statearr_60760[(14)] = inst_60712);

(statearr_60760[(7)] = inst_60699__$1);

(statearr_60760[(8)] = inst_60700);

return statearr_60760;
})();
var statearr_60761_60781 = state_60739__$1;
(statearr_60761_60781[(2)] = null);

(statearr_60761_60781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___60767,out))
;
return ((function (switch__58824__auto__,c__58877__auto___60767,out){
return (function() {
var cljs$core$async$state_machine__58825__auto__ = null;
var cljs$core$async$state_machine__58825__auto____0 = (function (){
var statearr_60762 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60762[(0)] = cljs$core$async$state_machine__58825__auto__);

(statearr_60762[(1)] = (1));

return statearr_60762;
});
var cljs$core$async$state_machine__58825__auto____1 = (function (state_60739){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_60739);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e60763){if((e60763 instanceof Object)){
var ex__58828__auto__ = e60763;
var statearr_60764_60782 = state_60739;
(statearr_60764_60782[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60739);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60763;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60783 = state_60739;
state_60739 = G__60783;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
cljs$core$async$state_machine__58825__auto__ = function(state_60739){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__58825__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__58825__auto____1.call(this,state_60739);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__58825__auto____0;
cljs$core$async$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__58825__auto____1;
return cljs$core$async$state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___60767,out))
})();
var state__58879__auto__ = (function (){var statearr_60765 = f__58878__auto__.call(null);
(statearr_60765[(6)] = c__58877__auto___60767);

return statearr_60765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___60767,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1518787483790
