// Compiled by ClojureScript 1.9.908 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.14";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e65719){if((e65719 instanceof Error)){
var e = e65719;
return "Error: Unable to stringify";
} else {
throw e65719;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__65722 = arguments.length;
switch (G__65722) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__65720_SHARP_){
if(typeof p1__65720_SHARP_ === 'string'){
return p1__65720_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__65720_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__55361__auto__ = [];
var len__55354__auto___65725 = arguments.length;
var i__55355__auto___65726 = (0);
while(true){
if((i__55355__auto___65726 < len__55354__auto___65725)){
args__55361__auto__.push((arguments[i__55355__auto___65726]));

var G__65727 = (i__55355__auto___65726 + (1));
i__55355__auto___65726 = G__65727;
continue;
} else {
}
break;
}

var argseq__55362__auto__ = ((((0) < args__55361__auto__.length))?(new cljs.core.IndexedSeq(args__55361__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__55362__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq65724){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65724));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__55361__auto__ = [];
var len__55354__auto___65729 = arguments.length;
var i__55355__auto___65730 = (0);
while(true){
if((i__55355__auto___65730 < len__55354__auto___65729)){
args__55361__auto__.push((arguments[i__55355__auto___65730]));

var G__65731 = (i__55355__auto___65730 + (1));
i__55355__auto___65730 = G__65731;
continue;
} else {
}
break;
}

var argseq__55362__auto__ = ((((0) < args__55361__auto__.length))?(new cljs.core.IndexedSeq(args__55361__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__55362__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq65728){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65728));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__65732){
var map__65733 = p__65732;
var map__65733__$1 = ((((!((map__65733 == null)))?((((map__65733.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65733.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65733):map__65733);
var message = cljs.core.get.call(null,map__65733__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__65733__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__54185__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__54185__auto__)){
return or__54185__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__54173__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__54173__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__54173__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__58877__auto___65812 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___65812,ch){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___65812,ch){
return (function (state_65784){
var state_val_65785 = (state_65784[(1)]);
if((state_val_65785 === (7))){
var inst_65780 = (state_65784[(2)]);
var state_65784__$1 = state_65784;
var statearr_65786_65813 = state_65784__$1;
(statearr_65786_65813[(2)] = inst_65780);

(statearr_65786_65813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65785 === (1))){
var state_65784__$1 = state_65784;
var statearr_65787_65814 = state_65784__$1;
(statearr_65787_65814[(2)] = null);

(statearr_65787_65814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65785 === (4))){
var inst_65737 = (state_65784[(7)]);
var inst_65737__$1 = (state_65784[(2)]);
var state_65784__$1 = (function (){var statearr_65788 = state_65784;
(statearr_65788[(7)] = inst_65737__$1);

return statearr_65788;
})();
if(cljs.core.truth_(inst_65737__$1)){
var statearr_65789_65815 = state_65784__$1;
(statearr_65789_65815[(1)] = (5));

} else {
var statearr_65790_65816 = state_65784__$1;
(statearr_65790_65816[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65785 === (15))){
var inst_65744 = (state_65784[(8)]);
var inst_65759 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_65744);
var inst_65760 = cljs.core.first.call(null,inst_65759);
var inst_65761 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_65760);
var inst_65762 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65761)].join('');
var inst_65763 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_65762);
var state_65784__$1 = state_65784;
var statearr_65791_65817 = state_65784__$1;
(statearr_65791_65817[(2)] = inst_65763);

(statearr_65791_65817[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65785 === (13))){
var inst_65768 = (state_65784[(2)]);
var state_65784__$1 = state_65784;
var statearr_65792_65818 = state_65784__$1;
(statearr_65792_65818[(2)] = inst_65768);

(statearr_65792_65818[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65785 === (6))){
var state_65784__$1 = state_65784;
var statearr_65793_65819 = state_65784__$1;
(statearr_65793_65819[(2)] = null);

(statearr_65793_65819[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65785 === (17))){
var inst_65766 = (state_65784[(2)]);
var state_65784__$1 = state_65784;
var statearr_65794_65820 = state_65784__$1;
(statearr_65794_65820[(2)] = inst_65766);

(statearr_65794_65820[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65785 === (3))){
var inst_65782 = (state_65784[(2)]);
var state_65784__$1 = state_65784;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65784__$1,inst_65782);
} else {
if((state_val_65785 === (12))){
var inst_65743 = (state_65784[(9)]);
var inst_65757 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_65743,opts);
var state_65784__$1 = state_65784;
if(cljs.core.truth_(inst_65757)){
var statearr_65795_65821 = state_65784__$1;
(statearr_65795_65821[(1)] = (15));

} else {
var statearr_65796_65822 = state_65784__$1;
(statearr_65796_65822[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65785 === (2))){
var state_65784__$1 = state_65784;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65784__$1,(4),ch);
} else {
if((state_val_65785 === (11))){
var inst_65744 = (state_65784[(8)]);
var inst_65749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65750 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_65744);
var inst_65751 = cljs.core.async.timeout.call(null,(1000));
var inst_65752 = [inst_65750,inst_65751];
var inst_65753 = (new cljs.core.PersistentVector(null,2,(5),inst_65749,inst_65752,null));
var state_65784__$1 = state_65784;
return cljs.core.async.ioc_alts_BANG_.call(null,state_65784__$1,(14),inst_65753);
} else {
if((state_val_65785 === (9))){
var inst_65744 = (state_65784[(8)]);
var inst_65770 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_65771 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_65744);
var inst_65772 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_65771);
var inst_65773 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65772)].join('');
var inst_65774 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_65773);
var state_65784__$1 = (function (){var statearr_65797 = state_65784;
(statearr_65797[(10)] = inst_65770);

return statearr_65797;
})();
var statearr_65798_65823 = state_65784__$1;
(statearr_65798_65823[(2)] = inst_65774);

(statearr_65798_65823[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65785 === (5))){
var inst_65737 = (state_65784[(7)]);
var inst_65739 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_65740 = (new cljs.core.PersistentArrayMap(null,2,inst_65739,null));
var inst_65741 = (new cljs.core.PersistentHashSet(null,inst_65740,null));
var inst_65742 = figwheel.client.focus_msgs.call(null,inst_65741,inst_65737);
var inst_65743 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_65742);
var inst_65744 = cljs.core.first.call(null,inst_65742);
var inst_65745 = figwheel.client.autoload_QMARK_.call(null);
var state_65784__$1 = (function (){var statearr_65799 = state_65784;
(statearr_65799[(9)] = inst_65743);

(statearr_65799[(8)] = inst_65744);

return statearr_65799;
})();
if(cljs.core.truth_(inst_65745)){
var statearr_65800_65824 = state_65784__$1;
(statearr_65800_65824[(1)] = (8));

} else {
var statearr_65801_65825 = state_65784__$1;
(statearr_65801_65825[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65785 === (14))){
var inst_65755 = (state_65784[(2)]);
var state_65784__$1 = state_65784;
var statearr_65802_65826 = state_65784__$1;
(statearr_65802_65826[(2)] = inst_65755);

(statearr_65802_65826[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65785 === (16))){
var state_65784__$1 = state_65784;
var statearr_65803_65827 = state_65784__$1;
(statearr_65803_65827[(2)] = null);

(statearr_65803_65827[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65785 === (10))){
var inst_65776 = (state_65784[(2)]);
var state_65784__$1 = (function (){var statearr_65804 = state_65784;
(statearr_65804[(11)] = inst_65776);

return statearr_65804;
})();
var statearr_65805_65828 = state_65784__$1;
(statearr_65805_65828[(2)] = null);

(statearr_65805_65828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65785 === (8))){
var inst_65743 = (state_65784[(9)]);
var inst_65747 = figwheel.client.reload_file_state_QMARK_.call(null,inst_65743,opts);
var state_65784__$1 = state_65784;
if(cljs.core.truth_(inst_65747)){
var statearr_65806_65829 = state_65784__$1;
(statearr_65806_65829[(1)] = (11));

} else {
var statearr_65807_65830 = state_65784__$1;
(statearr_65807_65830[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___65812,ch))
;
return ((function (switch__58824__auto__,c__58877__auto___65812,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__58825__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__58825__auto____0 = (function (){
var statearr_65808 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65808[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__58825__auto__);

(statearr_65808[(1)] = (1));

return statearr_65808;
});
var figwheel$client$file_reloader_plugin_$_state_machine__58825__auto____1 = (function (state_65784){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_65784);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e65809){if((e65809 instanceof Object)){
var ex__58828__auto__ = e65809;
var statearr_65810_65831 = state_65784;
(statearr_65810_65831[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_65784);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e65809;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65832 = state_65784;
state_65784 = G__65832;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__58825__auto__ = function(state_65784){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__58825__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__58825__auto____1.call(this,state_65784);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__58825__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__58825__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___65812,ch))
})();
var state__58879__auto__ = (function (){var statearr_65811 = f__58878__auto__.call(null);
(statearr_65811[(6)] = c__58877__auto___65812);

return statearr_65811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___65812,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__65833_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__65833_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_65835 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_65835){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e65834){if((e65834 instanceof Error)){
var e = e65834;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_65835], null));
} else {
var e = e65834;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_65835))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__65836){
var map__65837 = p__65836;
var map__65837__$1 = ((((!((map__65837 == null)))?((((map__65837.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65837.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65837):map__65837);
var opts = map__65837__$1;
var build_id = cljs.core.get.call(null,map__65837__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__65837,map__65837__$1,opts,build_id){
return (function (p__65839){
var vec__65840 = p__65839;
var seq__65841 = cljs.core.seq.call(null,vec__65840);
var first__65842 = cljs.core.first.call(null,seq__65841);
var seq__65841__$1 = cljs.core.next.call(null,seq__65841);
var map__65843 = first__65842;
var map__65843__$1 = ((((!((map__65843 == null)))?((((map__65843.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65843.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65843):map__65843);
var msg = map__65843__$1;
var msg_name = cljs.core.get.call(null,map__65843__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__65841__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__65840,seq__65841,first__65842,seq__65841__$1,map__65843,map__65843__$1,msg,msg_name,_,map__65837,map__65837__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__65840,seq__65841,first__65842,seq__65841__$1,map__65843,map__65843__$1,msg,msg_name,_,map__65837,map__65837__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__65837,map__65837__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__65845){
var vec__65846 = p__65845;
var seq__65847 = cljs.core.seq.call(null,vec__65846);
var first__65848 = cljs.core.first.call(null,seq__65847);
var seq__65847__$1 = cljs.core.next.call(null,seq__65847);
var map__65849 = first__65848;
var map__65849__$1 = ((((!((map__65849 == null)))?((((map__65849.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65849.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65849):map__65849);
var msg = map__65849__$1;
var msg_name = cljs.core.get.call(null,map__65849__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__65847__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__65851){
var map__65852 = p__65851;
var map__65852__$1 = ((((!((map__65852 == null)))?((((map__65852.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65852.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65852):map__65852);
var on_compile_warning = cljs.core.get.call(null,map__65852__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__65852__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__65852,map__65852__$1,on_compile_warning,on_compile_fail){
return (function (p__65854){
var vec__65855 = p__65854;
var seq__65856 = cljs.core.seq.call(null,vec__65855);
var first__65857 = cljs.core.first.call(null,seq__65856);
var seq__65856__$1 = cljs.core.next.call(null,seq__65856);
var map__65858 = first__65857;
var map__65858__$1 = ((((!((map__65858 == null)))?((((map__65858.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65858.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65858):map__65858);
var msg = map__65858__$1;
var msg_name = cljs.core.get.call(null,map__65858__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__65856__$1;
var pred__65860 = cljs.core._EQ_;
var expr__65861 = msg_name;
if(cljs.core.truth_(pred__65860.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__65861))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__65860.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__65861))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__65852,map__65852__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__58877__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto__,msg_hist,msg_names,msg){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto__,msg_hist,msg_names,msg){
return (function (state_65950){
var state_val_65951 = (state_65950[(1)]);
if((state_val_65951 === (7))){
var inst_65870 = (state_65950[(2)]);
var state_65950__$1 = state_65950;
if(cljs.core.truth_(inst_65870)){
var statearr_65952_65999 = state_65950__$1;
(statearr_65952_65999[(1)] = (8));

} else {
var statearr_65953_66000 = state_65950__$1;
(statearr_65953_66000[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (20))){
var inst_65944 = (state_65950[(2)]);
var state_65950__$1 = state_65950;
var statearr_65954_66001 = state_65950__$1;
(statearr_65954_66001[(2)] = inst_65944);

(statearr_65954_66001[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (27))){
var inst_65940 = (state_65950[(2)]);
var state_65950__$1 = state_65950;
var statearr_65955_66002 = state_65950__$1;
(statearr_65955_66002[(2)] = inst_65940);

(statearr_65955_66002[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (1))){
var inst_65863 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_65950__$1 = state_65950;
if(cljs.core.truth_(inst_65863)){
var statearr_65956_66003 = state_65950__$1;
(statearr_65956_66003[(1)] = (2));

} else {
var statearr_65957_66004 = state_65950__$1;
(statearr_65957_66004[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (24))){
var inst_65942 = (state_65950[(2)]);
var state_65950__$1 = state_65950;
var statearr_65958_66005 = state_65950__$1;
(statearr_65958_66005[(2)] = inst_65942);

(statearr_65958_66005[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (4))){
var inst_65948 = (state_65950[(2)]);
var state_65950__$1 = state_65950;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65950__$1,inst_65948);
} else {
if((state_val_65951 === (15))){
var inst_65946 = (state_65950[(2)]);
var state_65950__$1 = state_65950;
var statearr_65959_66006 = state_65950__$1;
(statearr_65959_66006[(2)] = inst_65946);

(statearr_65959_66006[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (21))){
var inst_65899 = (state_65950[(2)]);
var inst_65900 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_65901 = figwheel.client.auto_jump_to_error.call(null,opts,inst_65900);
var state_65950__$1 = (function (){var statearr_65960 = state_65950;
(statearr_65960[(7)] = inst_65899);

return statearr_65960;
})();
var statearr_65961_66007 = state_65950__$1;
(statearr_65961_66007[(2)] = inst_65901);

(statearr_65961_66007[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (31))){
var inst_65929 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_65950__$1 = state_65950;
if(cljs.core.truth_(inst_65929)){
var statearr_65962_66008 = state_65950__$1;
(statearr_65962_66008[(1)] = (34));

} else {
var statearr_65963_66009 = state_65950__$1;
(statearr_65963_66009[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (32))){
var inst_65938 = (state_65950[(2)]);
var state_65950__$1 = state_65950;
var statearr_65964_66010 = state_65950__$1;
(statearr_65964_66010[(2)] = inst_65938);

(statearr_65964_66010[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (33))){
var inst_65925 = (state_65950[(2)]);
var inst_65926 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_65927 = figwheel.client.auto_jump_to_error.call(null,opts,inst_65926);
var state_65950__$1 = (function (){var statearr_65965 = state_65950;
(statearr_65965[(8)] = inst_65925);

return statearr_65965;
})();
var statearr_65966_66011 = state_65950__$1;
(statearr_65966_66011[(2)] = inst_65927);

(statearr_65966_66011[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (13))){
var inst_65884 = figwheel.client.heads_up.clear.call(null);
var state_65950__$1 = state_65950;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65950__$1,(16),inst_65884);
} else {
if((state_val_65951 === (22))){
var inst_65905 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_65906 = figwheel.client.heads_up.append_warning_message.call(null,inst_65905);
var state_65950__$1 = state_65950;
var statearr_65967_66012 = state_65950__$1;
(statearr_65967_66012[(2)] = inst_65906);

(statearr_65967_66012[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (36))){
var inst_65936 = (state_65950[(2)]);
var state_65950__$1 = state_65950;
var statearr_65968_66013 = state_65950__$1;
(statearr_65968_66013[(2)] = inst_65936);

(statearr_65968_66013[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (29))){
var inst_65916 = (state_65950[(2)]);
var inst_65917 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_65918 = figwheel.client.auto_jump_to_error.call(null,opts,inst_65917);
var state_65950__$1 = (function (){var statearr_65969 = state_65950;
(statearr_65969[(9)] = inst_65916);

return statearr_65969;
})();
var statearr_65970_66014 = state_65950__$1;
(statearr_65970_66014[(2)] = inst_65918);

(statearr_65970_66014[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (6))){
var inst_65865 = (state_65950[(10)]);
var state_65950__$1 = state_65950;
var statearr_65971_66015 = state_65950__$1;
(statearr_65971_66015[(2)] = inst_65865);

(statearr_65971_66015[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (28))){
var inst_65912 = (state_65950[(2)]);
var inst_65913 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_65914 = figwheel.client.heads_up.display_warning.call(null,inst_65913);
var state_65950__$1 = (function (){var statearr_65972 = state_65950;
(statearr_65972[(11)] = inst_65912);

return statearr_65972;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65950__$1,(29),inst_65914);
} else {
if((state_val_65951 === (25))){
var inst_65910 = figwheel.client.heads_up.clear.call(null);
var state_65950__$1 = state_65950;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65950__$1,(28),inst_65910);
} else {
if((state_val_65951 === (34))){
var inst_65931 = figwheel.client.heads_up.flash_loaded.call(null);
var state_65950__$1 = state_65950;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65950__$1,(37),inst_65931);
} else {
if((state_val_65951 === (17))){
var inst_65890 = (state_65950[(2)]);
var inst_65891 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_65892 = figwheel.client.auto_jump_to_error.call(null,opts,inst_65891);
var state_65950__$1 = (function (){var statearr_65973 = state_65950;
(statearr_65973[(12)] = inst_65890);

return statearr_65973;
})();
var statearr_65974_66016 = state_65950__$1;
(statearr_65974_66016[(2)] = inst_65892);

(statearr_65974_66016[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (3))){
var inst_65882 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_65950__$1 = state_65950;
if(cljs.core.truth_(inst_65882)){
var statearr_65975_66017 = state_65950__$1;
(statearr_65975_66017[(1)] = (13));

} else {
var statearr_65976_66018 = state_65950__$1;
(statearr_65976_66018[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (12))){
var inst_65878 = (state_65950[(2)]);
var state_65950__$1 = state_65950;
var statearr_65977_66019 = state_65950__$1;
(statearr_65977_66019[(2)] = inst_65878);

(statearr_65977_66019[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (2))){
var inst_65865 = (state_65950[(10)]);
var inst_65865__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_65950__$1 = (function (){var statearr_65978 = state_65950;
(statearr_65978[(10)] = inst_65865__$1);

return statearr_65978;
})();
if(cljs.core.truth_(inst_65865__$1)){
var statearr_65979_66020 = state_65950__$1;
(statearr_65979_66020[(1)] = (5));

} else {
var statearr_65980_66021 = state_65950__$1;
(statearr_65980_66021[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (23))){
var inst_65908 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_65950__$1 = state_65950;
if(cljs.core.truth_(inst_65908)){
var statearr_65981_66022 = state_65950__$1;
(statearr_65981_66022[(1)] = (25));

} else {
var statearr_65982_66023 = state_65950__$1;
(statearr_65982_66023[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (35))){
var state_65950__$1 = state_65950;
var statearr_65983_66024 = state_65950__$1;
(statearr_65983_66024[(2)] = null);

(statearr_65983_66024[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (19))){
var inst_65903 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_65950__$1 = state_65950;
if(cljs.core.truth_(inst_65903)){
var statearr_65984_66025 = state_65950__$1;
(statearr_65984_66025[(1)] = (22));

} else {
var statearr_65985_66026 = state_65950__$1;
(statearr_65985_66026[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (11))){
var inst_65874 = (state_65950[(2)]);
var state_65950__$1 = state_65950;
var statearr_65986_66027 = state_65950__$1;
(statearr_65986_66027[(2)] = inst_65874);

(statearr_65986_66027[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (9))){
var inst_65876 = figwheel.client.heads_up.clear.call(null);
var state_65950__$1 = state_65950;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65950__$1,(12),inst_65876);
} else {
if((state_val_65951 === (5))){
var inst_65867 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_65950__$1 = state_65950;
var statearr_65987_66028 = state_65950__$1;
(statearr_65987_66028[(2)] = inst_65867);

(statearr_65987_66028[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (14))){
var inst_65894 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_65950__$1 = state_65950;
if(cljs.core.truth_(inst_65894)){
var statearr_65988_66029 = state_65950__$1;
(statearr_65988_66029[(1)] = (18));

} else {
var statearr_65989_66030 = state_65950__$1;
(statearr_65989_66030[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (26))){
var inst_65920 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_65950__$1 = state_65950;
if(cljs.core.truth_(inst_65920)){
var statearr_65990_66031 = state_65950__$1;
(statearr_65990_66031[(1)] = (30));

} else {
var statearr_65991_66032 = state_65950__$1;
(statearr_65991_66032[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (16))){
var inst_65886 = (state_65950[(2)]);
var inst_65887 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_65888 = figwheel.client.heads_up.display_exception.call(null,inst_65887);
var state_65950__$1 = (function (){var statearr_65992 = state_65950;
(statearr_65992[(13)] = inst_65886);

return statearr_65992;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65950__$1,(17),inst_65888);
} else {
if((state_val_65951 === (30))){
var inst_65922 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_65923 = figwheel.client.heads_up.display_warning.call(null,inst_65922);
var state_65950__$1 = state_65950;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65950__$1,(33),inst_65923);
} else {
if((state_val_65951 === (10))){
var inst_65880 = (state_65950[(2)]);
var state_65950__$1 = state_65950;
var statearr_65993_66033 = state_65950__$1;
(statearr_65993_66033[(2)] = inst_65880);

(statearr_65993_66033[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (18))){
var inst_65896 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_65897 = figwheel.client.heads_up.display_exception.call(null,inst_65896);
var state_65950__$1 = state_65950;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65950__$1,(21),inst_65897);
} else {
if((state_val_65951 === (37))){
var inst_65933 = (state_65950[(2)]);
var state_65950__$1 = state_65950;
var statearr_65994_66034 = state_65950__$1;
(statearr_65994_66034[(2)] = inst_65933);

(statearr_65994_66034[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65951 === (8))){
var inst_65872 = figwheel.client.heads_up.flash_loaded.call(null);
var state_65950__$1 = state_65950;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65950__$1,(11),inst_65872);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__58824__auto__,c__58877__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__58825__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__58825__auto____0 = (function (){
var statearr_65995 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65995[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__58825__auto__);

(statearr_65995[(1)] = (1));

return statearr_65995;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__58825__auto____1 = (function (state_65950){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_65950);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e65996){if((e65996 instanceof Object)){
var ex__58828__auto__ = e65996;
var statearr_65997_66035 = state_65950;
(statearr_65997_66035[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_65950);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e65996;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66036 = state_65950;
state_65950 = G__66036;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__58825__auto__ = function(state_65950){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__58825__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__58825__auto____1.call(this,state_65950);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__58825__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__58825__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto__,msg_hist,msg_names,msg))
})();
var state__58879__auto__ = (function (){var statearr_65998 = f__58878__auto__.call(null);
(statearr_65998[(6)] = c__58877__auto__);

return statearr_65998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto__,msg_hist,msg_names,msg))
);

return c__58877__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__58877__auto___66065 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___66065,ch){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___66065,ch){
return (function (state_66051){
var state_val_66052 = (state_66051[(1)]);
if((state_val_66052 === (1))){
var state_66051__$1 = state_66051;
var statearr_66053_66066 = state_66051__$1;
(statearr_66053_66066[(2)] = null);

(statearr_66053_66066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (2))){
var state_66051__$1 = state_66051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66051__$1,(4),ch);
} else {
if((state_val_66052 === (3))){
var inst_66049 = (state_66051[(2)]);
var state_66051__$1 = state_66051;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66051__$1,inst_66049);
} else {
if((state_val_66052 === (4))){
var inst_66039 = (state_66051[(7)]);
var inst_66039__$1 = (state_66051[(2)]);
var state_66051__$1 = (function (){var statearr_66054 = state_66051;
(statearr_66054[(7)] = inst_66039__$1);

return statearr_66054;
})();
if(cljs.core.truth_(inst_66039__$1)){
var statearr_66055_66067 = state_66051__$1;
(statearr_66055_66067[(1)] = (5));

} else {
var statearr_66056_66068 = state_66051__$1;
(statearr_66056_66068[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (5))){
var inst_66039 = (state_66051[(7)]);
var inst_66041 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_66039);
var state_66051__$1 = state_66051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66051__$1,(8),inst_66041);
} else {
if((state_val_66052 === (6))){
var state_66051__$1 = state_66051;
var statearr_66057_66069 = state_66051__$1;
(statearr_66057_66069[(2)] = null);

(statearr_66057_66069[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (7))){
var inst_66047 = (state_66051[(2)]);
var state_66051__$1 = state_66051;
var statearr_66058_66070 = state_66051__$1;
(statearr_66058_66070[(2)] = inst_66047);

(statearr_66058_66070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66052 === (8))){
var inst_66043 = (state_66051[(2)]);
var state_66051__$1 = (function (){var statearr_66059 = state_66051;
(statearr_66059[(8)] = inst_66043);

return statearr_66059;
})();
var statearr_66060_66071 = state_66051__$1;
(statearr_66060_66071[(2)] = null);

(statearr_66060_66071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__58877__auto___66065,ch))
;
return ((function (switch__58824__auto__,c__58877__auto___66065,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__58825__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__58825__auto____0 = (function (){
var statearr_66061 = [null,null,null,null,null,null,null,null,null];
(statearr_66061[(0)] = figwheel$client$heads_up_plugin_$_state_machine__58825__auto__);

(statearr_66061[(1)] = (1));

return statearr_66061;
});
var figwheel$client$heads_up_plugin_$_state_machine__58825__auto____1 = (function (state_66051){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_66051);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e66062){if((e66062 instanceof Object)){
var ex__58828__auto__ = e66062;
var statearr_66063_66072 = state_66051;
(statearr_66063_66072[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66051);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66062;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66073 = state_66051;
state_66051 = G__66073;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__58825__auto__ = function(state_66051){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__58825__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__58825__auto____1.call(this,state_66051);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__58825__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__58825__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___66065,ch))
})();
var state__58879__auto__ = (function (){var statearr_66064 = f__58878__auto__.call(null);
(statearr_66064[(6)] = c__58877__auto___66065);

return statearr_66064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___66065,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__58877__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto__){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto__){
return (function (state_66079){
var state_val_66080 = (state_66079[(1)]);
if((state_val_66080 === (1))){
var inst_66074 = cljs.core.async.timeout.call(null,(3000));
var state_66079__$1 = state_66079;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66079__$1,(2),inst_66074);
} else {
if((state_val_66080 === (2))){
var inst_66076 = (state_66079[(2)]);
var inst_66077 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_66079__$1 = (function (){var statearr_66081 = state_66079;
(statearr_66081[(7)] = inst_66076);

return statearr_66081;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66079__$1,inst_66077);
} else {
return null;
}
}
});})(c__58877__auto__))
;
return ((function (switch__58824__auto__,c__58877__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__58825__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__58825__auto____0 = (function (){
var statearr_66082 = [null,null,null,null,null,null,null,null];
(statearr_66082[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__58825__auto__);

(statearr_66082[(1)] = (1));

return statearr_66082;
});
var figwheel$client$enforce_project_plugin_$_state_machine__58825__auto____1 = (function (state_66079){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_66079);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e66083){if((e66083 instanceof Object)){
var ex__58828__auto__ = e66083;
var statearr_66084_66086 = state_66079;
(statearr_66084_66086[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66079);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66083;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66087 = state_66079;
state_66079 = G__66087;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__58825__auto__ = function(state_66079){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__58825__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__58825__auto____1.call(this,state_66079);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__58825__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__58825__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto__))
})();
var state__58879__auto__ = (function (){var statearr_66085 = f__58878__auto__.call(null);
(statearr_66085[(6)] = c__58877__auto__);

return statearr_66085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto__))
);

return c__58877__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__58877__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto__,figwheel_version,temp__4657__auto__){
return (function (state_66094){
var state_val_66095 = (state_66094[(1)]);
if((state_val_66095 === (1))){
var inst_66088 = cljs.core.async.timeout.call(null,(2000));
var state_66094__$1 = state_66094;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66094__$1,(2),inst_66088);
} else {
if((state_val_66095 === (2))){
var inst_66090 = (state_66094[(2)]);
var inst_66091 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_66092 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_66091);
var state_66094__$1 = (function (){var statearr_66096 = state_66094;
(statearr_66096[(7)] = inst_66090);

return statearr_66096;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66094__$1,inst_66092);
} else {
return null;
}
}
});})(c__58877__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__58824__auto__,c__58877__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__58825__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__58825__auto____0 = (function (){
var statearr_66097 = [null,null,null,null,null,null,null,null];
(statearr_66097[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__58825__auto__);

(statearr_66097[(1)] = (1));

return statearr_66097;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__58825__auto____1 = (function (state_66094){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_66094);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e66098){if((e66098 instanceof Object)){
var ex__58828__auto__ = e66098;
var statearr_66099_66101 = state_66094;
(statearr_66099_66101[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66094);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66098;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66102 = state_66094;
state_66094 = G__66102;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__58825__auto__ = function(state_66094){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__58825__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__58825__auto____1.call(this,state_66094);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__58825__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__58825__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto__,figwheel_version,temp__4657__auto__))
})();
var state__58879__auto__ = (function (){var statearr_66100 = f__58878__auto__.call(null);
(statearr_66100[(6)] = c__58877__auto__);

return statearr_66100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto__,figwheel_version,temp__4657__auto__))
);

return c__58877__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__66103){
var map__66104 = p__66103;
var map__66104__$1 = ((((!((map__66104 == null)))?((((map__66104.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66104.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66104):map__66104);
var file = cljs.core.get.call(null,map__66104__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__66104__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__66104__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__66106 = "";
var G__66106__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__66106),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__66106);
var G__66106__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__66106__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__66106__$1);
if(cljs.core.truth_((function (){var and__54173__auto__ = line;
if(cljs.core.truth_(and__54173__auto__)){
return column;
} else {
return and__54173__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__66106__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__66106__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__66107){
var map__66108 = p__66107;
var map__66108__$1 = ((((!((map__66108 == null)))?((((map__66108.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66108.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66108):map__66108);
var ed = map__66108__$1;
var formatted_exception = cljs.core.get.call(null,map__66108__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__66108__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__66108__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__66110_66114 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__66111_66115 = null;
var count__66112_66116 = (0);
var i__66113_66117 = (0);
while(true){
if((i__66113_66117 < count__66112_66116)){
var msg_66118 = cljs.core._nth.call(null,chunk__66111_66115,i__66113_66117);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_66118);

var G__66119 = seq__66110_66114;
var G__66120 = chunk__66111_66115;
var G__66121 = count__66112_66116;
var G__66122 = (i__66113_66117 + (1));
seq__66110_66114 = G__66119;
chunk__66111_66115 = G__66120;
count__66112_66116 = G__66121;
i__66113_66117 = G__66122;
continue;
} else {
var temp__4657__auto___66123 = cljs.core.seq.call(null,seq__66110_66114);
if(temp__4657__auto___66123){
var seq__66110_66124__$1 = temp__4657__auto___66123;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__66110_66124__$1)){
var c__55024__auto___66125 = cljs.core.chunk_first.call(null,seq__66110_66124__$1);
var G__66126 = cljs.core.chunk_rest.call(null,seq__66110_66124__$1);
var G__66127 = c__55024__auto___66125;
var G__66128 = cljs.core.count.call(null,c__55024__auto___66125);
var G__66129 = (0);
seq__66110_66114 = G__66126;
chunk__66111_66115 = G__66127;
count__66112_66116 = G__66128;
i__66113_66117 = G__66129;
continue;
} else {
var msg_66130 = cljs.core.first.call(null,seq__66110_66124__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_66130);

var G__66131 = cljs.core.next.call(null,seq__66110_66124__$1);
var G__66132 = null;
var G__66133 = (0);
var G__66134 = (0);
seq__66110_66114 = G__66131;
chunk__66111_66115 = G__66132;
count__66112_66116 = G__66133;
i__66113_66117 = G__66134;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__66135){
var map__66136 = p__66135;
var map__66136__$1 = ((((!((map__66136 == null)))?((((map__66136.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66136.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66136):map__66136);
var w = map__66136__$1;
var message = cljs.core.get.call(null,map__66136__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/out/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__54173__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__54173__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__54173__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_json_message_watch = (function figwheel$client$add_json_message_watch(key,callback){
return figwheel.client.add_message_watch.call(null,key,cljs.core.comp.call(null,callback,cljs.core.clj__GT_js));
});
goog.exportSymbol('figwheel.client.add_json_message_watch', figwheel.client.add_json_message_watch);
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__66138 = cljs.core.seq.call(null,plugins);
var chunk__66139 = null;
var count__66140 = (0);
var i__66141 = (0);
while(true){
if((i__66141 < count__66140)){
var vec__66142 = cljs.core._nth.call(null,chunk__66139,i__66141);
var k = cljs.core.nth.call(null,vec__66142,(0),null);
var plugin = cljs.core.nth.call(null,vec__66142,(1),null);
if(cljs.core.truth_(plugin)){
var pl_66148 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__66138,chunk__66139,count__66140,i__66141,pl_66148,vec__66142,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_66148.call(null,msg_hist);
});})(seq__66138,chunk__66139,count__66140,i__66141,pl_66148,vec__66142,k,plugin))
);
} else {
}

var G__66149 = seq__66138;
var G__66150 = chunk__66139;
var G__66151 = count__66140;
var G__66152 = (i__66141 + (1));
seq__66138 = G__66149;
chunk__66139 = G__66150;
count__66140 = G__66151;
i__66141 = G__66152;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__66138);
if(temp__4657__auto__){
var seq__66138__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__66138__$1)){
var c__55024__auto__ = cljs.core.chunk_first.call(null,seq__66138__$1);
var G__66153 = cljs.core.chunk_rest.call(null,seq__66138__$1);
var G__66154 = c__55024__auto__;
var G__66155 = cljs.core.count.call(null,c__55024__auto__);
var G__66156 = (0);
seq__66138 = G__66153;
chunk__66139 = G__66154;
count__66140 = G__66155;
i__66141 = G__66156;
continue;
} else {
var vec__66145 = cljs.core.first.call(null,seq__66138__$1);
var k = cljs.core.nth.call(null,vec__66145,(0),null);
var plugin = cljs.core.nth.call(null,vec__66145,(1),null);
if(cljs.core.truth_(plugin)){
var pl_66157 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__66138,chunk__66139,count__66140,i__66141,pl_66157,vec__66145,k,plugin,seq__66138__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_66157.call(null,msg_hist);
});})(seq__66138,chunk__66139,count__66140,i__66141,pl_66157,vec__66145,k,plugin,seq__66138__$1,temp__4657__auto__))
);
} else {
}

var G__66158 = cljs.core.next.call(null,seq__66138__$1);
var G__66159 = null;
var G__66160 = (0);
var G__66161 = (0);
seq__66138 = G__66158;
chunk__66139 = G__66159;
count__66140 = G__66160;
i__66141 = G__66161;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__66163 = arguments.length;
switch (G__66163) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__66164_66169 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__66165_66170 = null;
var count__66166_66171 = (0);
var i__66167_66172 = (0);
while(true){
if((i__66167_66172 < count__66166_66171)){
var msg_66173 = cljs.core._nth.call(null,chunk__66165_66170,i__66167_66172);
figwheel.client.socket.handle_incoming_message.call(null,msg_66173);

var G__66174 = seq__66164_66169;
var G__66175 = chunk__66165_66170;
var G__66176 = count__66166_66171;
var G__66177 = (i__66167_66172 + (1));
seq__66164_66169 = G__66174;
chunk__66165_66170 = G__66175;
count__66166_66171 = G__66176;
i__66167_66172 = G__66177;
continue;
} else {
var temp__4657__auto___66178 = cljs.core.seq.call(null,seq__66164_66169);
if(temp__4657__auto___66178){
var seq__66164_66179__$1 = temp__4657__auto___66178;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__66164_66179__$1)){
var c__55024__auto___66180 = cljs.core.chunk_first.call(null,seq__66164_66179__$1);
var G__66181 = cljs.core.chunk_rest.call(null,seq__66164_66179__$1);
var G__66182 = c__55024__auto___66180;
var G__66183 = cljs.core.count.call(null,c__55024__auto___66180);
var G__66184 = (0);
seq__66164_66169 = G__66181;
chunk__66165_66170 = G__66182;
count__66166_66171 = G__66183;
i__66167_66172 = G__66184;
continue;
} else {
var msg_66185 = cljs.core.first.call(null,seq__66164_66179__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_66185);

var G__66186 = cljs.core.next.call(null,seq__66164_66179__$1);
var G__66187 = null;
var G__66188 = (0);
var G__66189 = (0);
seq__66164_66169 = G__66186;
chunk__66165_66170 = G__66187;
count__66166_66171 = G__66188;
i__66167_66172 = G__66189;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__55361__auto__ = [];
var len__55354__auto___66194 = arguments.length;
var i__55355__auto___66195 = (0);
while(true){
if((i__55355__auto___66195 < len__55354__auto___66194)){
args__55361__auto__.push((arguments[i__55355__auto___66195]));

var G__66196 = (i__55355__auto___66195 + (1));
i__55355__auto___66195 = G__66196;
continue;
} else {
}
break;
}

var argseq__55362__auto__ = ((((0) < args__55361__auto__.length))?(new cljs.core.IndexedSeq(args__55361__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__55362__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__66191){
var map__66192 = p__66191;
var map__66192__$1 = ((((!((map__66192 == null)))?((((map__66192.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66192.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66192):map__66192);
var opts = map__66192__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq66190){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66190));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e66197){if((e66197 instanceof Error)){
var e = e66197;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e66197;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__66198){
var map__66199 = p__66198;
var map__66199__$1 = ((((!((map__66199 == null)))?((((map__66199.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66199.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66199):map__66199);
var msg_name = cljs.core.get.call(null,map__66199__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1518787492746
