(ns leiningen.give-me-my-css
  (:require [clojure.java.io :as io])
  (:import java.lang.ProcessBuilder))

(defn sass [{:keys [input output mode style source-map no-cache]
             :or {input "resources/public/scss"
                  output "resources/public/css"
                  mode :once
                  style :nested
                  source-map true
                  no-cache false}
             :as args}]
  (println (format "building sass/scss with options: %s" (pr-str {:input input
                                                                  :output output
                                                                  :mode mode
                                                                  :style style
                                                                  :source-map source-map
                                                                  :no-cache no-cache})))
  (let [dir (.getAbsolutePath (io/file ""))
        command-arg (case mode
                      "watch" "--watch"
                      "--update")
        args (->> ["docker" "run" "--rm"
                   "-v" (format "%s:/app" dir)
                   "ubuntudesign/sass" "sass" command-arg
                   (format "/app/%s:/app/%s" input output)
                   "--style" (if style
                               (name style)
                               "nested")
                   (when source-map
                     "--sourcemap")
                   (when no-cache
                     "-C")
                   (when (= "force" mode)
                     "-f")]
                  (filter identity))
        pb (ProcessBuilder. args)
        _ (.inheritIO pb)
        proc (.start pb)
        _ (.waitFor proc)
        exit-code (.exitValue proc)]
    (println "build finished")
    (when (pos? exit-code)
      (System/exit exit-code))))

(defn give-me-my-css
  [{:keys [give-me-my-css]} & [mode]]
  (if (= "help" mode)
    (do
      (println "Usage:")
      (println "lein give-me-my-css -- to compile sass once")
      (println "lein give-me-my-css once -- to compile sass once")
      (println "lein give-me-my-css force -- to force sass recompilation")
      (println "lein give-me-my-css watch -- to start watcher")
      (println "lein give-me-my-css help -- to show this output"))
    (sass (cond-> give-me-my-css
            mode (assoc :mode mode)))))
