# lein-give-me-my-css

Simpliest way to build sass in Leiningen project (with docker).

[![Clojars Project](https://img.shields.io/clojars/v/rocks.clj/lein-give-me-my-css.svg)](https://clojars.org/rocks.clj/lein-give-me-my-css)

## Why

Current situation in sass field.

There are numerous libraries for building `sass` already.
All of them depend either on `cli tool` (ruby sass or sassc), `libsass` or `sass.js`.

Libraries that are truly independent:

- [yogthos/lein-sass](https://github.com/yogthos/lein-sass)

it includes `sass.js` script and spins up `nashorn` to compile your files.
it's very nice plugin, but lacks such features as proper `source maps` and `@import` support.

- [sass4clj](https://github.com/Deraen/sass4clj)

another attempt to get rid of external dependencies.
it includes native libraries for sass and call them through JNA.
it works fine, has good errors output, but also has problem with sources maps.
it generates some redundant sources that do not even exist it source tree.
it causes browser (checked of firefox) to fail loading scss files

This is where `lein-give-me-my-css` come to the stage.

I decided that the best way is to use the original tool (ruby tool),
but wrap it in docker so I wouldn't have to ~~summon devils~~ install any gems or native libraries.
`lein-give-me-my-css` designed to include default configuration that makes sense for the most project.
and provides same api as `lein-sass` to simplify migration.
Basically you can just add it to your plugins and you're ready to go.
All at the cost of having `docker` on your machine.

## Prerequisites

This plugin requires `docker` to be installed and accessible for current user.

## Usage

Put `[rocks.clj/lein-give-me-my-css "0.1.0-SNAPSHOT"]` into the `:plugins` vector of your `project.clj`.

Add plugin configration to your `project.clj`

```clojure
:give-me-my-css {:input "resources/public/scss", ;; input dir
                 :output "resources/public/css", ;; output dir
                 :style :nested, ;; style (Can be :nested (default), :compact, :compressed, or :expanded)
                 :source-map true, ;; generate source maps
                 :no-cache false} ;; use caching
```

Above values are default, and you don't have to provide it if you're okay with it.

To build sass once

```shell
lein give-me-my-css
```

To start watcher

```shell
lein give-me-my-css watch
```

To show help

```shell
lein give-me-my-css help
```

## Future features

- compass
- autoprefixer
- less? (thinking about making it `can do all` plugin)

## License

Copyright © 2018 FIXME

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
