// Compiled by ClojureScript 1.9.908 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__54185__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__54185__auto__){
return or__54185__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__54185__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__54185__auto__)){
return or__54185__auto__;
} else {
var or__54185__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__54185__auto____$1)){
return or__54185__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__63964_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__63964_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__63965 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__63966 = null;
var count__63967 = (0);
var i__63968 = (0);
while(true){
if((i__63968 < count__63967)){
var n = cljs.core._nth.call(null,chunk__63966,i__63968);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__63969 = seq__63965;
var G__63970 = chunk__63966;
var G__63971 = count__63967;
var G__63972 = (i__63968 + (1));
seq__63965 = G__63969;
chunk__63966 = G__63970;
count__63967 = G__63971;
i__63968 = G__63972;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__63965);
if(temp__4657__auto__){
var seq__63965__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__63965__$1)){
var c__55024__auto__ = cljs.core.chunk_first.call(null,seq__63965__$1);
var G__63973 = cljs.core.chunk_rest.call(null,seq__63965__$1);
var G__63974 = c__55024__auto__;
var G__63975 = cljs.core.count.call(null,c__55024__auto__);
var G__63976 = (0);
seq__63965 = G__63973;
chunk__63966 = G__63974;
count__63967 = G__63975;
i__63968 = G__63976;
continue;
} else {
var n = cljs.core.first.call(null,seq__63965__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__63977 = cljs.core.next.call(null,seq__63965__$1);
var G__63978 = null;
var G__63979 = (0);
var G__63980 = (0);
seq__63965 = G__63977;
chunk__63966 = G__63978;
count__63967 = G__63979;
i__63968 = G__63980;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.in_upper_level_QMARK_ = (function figwheel$client$file_reloading$in_upper_level_QMARK_(topo_state,current_depth,dep){
return cljs.core.some.call(null,(function (p__63981){
var vec__63982 = p__63981;
var _ = cljs.core.nth.call(null,vec__63982,(0),null);
var v = cljs.core.nth.call(null,vec__63982,(1),null);
var and__54173__auto__ = v;
if(cljs.core.truth_(and__54173__auto__)){
return v.call(null,dep);
} else {
return and__54173__auto__;
}
}),cljs.core.filter.call(null,(function (p__63985){
var vec__63986 = p__63985;
var k = cljs.core.nth.call(null,vec__63986,(0),null);
var v = cljs.core.nth.call(null,vec__63986,(1),null);
return (k > current_depth);
}),topo_state));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__63998_64006 = cljs.core.seq.call(null,deps);
var chunk__63999_64007 = null;
var count__64000_64008 = (0);
var i__64001_64009 = (0);
while(true){
if((i__64001_64009 < count__64000_64008)){
var dep_64010 = cljs.core._nth.call(null,chunk__63999_64007,i__64001_64009);
if(cljs.core.truth_((function (){var and__54173__auto__ = dep_64010;
if(cljs.core.truth_(and__54173__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_64010));
} else {
return and__54173__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_64010,(depth + (1)),state);
} else {
}

var G__64011 = seq__63998_64006;
var G__64012 = chunk__63999_64007;
var G__64013 = count__64000_64008;
var G__64014 = (i__64001_64009 + (1));
seq__63998_64006 = G__64011;
chunk__63999_64007 = G__64012;
count__64000_64008 = G__64013;
i__64001_64009 = G__64014;
continue;
} else {
var temp__4657__auto___64015 = cljs.core.seq.call(null,seq__63998_64006);
if(temp__4657__auto___64015){
var seq__63998_64016__$1 = temp__4657__auto___64015;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__63998_64016__$1)){
var c__55024__auto___64017 = cljs.core.chunk_first.call(null,seq__63998_64016__$1);
var G__64018 = cljs.core.chunk_rest.call(null,seq__63998_64016__$1);
var G__64019 = c__55024__auto___64017;
var G__64020 = cljs.core.count.call(null,c__55024__auto___64017);
var G__64021 = (0);
seq__63998_64006 = G__64018;
chunk__63999_64007 = G__64019;
count__64000_64008 = G__64020;
i__64001_64009 = G__64021;
continue;
} else {
var dep_64022 = cljs.core.first.call(null,seq__63998_64016__$1);
if(cljs.core.truth_((function (){var and__54173__auto__ = dep_64022;
if(cljs.core.truth_(and__54173__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_64022));
} else {
return and__54173__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_64022,(depth + (1)),state);
} else {
}

var G__64023 = cljs.core.next.call(null,seq__63998_64016__$1);
var G__64024 = null;
var G__64025 = (0);
var G__64026 = (0);
seq__63998_64006 = G__64023;
chunk__63999_64007 = G__64024;
count__64000_64008 = G__64025;
i__64001_64009 = G__64026;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__64002){
var vec__64003 = p__64002;
var seq__64004 = cljs.core.seq.call(null,vec__64003);
var first__64005 = cljs.core.first.call(null,seq__64004);
var seq__64004__$1 = cljs.core.next.call(null,seq__64004);
var x = first__64005;
var xs = seq__64004__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__64003,seq__64004,first__64005,seq__64004__$1,x,xs,get_deps__$1){
return (function (p1__63989_SHARP_){
return clojure.set.difference.call(null,p1__63989_SHARP_,x);
});})(vec__64003,seq__64004,first__64005,seq__64004__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__64027 = cljs.core.seq.call(null,provides);
var chunk__64028 = null;
var count__64029 = (0);
var i__64030 = (0);
while(true){
if((i__64030 < count__64029)){
var prov = cljs.core._nth.call(null,chunk__64028,i__64030);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__64031_64039 = cljs.core.seq.call(null,requires);
var chunk__64032_64040 = null;
var count__64033_64041 = (0);
var i__64034_64042 = (0);
while(true){
if((i__64034_64042 < count__64033_64041)){
var req_64043 = cljs.core._nth.call(null,chunk__64032_64040,i__64034_64042);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_64043,prov);

var G__64044 = seq__64031_64039;
var G__64045 = chunk__64032_64040;
var G__64046 = count__64033_64041;
var G__64047 = (i__64034_64042 + (1));
seq__64031_64039 = G__64044;
chunk__64032_64040 = G__64045;
count__64033_64041 = G__64046;
i__64034_64042 = G__64047;
continue;
} else {
var temp__4657__auto___64048 = cljs.core.seq.call(null,seq__64031_64039);
if(temp__4657__auto___64048){
var seq__64031_64049__$1 = temp__4657__auto___64048;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__64031_64049__$1)){
var c__55024__auto___64050 = cljs.core.chunk_first.call(null,seq__64031_64049__$1);
var G__64051 = cljs.core.chunk_rest.call(null,seq__64031_64049__$1);
var G__64052 = c__55024__auto___64050;
var G__64053 = cljs.core.count.call(null,c__55024__auto___64050);
var G__64054 = (0);
seq__64031_64039 = G__64051;
chunk__64032_64040 = G__64052;
count__64033_64041 = G__64053;
i__64034_64042 = G__64054;
continue;
} else {
var req_64055 = cljs.core.first.call(null,seq__64031_64049__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_64055,prov);

var G__64056 = cljs.core.next.call(null,seq__64031_64049__$1);
var G__64057 = null;
var G__64058 = (0);
var G__64059 = (0);
seq__64031_64039 = G__64056;
chunk__64032_64040 = G__64057;
count__64033_64041 = G__64058;
i__64034_64042 = G__64059;
continue;
}
} else {
}
}
break;
}

var G__64060 = seq__64027;
var G__64061 = chunk__64028;
var G__64062 = count__64029;
var G__64063 = (i__64030 + (1));
seq__64027 = G__64060;
chunk__64028 = G__64061;
count__64029 = G__64062;
i__64030 = G__64063;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__64027);
if(temp__4657__auto__){
var seq__64027__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__64027__$1)){
var c__55024__auto__ = cljs.core.chunk_first.call(null,seq__64027__$1);
var G__64064 = cljs.core.chunk_rest.call(null,seq__64027__$1);
var G__64065 = c__55024__auto__;
var G__64066 = cljs.core.count.call(null,c__55024__auto__);
var G__64067 = (0);
seq__64027 = G__64064;
chunk__64028 = G__64065;
count__64029 = G__64066;
i__64030 = G__64067;
continue;
} else {
var prov = cljs.core.first.call(null,seq__64027__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__64035_64068 = cljs.core.seq.call(null,requires);
var chunk__64036_64069 = null;
var count__64037_64070 = (0);
var i__64038_64071 = (0);
while(true){
if((i__64038_64071 < count__64037_64070)){
var req_64072 = cljs.core._nth.call(null,chunk__64036_64069,i__64038_64071);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_64072,prov);

var G__64073 = seq__64035_64068;
var G__64074 = chunk__64036_64069;
var G__64075 = count__64037_64070;
var G__64076 = (i__64038_64071 + (1));
seq__64035_64068 = G__64073;
chunk__64036_64069 = G__64074;
count__64037_64070 = G__64075;
i__64038_64071 = G__64076;
continue;
} else {
var temp__4657__auto___64077__$1 = cljs.core.seq.call(null,seq__64035_64068);
if(temp__4657__auto___64077__$1){
var seq__64035_64078__$1 = temp__4657__auto___64077__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__64035_64078__$1)){
var c__55024__auto___64079 = cljs.core.chunk_first.call(null,seq__64035_64078__$1);
var G__64080 = cljs.core.chunk_rest.call(null,seq__64035_64078__$1);
var G__64081 = c__55024__auto___64079;
var G__64082 = cljs.core.count.call(null,c__55024__auto___64079);
var G__64083 = (0);
seq__64035_64068 = G__64080;
chunk__64036_64069 = G__64081;
count__64037_64070 = G__64082;
i__64038_64071 = G__64083;
continue;
} else {
var req_64084 = cljs.core.first.call(null,seq__64035_64078__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_64084,prov);

var G__64085 = cljs.core.next.call(null,seq__64035_64078__$1);
var G__64086 = null;
var G__64087 = (0);
var G__64088 = (0);
seq__64035_64068 = G__64085;
chunk__64036_64069 = G__64086;
count__64037_64070 = G__64087;
i__64038_64071 = G__64088;
continue;
}
} else {
}
}
break;
}

var G__64089 = cljs.core.next.call(null,seq__64027__$1);
var G__64090 = null;
var G__64091 = (0);
var G__64092 = (0);
seq__64027 = G__64089;
chunk__64028 = G__64090;
count__64029 = G__64091;
i__64030 = G__64092;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__64093_64097 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__64094_64098 = null;
var count__64095_64099 = (0);
var i__64096_64100 = (0);
while(true){
if((i__64096_64100 < count__64095_64099)){
var ns_64101 = cljs.core._nth.call(null,chunk__64094_64098,i__64096_64100);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_64101);

var G__64102 = seq__64093_64097;
var G__64103 = chunk__64094_64098;
var G__64104 = count__64095_64099;
var G__64105 = (i__64096_64100 + (1));
seq__64093_64097 = G__64102;
chunk__64094_64098 = G__64103;
count__64095_64099 = G__64104;
i__64096_64100 = G__64105;
continue;
} else {
var temp__4657__auto___64106 = cljs.core.seq.call(null,seq__64093_64097);
if(temp__4657__auto___64106){
var seq__64093_64107__$1 = temp__4657__auto___64106;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__64093_64107__$1)){
var c__55024__auto___64108 = cljs.core.chunk_first.call(null,seq__64093_64107__$1);
var G__64109 = cljs.core.chunk_rest.call(null,seq__64093_64107__$1);
var G__64110 = c__55024__auto___64108;
var G__64111 = cljs.core.count.call(null,c__55024__auto___64108);
var G__64112 = (0);
seq__64093_64097 = G__64109;
chunk__64094_64098 = G__64110;
count__64095_64099 = G__64111;
i__64096_64100 = G__64112;
continue;
} else {
var ns_64113 = cljs.core.first.call(null,seq__64093_64107__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_64113);

var G__64114 = cljs.core.next.call(null,seq__64093_64107__$1);
var G__64115 = null;
var G__64116 = (0);
var G__64117 = (0);
seq__64093_64097 = G__64114;
chunk__64094_64098 = G__64115;
count__64095_64099 = G__64116;
i__64096_64100 = G__64117;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__54185__auto__ = goog.require__;
if(cljs.core.truth_(or__54185__auto__)){
return or__54185__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__64118__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__64118 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__64119__i = 0, G__64119__a = new Array(arguments.length -  0);
while (G__64119__i < G__64119__a.length) {G__64119__a[G__64119__i] = arguments[G__64119__i + 0]; ++G__64119__i;}
  args = new cljs.core.IndexedSeq(G__64119__a,0,null);
} 
return G__64118__delegate.call(this,args);};
G__64118.cljs$lang$maxFixedArity = 0;
G__64118.cljs$lang$applyTo = (function (arglist__64120){
var args = cljs.core.seq(arglist__64120);
return G__64118__delegate(args);
});
G__64118.cljs$core$IFn$_invoke$arity$variadic = G__64118__delegate;
return G__64118;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__64121_SHARP_,p2__64122_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__64121_SHARP_)].join('')),p2__64122_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__64123_SHARP_,p2__64124_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__64123_SHARP_)].join(''),p2__64124_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__64125 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__64125.addCallback(((function (G__64125){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__64125))
);

G__64125.addErrback(((function (G__64125){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__64125))
);

return G__64125;
});
figwheel.client.file_reloading.write_script_tag_import = figwheel.client.file_reloading.reload_file_in_html_env;
goog.exportSymbol('figwheel.client.file_reloading.write_script_tag_import', figwheel.client.file_reloading.write_script_tag_import);
figwheel.client.file_reloading.worker_import_script = (function figwheel$client$file_reloading$worker_import_script(request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e64126){if((e64126 instanceof Error)){
var e = e64126;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e64126;

}
}})());
});
goog.exportSymbol('figwheel.client.file_reloading.worker_import_script', figwheel.client.file_reloading.worker_import_script);
figwheel.client.file_reloading.create_node_script_import_fn = (function figwheel$client$file_reloading$create_node_script_import_fn(){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e64127){if((e64127 instanceof Error)){
var e = e64127;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e64127;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path))
});
goog.exportSymbol('figwheel.client.file_reloading.create_node_script_import_fn', figwheel.client.file_reloading.create_node_script_import_fn);
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__64128 = cljs.core._EQ_;
var expr__64129 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__64128.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__64129))){
return figwheel.client.file_reloading.create_node_script_import_fn.call(null);
} else {
if(cljs.core.truth_(pred__64128.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__64129))){
return figwheel.client.file_reloading.write_script_tag_import;
} else {
if(cljs.core.truth_(pred__64128.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__64129))){
return figwheel.client.file_reloading.worker_import_script;
} else {
return ((function (pred__64128,expr__64129){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__64128,expr__64129))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__64131,callback){
var map__64132 = p__64131;
var map__64132__$1 = ((((!((map__64132 == null)))?((((map__64132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64132.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64132):map__64132);
var file_msg = map__64132__$1;
var request_url = cljs.core.get.call(null,map__64132__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return (function (){var or__54185__auto__ = goog.object.get(goog.global,"FIGWHEEL_IMPORT_SCRIPT");
if(cljs.core.truth_(or__54185__auto__)){
return or__54185__auto__;
} else {
return figwheel.client.file_reloading.reload_file_STAR_;
}
})().call(null,request_url,((function (map__64132,map__64132__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__64132,map__64132__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__58877__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto__){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto__){
return (function (state_64172){
var state_val_64173 = (state_64172[(1)]);
if((state_val_64173 === (7))){
var inst_64168 = (state_64172[(2)]);
var state_64172__$1 = state_64172;
var statearr_64174_64201 = state_64172__$1;
(statearr_64174_64201[(2)] = inst_64168);

(statearr_64174_64201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (1))){
var state_64172__$1 = state_64172;
var statearr_64175_64202 = state_64172__$1;
(statearr_64175_64202[(2)] = null);

(statearr_64175_64202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (4))){
var inst_64136 = (state_64172[(7)]);
var inst_64136__$1 = (state_64172[(2)]);
var state_64172__$1 = (function (){var statearr_64176 = state_64172;
(statearr_64176[(7)] = inst_64136__$1);

return statearr_64176;
})();
if(cljs.core.truth_(inst_64136__$1)){
var statearr_64177_64203 = state_64172__$1;
(statearr_64177_64203[(1)] = (5));

} else {
var statearr_64178_64204 = state_64172__$1;
(statearr_64178_64204[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (15))){
var inst_64150 = (state_64172[(8)]);
var inst_64153 = (state_64172[(9)]);
var inst_64155 = inst_64153.call(null,inst_64150);
var state_64172__$1 = state_64172;
var statearr_64179_64205 = state_64172__$1;
(statearr_64179_64205[(2)] = inst_64155);

(statearr_64179_64205[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (13))){
var inst_64162 = (state_64172[(2)]);
var state_64172__$1 = state_64172;
var statearr_64180_64206 = state_64172__$1;
(statearr_64180_64206[(2)] = inst_64162);

(statearr_64180_64206[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (6))){
var state_64172__$1 = state_64172;
var statearr_64181_64207 = state_64172__$1;
(statearr_64181_64207[(2)] = null);

(statearr_64181_64207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (17))){
var inst_64159 = (state_64172[(2)]);
var state_64172__$1 = state_64172;
var statearr_64182_64208 = state_64172__$1;
(statearr_64182_64208[(2)] = inst_64159);

(statearr_64182_64208[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (3))){
var inst_64170 = (state_64172[(2)]);
var state_64172__$1 = state_64172;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64172__$1,inst_64170);
} else {
if((state_val_64173 === (12))){
var state_64172__$1 = state_64172;
var statearr_64183_64209 = state_64172__$1;
(statearr_64183_64209[(2)] = null);

(statearr_64183_64209[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (2))){
var state_64172__$1 = state_64172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64172__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_64173 === (11))){
var inst_64141 = (state_64172[(10)]);
var inst_64148 = figwheel.client.file_reloading.blocking_load.call(null,inst_64141);
var state_64172__$1 = state_64172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64172__$1,(14),inst_64148);
} else {
if((state_val_64173 === (9))){
var inst_64141 = (state_64172[(10)]);
var state_64172__$1 = state_64172;
if(cljs.core.truth_(inst_64141)){
var statearr_64184_64210 = state_64172__$1;
(statearr_64184_64210[(1)] = (11));

} else {
var statearr_64185_64211 = state_64172__$1;
(statearr_64185_64211[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (5))){
var inst_64142 = (state_64172[(11)]);
var inst_64136 = (state_64172[(7)]);
var inst_64141 = cljs.core.nth.call(null,inst_64136,(0),null);
var inst_64142__$1 = cljs.core.nth.call(null,inst_64136,(1),null);
var state_64172__$1 = (function (){var statearr_64186 = state_64172;
(statearr_64186[(11)] = inst_64142__$1);

(statearr_64186[(10)] = inst_64141);

return statearr_64186;
})();
if(cljs.core.truth_(inst_64142__$1)){
var statearr_64187_64212 = state_64172__$1;
(statearr_64187_64212[(1)] = (8));

} else {
var statearr_64188_64213 = state_64172__$1;
(statearr_64188_64213[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (14))){
var inst_64153 = (state_64172[(9)]);
var inst_64141 = (state_64172[(10)]);
var inst_64150 = (state_64172[(2)]);
var inst_64151 = console.log("Loading!",inst_64141);
var inst_64152 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_64153__$1 = cljs.core.get.call(null,inst_64152,inst_64141);
var state_64172__$1 = (function (){var statearr_64189 = state_64172;
(statearr_64189[(12)] = inst_64151);

(statearr_64189[(8)] = inst_64150);

(statearr_64189[(9)] = inst_64153__$1);

return statearr_64189;
})();
if(cljs.core.truth_(inst_64153__$1)){
var statearr_64190_64214 = state_64172__$1;
(statearr_64190_64214[(1)] = (15));

} else {
var statearr_64191_64215 = state_64172__$1;
(statearr_64191_64215[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (16))){
var inst_64150 = (state_64172[(8)]);
var inst_64157 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_64150);
var state_64172__$1 = state_64172;
var statearr_64192_64216 = state_64172__$1;
(statearr_64192_64216[(2)] = inst_64157);

(statearr_64192_64216[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (10))){
var inst_64164 = (state_64172[(2)]);
var state_64172__$1 = (function (){var statearr_64193 = state_64172;
(statearr_64193[(13)] = inst_64164);

return statearr_64193;
})();
var statearr_64194_64217 = state_64172__$1;
(statearr_64194_64217[(2)] = null);

(statearr_64194_64217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64173 === (8))){
var inst_64142 = (state_64172[(11)]);
var inst_64144 = console.log("Evaling!",inst_64142);
var inst_64145 = eval(inst_64142);
var state_64172__$1 = (function (){var statearr_64195 = state_64172;
(statearr_64195[(14)] = inst_64144);

return statearr_64195;
})();
var statearr_64196_64218 = state_64172__$1;
(statearr_64196_64218[(2)] = inst_64145);

(statearr_64196_64218[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto__))
;
return ((function (switch__58824__auto__,c__58877__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__58825__auto__ = null;
var figwheel$client$file_reloading$state_machine__58825__auto____0 = (function (){
var statearr_64197 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64197[(0)] = figwheel$client$file_reloading$state_machine__58825__auto__);

(statearr_64197[(1)] = (1));

return statearr_64197;
});
var figwheel$client$file_reloading$state_machine__58825__auto____1 = (function (state_64172){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_64172);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e64198){if((e64198 instanceof Object)){
var ex__58828__auto__ = e64198;
var statearr_64199_64219 = state_64172;
(statearr_64199_64219[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64172);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64198;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64220 = state_64172;
state_64172 = G__64220;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__58825__auto__ = function(state_64172){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__58825__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__58825__auto____1.call(this,state_64172);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__58825__auto____0;
figwheel$client$file_reloading$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__58825__auto____1;
return figwheel$client$file_reloading$state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto__))
})();
var state__58879__auto__ = (function (){var statearr_64200 = f__58878__auto__.call(null);
(statearr_64200[(6)] = c__58877__auto__);

return statearr_64200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto__))
);

return c__58877__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(var_args){
var G__64222 = arguments.length;
switch (G__64222) {
case 1:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1 = (function (url){
return figwheel.client.file_reloading.queued_file_reload.call(null,url,null);
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2 = (function (url,opt_source_text){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,opt_source_text], null));
});

figwheel.client.file_reloading.queued_file_reload.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__64224,callback){
var map__64225 = p__64224;
var map__64225__$1 = ((((!((map__64225 == null)))?((((map__64225.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64225.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64225):map__64225);
var file_msg = map__64225__$1;
var namespace = cljs.core.get.call(null,map__64225__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__64225,map__64225__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__64225,map__64225__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__64227){
var map__64228 = p__64227;
var map__64228__$1 = ((((!((map__64228 == null)))?((((map__64228.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64228.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64228):map__64228);
var file_msg = map__64228__$1;
var namespace = cljs.core.get.call(null,map__64228__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__64230){
var map__64231 = p__64230;
var map__64231__$1 = ((((!((map__64231 == null)))?((((map__64231.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64231.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64231):map__64231);
var file_msg = map__64231__$1;
var namespace = cljs.core.get.call(null,map__64231__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__54173__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__54173__auto__){
var or__54185__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__54185__auto__)){
return or__54185__auto__;
} else {
var or__54185__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__54185__auto____$1)){
return or__54185__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__54173__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__64233,callback){
var map__64234 = p__64233;
var map__64234__$1 = ((((!((map__64234 == null)))?((((map__64234.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64234.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64234):map__64234);
var file_msg = map__64234__$1;
var request_url = cljs.core.get.call(null,map__64234__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__64234__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__58877__auto___64284 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___64284,out){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___64284,out){
return (function (state_64269){
var state_val_64270 = (state_64269[(1)]);
if((state_val_64270 === (1))){
var inst_64243 = cljs.core.seq.call(null,files);
var inst_64244 = cljs.core.first.call(null,inst_64243);
var inst_64245 = cljs.core.next.call(null,inst_64243);
var inst_64246 = files;
var state_64269__$1 = (function (){var statearr_64271 = state_64269;
(statearr_64271[(7)] = inst_64245);

(statearr_64271[(8)] = inst_64246);

(statearr_64271[(9)] = inst_64244);

return statearr_64271;
})();
var statearr_64272_64285 = state_64269__$1;
(statearr_64272_64285[(2)] = null);

(statearr_64272_64285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (2))){
var inst_64246 = (state_64269[(8)]);
var inst_64252 = (state_64269[(10)]);
var inst_64251 = cljs.core.seq.call(null,inst_64246);
var inst_64252__$1 = cljs.core.first.call(null,inst_64251);
var inst_64253 = cljs.core.next.call(null,inst_64251);
var inst_64254 = (inst_64252__$1 == null);
var inst_64255 = cljs.core.not.call(null,inst_64254);
var state_64269__$1 = (function (){var statearr_64273 = state_64269;
(statearr_64273[(10)] = inst_64252__$1);

(statearr_64273[(11)] = inst_64253);

return statearr_64273;
})();
if(inst_64255){
var statearr_64274_64286 = state_64269__$1;
(statearr_64274_64286[(1)] = (4));

} else {
var statearr_64275_64287 = state_64269__$1;
(statearr_64275_64287[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (3))){
var inst_64267 = (state_64269[(2)]);
var state_64269__$1 = state_64269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64269__$1,inst_64267);
} else {
if((state_val_64270 === (4))){
var inst_64252 = (state_64269[(10)]);
var inst_64257 = figwheel.client.file_reloading.reload_js_file.call(null,inst_64252);
var state_64269__$1 = state_64269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64269__$1,(7),inst_64257);
} else {
if((state_val_64270 === (5))){
var inst_64263 = cljs.core.async.close_BANG_.call(null,out);
var state_64269__$1 = state_64269;
var statearr_64276_64288 = state_64269__$1;
(statearr_64276_64288[(2)] = inst_64263);

(statearr_64276_64288[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (6))){
var inst_64265 = (state_64269[(2)]);
var state_64269__$1 = state_64269;
var statearr_64277_64289 = state_64269__$1;
(statearr_64277_64289[(2)] = inst_64265);

(statearr_64277_64289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (7))){
var inst_64253 = (state_64269[(11)]);
var inst_64259 = (state_64269[(2)]);
var inst_64260 = cljs.core.async.put_BANG_.call(null,out,inst_64259);
var inst_64246 = inst_64253;
var state_64269__$1 = (function (){var statearr_64278 = state_64269;
(statearr_64278[(8)] = inst_64246);

(statearr_64278[(12)] = inst_64260);

return statearr_64278;
})();
var statearr_64279_64290 = state_64269__$1;
(statearr_64279_64290[(2)] = null);

(statearr_64279_64290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__58877__auto___64284,out))
;
return ((function (switch__58824__auto__,c__58877__auto___64284,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__58825__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__58825__auto____0 = (function (){
var statearr_64280 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64280[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__58825__auto__);

(statearr_64280[(1)] = (1));

return statearr_64280;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__58825__auto____1 = (function (state_64269){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_64269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e64281){if((e64281 instanceof Object)){
var ex__58828__auto__ = e64281;
var statearr_64282_64291 = state_64269;
(statearr_64282_64291[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64269);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64281;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64292 = state_64269;
state_64269 = G__64292;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__58825__auto__ = function(state_64269){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__58825__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__58825__auto____1.call(this,state_64269);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__58825__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__58825__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___64284,out))
})();
var state__58879__auto__ = (function (){var statearr_64283 = f__58878__auto__.call(null);
(statearr_64283[(6)] = c__58877__auto___64284);

return statearr_64283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___64284,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__64293,opts){
var map__64294 = p__64293;
var map__64294__$1 = ((((!((map__64294 == null)))?((((map__64294.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64294.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64294):map__64294);
var eval_body = cljs.core.get.call(null,map__64294__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__64294__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__54173__auto__ = eval_body;
if(cljs.core.truth_(and__54173__auto__)){
return typeof eval_body === 'string';
} else {
return and__54173__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e64296){var e = e64296;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__64297_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__64297_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__64298){
var vec__64299 = p__64298;
var k = cljs.core.nth.call(null,vec__64299,(0),null);
var v = cljs.core.nth.call(null,vec__64299,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__64302){
var vec__64303 = p__64302;
var k = cljs.core.nth.call(null,vec__64303,(0),null);
var v = cljs.core.nth.call(null,vec__64303,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__64309,p__64310){
var map__64311 = p__64309;
var map__64311__$1 = ((((!((map__64311 == null)))?((((map__64311.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64311.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64311):map__64311);
var opts = map__64311__$1;
var before_jsload = cljs.core.get.call(null,map__64311__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__64311__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__64311__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__64312 = p__64310;
var map__64312__$1 = ((((!((map__64312 == null)))?((((map__64312.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64312.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64312):map__64312);
var msg = map__64312__$1;
var files = cljs.core.get.call(null,map__64312__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__64312__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__64312__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__58877__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_64466){
var state_val_64467 = (state_64466[(1)]);
if((state_val_64467 === (7))){
var inst_64327 = (state_64466[(7)]);
var inst_64328 = (state_64466[(8)]);
var inst_64329 = (state_64466[(9)]);
var inst_64326 = (state_64466[(10)]);
var inst_64334 = cljs.core._nth.call(null,inst_64327,inst_64329);
var inst_64335 = figwheel.client.file_reloading.eval_body.call(null,inst_64334,opts);
var inst_64336 = (inst_64329 + (1));
var tmp64468 = inst_64327;
var tmp64469 = inst_64328;
var tmp64470 = inst_64326;
var inst_64326__$1 = tmp64470;
var inst_64327__$1 = tmp64468;
var inst_64328__$1 = tmp64469;
var inst_64329__$1 = inst_64336;
var state_64466__$1 = (function (){var statearr_64471 = state_64466;
(statearr_64471[(11)] = inst_64335);

(statearr_64471[(7)] = inst_64327__$1);

(statearr_64471[(8)] = inst_64328__$1);

(statearr_64471[(9)] = inst_64329__$1);

(statearr_64471[(10)] = inst_64326__$1);

return statearr_64471;
})();
var statearr_64472_64555 = state_64466__$1;
(statearr_64472_64555[(2)] = null);

(statearr_64472_64555[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (20))){
var inst_64369 = (state_64466[(12)]);
var inst_64377 = figwheel.client.file_reloading.sort_files.call(null,inst_64369);
var state_64466__$1 = state_64466;
var statearr_64473_64556 = state_64466__$1;
(statearr_64473_64556[(2)] = inst_64377);

(statearr_64473_64556[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (27))){
var state_64466__$1 = state_64466;
var statearr_64474_64557 = state_64466__$1;
(statearr_64474_64557[(2)] = null);

(statearr_64474_64557[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (1))){
var inst_64318 = (state_64466[(13)]);
var inst_64315 = before_jsload.call(null,files);
var inst_64316 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_64317 = (function (){return ((function (inst_64318,inst_64315,inst_64316,state_val_64467,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__64306_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__64306_SHARP_);
});
;})(inst_64318,inst_64315,inst_64316,state_val_64467,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_64318__$1 = cljs.core.filter.call(null,inst_64317,files);
var inst_64319 = cljs.core.not_empty.call(null,inst_64318__$1);
var state_64466__$1 = (function (){var statearr_64475 = state_64466;
(statearr_64475[(14)] = inst_64316);

(statearr_64475[(13)] = inst_64318__$1);

(statearr_64475[(15)] = inst_64315);

return statearr_64475;
})();
if(cljs.core.truth_(inst_64319)){
var statearr_64476_64558 = state_64466__$1;
(statearr_64476_64558[(1)] = (2));

} else {
var statearr_64477_64559 = state_64466__$1;
(statearr_64477_64559[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (24))){
var state_64466__$1 = state_64466;
var statearr_64478_64560 = state_64466__$1;
(statearr_64478_64560[(2)] = null);

(statearr_64478_64560[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (39))){
var inst_64419 = (state_64466[(16)]);
var state_64466__$1 = state_64466;
var statearr_64479_64561 = state_64466__$1;
(statearr_64479_64561[(2)] = inst_64419);

(statearr_64479_64561[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (46))){
var inst_64461 = (state_64466[(2)]);
var state_64466__$1 = state_64466;
var statearr_64480_64562 = state_64466__$1;
(statearr_64480_64562[(2)] = inst_64461);

(statearr_64480_64562[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (4))){
var inst_64363 = (state_64466[(2)]);
var inst_64364 = cljs.core.List.EMPTY;
var inst_64365 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_64364);
var inst_64366 = (function (){return ((function (inst_64363,inst_64364,inst_64365,state_val_64467,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__64307_SHARP_){
var and__54173__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__64307_SHARP_);
if(cljs.core.truth_(and__54173__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__64307_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__64307_SHARP_)));
} else {
return and__54173__auto__;
}
});
;})(inst_64363,inst_64364,inst_64365,state_val_64467,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_64367 = cljs.core.filter.call(null,inst_64366,files);
var inst_64368 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_64369 = cljs.core.concat.call(null,inst_64367,inst_64368);
var state_64466__$1 = (function (){var statearr_64481 = state_64466;
(statearr_64481[(12)] = inst_64369);

(statearr_64481[(17)] = inst_64363);

(statearr_64481[(18)] = inst_64365);

return statearr_64481;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_64482_64563 = state_64466__$1;
(statearr_64482_64563[(1)] = (16));

} else {
var statearr_64483_64564 = state_64466__$1;
(statearr_64483_64564[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (15))){
var inst_64353 = (state_64466[(2)]);
var state_64466__$1 = state_64466;
var statearr_64484_64565 = state_64466__$1;
(statearr_64484_64565[(2)] = inst_64353);

(statearr_64484_64565[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (21))){
var inst_64379 = (state_64466[(19)]);
var inst_64379__$1 = (state_64466[(2)]);
var inst_64380 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_64379__$1);
var state_64466__$1 = (function (){var statearr_64485 = state_64466;
(statearr_64485[(19)] = inst_64379__$1);

return statearr_64485;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64466__$1,(22),inst_64380);
} else {
if((state_val_64467 === (31))){
var inst_64464 = (state_64466[(2)]);
var state_64466__$1 = state_64466;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64466__$1,inst_64464);
} else {
if((state_val_64467 === (32))){
var inst_64419 = (state_64466[(16)]);
var inst_64424 = inst_64419.cljs$lang$protocol_mask$partition0$;
var inst_64425 = (inst_64424 & (64));
var inst_64426 = inst_64419.cljs$core$ISeq$;
var inst_64427 = (cljs.core.PROTOCOL_SENTINEL === inst_64426);
var inst_64428 = (inst_64425) || (inst_64427);
var state_64466__$1 = state_64466;
if(cljs.core.truth_(inst_64428)){
var statearr_64486_64566 = state_64466__$1;
(statearr_64486_64566[(1)] = (35));

} else {
var statearr_64487_64567 = state_64466__$1;
(statearr_64487_64567[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (40))){
var inst_64441 = (state_64466[(20)]);
var inst_64440 = (state_64466[(2)]);
var inst_64441__$1 = cljs.core.get.call(null,inst_64440,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_64442 = cljs.core.get.call(null,inst_64440,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_64443 = cljs.core.not_empty.call(null,inst_64441__$1);
var state_64466__$1 = (function (){var statearr_64488 = state_64466;
(statearr_64488[(20)] = inst_64441__$1);

(statearr_64488[(21)] = inst_64442);

return statearr_64488;
})();
if(cljs.core.truth_(inst_64443)){
var statearr_64489_64568 = state_64466__$1;
(statearr_64489_64568[(1)] = (41));

} else {
var statearr_64490_64569 = state_64466__$1;
(statearr_64490_64569[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (33))){
var state_64466__$1 = state_64466;
var statearr_64491_64570 = state_64466__$1;
(statearr_64491_64570[(2)] = false);

(statearr_64491_64570[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (13))){
var inst_64339 = (state_64466[(22)]);
var inst_64343 = cljs.core.chunk_first.call(null,inst_64339);
var inst_64344 = cljs.core.chunk_rest.call(null,inst_64339);
var inst_64345 = cljs.core.count.call(null,inst_64343);
var inst_64326 = inst_64344;
var inst_64327 = inst_64343;
var inst_64328 = inst_64345;
var inst_64329 = (0);
var state_64466__$1 = (function (){var statearr_64492 = state_64466;
(statearr_64492[(7)] = inst_64327);

(statearr_64492[(8)] = inst_64328);

(statearr_64492[(9)] = inst_64329);

(statearr_64492[(10)] = inst_64326);

return statearr_64492;
})();
var statearr_64493_64571 = state_64466__$1;
(statearr_64493_64571[(2)] = null);

(statearr_64493_64571[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (22))){
var inst_64383 = (state_64466[(23)]);
var inst_64379 = (state_64466[(19)]);
var inst_64382 = (state_64466[(24)]);
var inst_64387 = (state_64466[(25)]);
var inst_64382__$1 = (state_64466[(2)]);
var inst_64383__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_64382__$1);
var inst_64384 = (function (){var all_files = inst_64379;
var res_SINGLEQUOTE_ = inst_64382__$1;
var res = inst_64383__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_64383,inst_64379,inst_64382,inst_64387,inst_64382__$1,inst_64383__$1,state_val_64467,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__64308_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__64308_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_64383,inst_64379,inst_64382,inst_64387,inst_64382__$1,inst_64383__$1,state_val_64467,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_64385 = cljs.core.filter.call(null,inst_64384,inst_64382__$1);
var inst_64386 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_64387__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_64386);
var inst_64388 = cljs.core.not_empty.call(null,inst_64387__$1);
var state_64466__$1 = (function (){var statearr_64494 = state_64466;
(statearr_64494[(23)] = inst_64383__$1);

(statearr_64494[(24)] = inst_64382__$1);

(statearr_64494[(26)] = inst_64385);

(statearr_64494[(25)] = inst_64387__$1);

return statearr_64494;
})();
if(cljs.core.truth_(inst_64388)){
var statearr_64495_64572 = state_64466__$1;
(statearr_64495_64572[(1)] = (23));

} else {
var statearr_64496_64573 = state_64466__$1;
(statearr_64496_64573[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (36))){
var state_64466__$1 = state_64466;
var statearr_64497_64574 = state_64466__$1;
(statearr_64497_64574[(2)] = false);

(statearr_64497_64574[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (41))){
var inst_64441 = (state_64466[(20)]);
var inst_64445 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_64446 = cljs.core.map.call(null,inst_64445,inst_64441);
var inst_64447 = cljs.core.pr_str.call(null,inst_64446);
var inst_64448 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64447)].join('');
var inst_64449 = figwheel.client.utils.log.call(null,inst_64448);
var state_64466__$1 = state_64466;
var statearr_64498_64575 = state_64466__$1;
(statearr_64498_64575[(2)] = inst_64449);

(statearr_64498_64575[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (43))){
var inst_64442 = (state_64466[(21)]);
var inst_64452 = (state_64466[(2)]);
var inst_64453 = cljs.core.not_empty.call(null,inst_64442);
var state_64466__$1 = (function (){var statearr_64499 = state_64466;
(statearr_64499[(27)] = inst_64452);

return statearr_64499;
})();
if(cljs.core.truth_(inst_64453)){
var statearr_64500_64576 = state_64466__$1;
(statearr_64500_64576[(1)] = (44));

} else {
var statearr_64501_64577 = state_64466__$1;
(statearr_64501_64577[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (29))){
var inst_64383 = (state_64466[(23)]);
var inst_64379 = (state_64466[(19)]);
var inst_64382 = (state_64466[(24)]);
var inst_64385 = (state_64466[(26)]);
var inst_64419 = (state_64466[(16)]);
var inst_64387 = (state_64466[(25)]);
var inst_64415 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_64418 = (function (){var all_files = inst_64379;
var res_SINGLEQUOTE_ = inst_64382;
var res = inst_64383;
var files_not_loaded = inst_64385;
var dependencies_that_loaded = inst_64387;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_64383,inst_64379,inst_64382,inst_64385,inst_64419,inst_64387,inst_64415,state_val_64467,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__64417){
var map__64502 = p__64417;
var map__64502__$1 = ((((!((map__64502 == null)))?((((map__64502.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64502.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64502):map__64502);
var namespace = cljs.core.get.call(null,map__64502__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_64383,inst_64379,inst_64382,inst_64385,inst_64419,inst_64387,inst_64415,state_val_64467,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_64419__$1 = cljs.core.group_by.call(null,inst_64418,inst_64385);
var inst_64421 = (inst_64419__$1 == null);
var inst_64422 = cljs.core.not.call(null,inst_64421);
var state_64466__$1 = (function (){var statearr_64504 = state_64466;
(statearr_64504[(28)] = inst_64415);

(statearr_64504[(16)] = inst_64419__$1);

return statearr_64504;
})();
if(inst_64422){
var statearr_64505_64578 = state_64466__$1;
(statearr_64505_64578[(1)] = (32));

} else {
var statearr_64506_64579 = state_64466__$1;
(statearr_64506_64579[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (44))){
var inst_64442 = (state_64466[(21)]);
var inst_64455 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_64442);
var inst_64456 = cljs.core.pr_str.call(null,inst_64455);
var inst_64457 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64456)].join('');
var inst_64458 = figwheel.client.utils.log.call(null,inst_64457);
var state_64466__$1 = state_64466;
var statearr_64507_64580 = state_64466__$1;
(statearr_64507_64580[(2)] = inst_64458);

(statearr_64507_64580[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (6))){
var inst_64360 = (state_64466[(2)]);
var state_64466__$1 = state_64466;
var statearr_64508_64581 = state_64466__$1;
(statearr_64508_64581[(2)] = inst_64360);

(statearr_64508_64581[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (28))){
var inst_64385 = (state_64466[(26)]);
var inst_64412 = (state_64466[(2)]);
var inst_64413 = cljs.core.not_empty.call(null,inst_64385);
var state_64466__$1 = (function (){var statearr_64509 = state_64466;
(statearr_64509[(29)] = inst_64412);

return statearr_64509;
})();
if(cljs.core.truth_(inst_64413)){
var statearr_64510_64582 = state_64466__$1;
(statearr_64510_64582[(1)] = (29));

} else {
var statearr_64511_64583 = state_64466__$1;
(statearr_64511_64583[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (25))){
var inst_64383 = (state_64466[(23)]);
var inst_64399 = (state_64466[(2)]);
var inst_64400 = cljs.core.not_empty.call(null,inst_64383);
var state_64466__$1 = (function (){var statearr_64512 = state_64466;
(statearr_64512[(30)] = inst_64399);

return statearr_64512;
})();
if(cljs.core.truth_(inst_64400)){
var statearr_64513_64584 = state_64466__$1;
(statearr_64513_64584[(1)] = (26));

} else {
var statearr_64514_64585 = state_64466__$1;
(statearr_64514_64585[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (34))){
var inst_64435 = (state_64466[(2)]);
var state_64466__$1 = state_64466;
if(cljs.core.truth_(inst_64435)){
var statearr_64515_64586 = state_64466__$1;
(statearr_64515_64586[(1)] = (38));

} else {
var statearr_64516_64587 = state_64466__$1;
(statearr_64516_64587[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (17))){
var state_64466__$1 = state_64466;
var statearr_64517_64588 = state_64466__$1;
(statearr_64517_64588[(2)] = recompile_dependents);

(statearr_64517_64588[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (3))){
var state_64466__$1 = state_64466;
var statearr_64518_64589 = state_64466__$1;
(statearr_64518_64589[(2)] = null);

(statearr_64518_64589[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (12))){
var inst_64356 = (state_64466[(2)]);
var state_64466__$1 = state_64466;
var statearr_64519_64590 = state_64466__$1;
(statearr_64519_64590[(2)] = inst_64356);

(statearr_64519_64590[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (2))){
var inst_64318 = (state_64466[(13)]);
var inst_64325 = cljs.core.seq.call(null,inst_64318);
var inst_64326 = inst_64325;
var inst_64327 = null;
var inst_64328 = (0);
var inst_64329 = (0);
var state_64466__$1 = (function (){var statearr_64520 = state_64466;
(statearr_64520[(7)] = inst_64327);

(statearr_64520[(8)] = inst_64328);

(statearr_64520[(9)] = inst_64329);

(statearr_64520[(10)] = inst_64326);

return statearr_64520;
})();
var statearr_64521_64591 = state_64466__$1;
(statearr_64521_64591[(2)] = null);

(statearr_64521_64591[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (23))){
var inst_64383 = (state_64466[(23)]);
var inst_64379 = (state_64466[(19)]);
var inst_64382 = (state_64466[(24)]);
var inst_64385 = (state_64466[(26)]);
var inst_64387 = (state_64466[(25)]);
var inst_64390 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_64392 = (function (){var all_files = inst_64379;
var res_SINGLEQUOTE_ = inst_64382;
var res = inst_64383;
var files_not_loaded = inst_64385;
var dependencies_that_loaded = inst_64387;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_64383,inst_64379,inst_64382,inst_64385,inst_64387,inst_64390,state_val_64467,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__64391){
var map__64522 = p__64391;
var map__64522__$1 = ((((!((map__64522 == null)))?((((map__64522.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64522.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64522):map__64522);
var request_url = cljs.core.get.call(null,map__64522__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_64383,inst_64379,inst_64382,inst_64385,inst_64387,inst_64390,state_val_64467,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_64393 = cljs.core.reverse.call(null,inst_64387);
var inst_64394 = cljs.core.map.call(null,inst_64392,inst_64393);
var inst_64395 = cljs.core.pr_str.call(null,inst_64394);
var inst_64396 = figwheel.client.utils.log.call(null,inst_64395);
var state_64466__$1 = (function (){var statearr_64524 = state_64466;
(statearr_64524[(31)] = inst_64390);

return statearr_64524;
})();
var statearr_64525_64592 = state_64466__$1;
(statearr_64525_64592[(2)] = inst_64396);

(statearr_64525_64592[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (35))){
var state_64466__$1 = state_64466;
var statearr_64526_64593 = state_64466__$1;
(statearr_64526_64593[(2)] = true);

(statearr_64526_64593[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (19))){
var inst_64369 = (state_64466[(12)]);
var inst_64375 = figwheel.client.file_reloading.expand_files.call(null,inst_64369);
var state_64466__$1 = state_64466;
var statearr_64527_64594 = state_64466__$1;
(statearr_64527_64594[(2)] = inst_64375);

(statearr_64527_64594[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (11))){
var state_64466__$1 = state_64466;
var statearr_64528_64595 = state_64466__$1;
(statearr_64528_64595[(2)] = null);

(statearr_64528_64595[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (9))){
var inst_64358 = (state_64466[(2)]);
var state_64466__$1 = state_64466;
var statearr_64529_64596 = state_64466__$1;
(statearr_64529_64596[(2)] = inst_64358);

(statearr_64529_64596[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (5))){
var inst_64328 = (state_64466[(8)]);
var inst_64329 = (state_64466[(9)]);
var inst_64331 = (inst_64329 < inst_64328);
var inst_64332 = inst_64331;
var state_64466__$1 = state_64466;
if(cljs.core.truth_(inst_64332)){
var statearr_64530_64597 = state_64466__$1;
(statearr_64530_64597[(1)] = (7));

} else {
var statearr_64531_64598 = state_64466__$1;
(statearr_64531_64598[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (14))){
var inst_64339 = (state_64466[(22)]);
var inst_64348 = cljs.core.first.call(null,inst_64339);
var inst_64349 = figwheel.client.file_reloading.eval_body.call(null,inst_64348,opts);
var inst_64350 = cljs.core.next.call(null,inst_64339);
var inst_64326 = inst_64350;
var inst_64327 = null;
var inst_64328 = (0);
var inst_64329 = (0);
var state_64466__$1 = (function (){var statearr_64532 = state_64466;
(statearr_64532[(7)] = inst_64327);

(statearr_64532[(8)] = inst_64328);

(statearr_64532[(9)] = inst_64329);

(statearr_64532[(32)] = inst_64349);

(statearr_64532[(10)] = inst_64326);

return statearr_64532;
})();
var statearr_64533_64599 = state_64466__$1;
(statearr_64533_64599[(2)] = null);

(statearr_64533_64599[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (45))){
var state_64466__$1 = state_64466;
var statearr_64534_64600 = state_64466__$1;
(statearr_64534_64600[(2)] = null);

(statearr_64534_64600[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (26))){
var inst_64383 = (state_64466[(23)]);
var inst_64379 = (state_64466[(19)]);
var inst_64382 = (state_64466[(24)]);
var inst_64385 = (state_64466[(26)]);
var inst_64387 = (state_64466[(25)]);
var inst_64402 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_64404 = (function (){var all_files = inst_64379;
var res_SINGLEQUOTE_ = inst_64382;
var res = inst_64383;
var files_not_loaded = inst_64385;
var dependencies_that_loaded = inst_64387;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_64383,inst_64379,inst_64382,inst_64385,inst_64387,inst_64402,state_val_64467,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__64403){
var map__64535 = p__64403;
var map__64535__$1 = ((((!((map__64535 == null)))?((((map__64535.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64535.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64535):map__64535);
var namespace = cljs.core.get.call(null,map__64535__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__64535__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_64383,inst_64379,inst_64382,inst_64385,inst_64387,inst_64402,state_val_64467,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_64405 = cljs.core.map.call(null,inst_64404,inst_64383);
var inst_64406 = cljs.core.pr_str.call(null,inst_64405);
var inst_64407 = figwheel.client.utils.log.call(null,inst_64406);
var inst_64408 = (function (){var all_files = inst_64379;
var res_SINGLEQUOTE_ = inst_64382;
var res = inst_64383;
var files_not_loaded = inst_64385;
var dependencies_that_loaded = inst_64387;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_64383,inst_64379,inst_64382,inst_64385,inst_64387,inst_64402,inst_64404,inst_64405,inst_64406,inst_64407,state_val_64467,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_64383,inst_64379,inst_64382,inst_64385,inst_64387,inst_64402,inst_64404,inst_64405,inst_64406,inst_64407,state_val_64467,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_64409 = setTimeout(inst_64408,(10));
var state_64466__$1 = (function (){var statearr_64537 = state_64466;
(statearr_64537[(33)] = inst_64407);

(statearr_64537[(34)] = inst_64402);

return statearr_64537;
})();
var statearr_64538_64601 = state_64466__$1;
(statearr_64538_64601[(2)] = inst_64409);

(statearr_64538_64601[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (16))){
var state_64466__$1 = state_64466;
var statearr_64539_64602 = state_64466__$1;
(statearr_64539_64602[(2)] = reload_dependents);

(statearr_64539_64602[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (38))){
var inst_64419 = (state_64466[(16)]);
var inst_64437 = cljs.core.apply.call(null,cljs.core.hash_map,inst_64419);
var state_64466__$1 = state_64466;
var statearr_64540_64603 = state_64466__$1;
(statearr_64540_64603[(2)] = inst_64437);

(statearr_64540_64603[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (30))){
var state_64466__$1 = state_64466;
var statearr_64541_64604 = state_64466__$1;
(statearr_64541_64604[(2)] = null);

(statearr_64541_64604[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (10))){
var inst_64339 = (state_64466[(22)]);
var inst_64341 = cljs.core.chunked_seq_QMARK_.call(null,inst_64339);
var state_64466__$1 = state_64466;
if(inst_64341){
var statearr_64542_64605 = state_64466__$1;
(statearr_64542_64605[(1)] = (13));

} else {
var statearr_64543_64606 = state_64466__$1;
(statearr_64543_64606[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (18))){
var inst_64373 = (state_64466[(2)]);
var state_64466__$1 = state_64466;
if(cljs.core.truth_(inst_64373)){
var statearr_64544_64607 = state_64466__$1;
(statearr_64544_64607[(1)] = (19));

} else {
var statearr_64545_64608 = state_64466__$1;
(statearr_64545_64608[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (42))){
var state_64466__$1 = state_64466;
var statearr_64546_64609 = state_64466__$1;
(statearr_64546_64609[(2)] = null);

(statearr_64546_64609[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (37))){
var inst_64432 = (state_64466[(2)]);
var state_64466__$1 = state_64466;
var statearr_64547_64610 = state_64466__$1;
(statearr_64547_64610[(2)] = inst_64432);

(statearr_64547_64610[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (8))){
var inst_64339 = (state_64466[(22)]);
var inst_64326 = (state_64466[(10)]);
var inst_64339__$1 = cljs.core.seq.call(null,inst_64326);
var state_64466__$1 = (function (){var statearr_64548 = state_64466;
(statearr_64548[(22)] = inst_64339__$1);

return statearr_64548;
})();
if(inst_64339__$1){
var statearr_64549_64611 = state_64466__$1;
(statearr_64549_64611[(1)] = (10));

} else {
var statearr_64550_64612 = state_64466__$1;
(statearr_64550_64612[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__58824__auto__,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__58825__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__58825__auto____0 = (function (){
var statearr_64551 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64551[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__58825__auto__);

(statearr_64551[(1)] = (1));

return statearr_64551;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__58825__auto____1 = (function (state_64466){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_64466);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e64552){if((e64552 instanceof Object)){
var ex__58828__auto__ = e64552;
var statearr_64553_64613 = state_64466;
(statearr_64553_64613[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64466);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64552;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64614 = state_64466;
state_64466 = G__64614;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__58825__auto__ = function(state_64466){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__58825__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__58825__auto____1.call(this,state_64466);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__58825__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__58825__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__58879__auto__ = (function (){var statearr_64554 = f__58878__auto__.call(null);
(statearr_64554[(6)] = c__58877__auto__);

return statearr_64554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto__,map__64311,map__64311__$1,opts,before_jsload,on_jsload,reload_dependents,map__64312,map__64312__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__58877__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__64617,link){
var map__64618 = p__64617;
var map__64618__$1 = ((((!((map__64618 == null)))?((((map__64618.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64618.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64618):map__64618);
var file = cljs.core.get.call(null,map__64618__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__64618,map__64618__$1,file){
return (function (p1__64615_SHARP_,p2__64616_SHARP_){
if(cljs.core._EQ_.call(null,p1__64615_SHARP_,p2__64616_SHARP_)){
return p1__64615_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__64618,map__64618__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__64621){
var map__64622 = p__64621;
var map__64622__$1 = ((((!((map__64622 == null)))?((((map__64622.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64622.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64622):map__64622);
var match_length = cljs.core.get.call(null,map__64622__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__64622__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__64620_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__64620_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__64624_SHARP_,p2__64625_SHARP_){
return cljs.core.assoc.call(null,p1__64624_SHARP_,cljs.core.get.call(null,p2__64625_SHARP_,key),p2__64625_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_64626 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_64626);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_64626);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__64627,p__64628){
var map__64629 = p__64627;
var map__64629__$1 = ((((!((map__64629 == null)))?((((map__64629.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64629.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64629):map__64629);
var on_cssload = cljs.core.get.call(null,map__64629__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__64630 = p__64628;
var map__64630__$1 = ((((!((map__64630 == null)))?((((map__64630.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64630.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64630):map__64630);
var files_msg = map__64630__$1;
var files = cljs.core.get.call(null,map__64630__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1518787490435
