// Compiled by ClojureScript 1.9.908 {}
goog.provide('chord.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('chord.channels');
goog.require('chord.format');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((function (){var and__54173__auto__ = typeof require !== 'undefined';
if(and__54173__auto__){
try{return require("ws");
}catch (e63505){var e = e63505;
return false;
}} else {
return and__54173__auto__;
}
})())){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js.call(null,opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__55361__auto__ = [];
var len__55354__auto___63617 = arguments.length;
var i__55355__auto___63618 = (0);
while(true){
if((i__55355__auto___63618 < len__55354__auto___63617)){
args__55361__auto__.push((arguments[i__55355__auto___63618]));

var G__63619 = (i__55355__auto___63618 + (1));
i__55355__auto___63618 = G__63619;
continue;
} else {
}
break;
}

var argseq__55362__auto__ = ((((1) < args__55361__auto__.length))?(new cljs.core.IndexedSeq(args__55361__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__55362__auto__);
});

chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__63510){
var vec__63511 = p__63510;
var map__63514 = cljs.core.nth.call(null,vec__63511,(0),null);
var map__63514__$1 = ((((!((map__63514 == null)))?((((map__63514.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63514.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63514):map__63514);
var opts = map__63514__$1;
var read_ch = cljs.core.get.call(null,map__63514__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.call(null,map__63514__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.call(null,map__63514__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.call(null,map__63514__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws.call(null,ws_url,ws_opts);
var map__63516 = chord.format.wrap_format.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__54185__auto__ = read_ch;
if(cljs.core.truth_(or__54185__auto__)){
return or__54185__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__54185__auto__ = write_ch;
if(cljs.core.truth_(or__54185__auto__)){
return or__54185__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})()], null),opts);
var map__63516__$1 = ((((!((map__63516 == null)))?((((map__63516.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63516.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63516):map__63516);
var read_ch__$1 = cljs.core.get.call(null,map__63516__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.call(null,map__63516__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.call(null);
var close_ch = cljs.core.async.chan.call(null);
web_socket.binaryType = "arraybuffer";

chord.channels.read_from_ws_BANG_.call(null,web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_.call(null,web_socket,write_ch__$1);

web_socket.onopen = ((function (web_socket,map__63516,map__63516__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__63511,map__63514,map__63514__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (p1__63506_SHARP_){
return cljs.core.async.put_BANG_.call(null,open_ch,p1__63506_SHARP_);
});})(web_socket,map__63516,map__63516__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__63511,map__63514,map__63514__$1,opts,read_ch,write_ch,format,ws_opts))
;

web_socket.onclose = ((function (web_socket,map__63516,map__63516__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__63511,map__63514,map__63514__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (p1__63507_SHARP_){
return cljs.core.async.put_BANG_.call(null,close_ch,p1__63507_SHARP_);
});})(web_socket,map__63516,map__63516__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__63511,map__63514,map__63514__$1,opts,read_ch,write_ch,format,ws_opts))
;

var ws_chan = chord.channels.bidi_ch.call(null,read_ch__$1,write_ch__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),((function (web_socket,map__63516,map__63516__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__63511,map__63514,map__63514__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (){
return web_socket.close();
});})(web_socket,map__63516,map__63516__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__63511,map__63514,map__63514__$1,opts,read_ch,write_ch,format,ws_opts))
], null));
var initial_ch = cljs.core.async.chan.call(null);
var c__58877__auto___63620 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__58877__auto___63620,ws_chan,initial_ch,web_socket,map__63516,map__63516__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__63511,map__63514,map__63514__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (){
var f__58878__auto__ = (function (){var switch__58824__auto__ = ((function (c__58877__auto___63620,ws_chan,initial_ch,web_socket,map__63516,map__63516__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__63511,map__63514,map__63514__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (state_63583){
var state_val_63584 = (state_63583[(1)]);
if((state_val_63584 === (7))){
var inst_63579 = (state_63583[(2)]);
var state_63583__$1 = state_63583;
var statearr_63585_63621 = state_63583__$1;
(statearr_63585_63621[(2)] = inst_63579);

(statearr_63585_63621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (20))){
var state_63583__$1 = state_63583;
var statearr_63586_63622 = state_63583__$1;
(statearr_63586_63622[(2)] = null);

(statearr_63586_63622[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (1))){
var inst_63518 = false;
var state_63583__$1 = (function (){var statearr_63587 = state_63583;
(statearr_63587[(7)] = inst_63518);

return statearr_63587;
})();
var statearr_63588_63623 = state_63583__$1;
(statearr_63588_63623[(2)] = null);

(statearr_63588_63623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (4))){
var inst_63533 = (state_63583[(8)]);
var inst_63531 = (state_63583[(9)]);
var inst_63531__$1 = (state_63583[(2)]);
var inst_63532 = cljs.core.nth.call(null,inst_63531__$1,(0),null);
var inst_63533__$1 = cljs.core.nth.call(null,inst_63531__$1,(1),null);
var inst_63534 = cljs.core._EQ_.call(null,inst_63533__$1,open_ch);
var state_63583__$1 = (function (){var statearr_63589 = state_63583;
(statearr_63589[(8)] = inst_63533__$1);

(statearr_63589[(10)] = inst_63532);

(statearr_63589[(9)] = inst_63531__$1);

return statearr_63589;
})();
if(inst_63534){
var statearr_63590_63624 = state_63583__$1;
(statearr_63590_63624[(1)] = (5));

} else {
var statearr_63591_63625 = state_63583__$1;
(statearr_63591_63625[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (15))){
var inst_63564 = (state_63583[(2)]);
var state_63583__$1 = state_63583;
var statearr_63592_63626 = state_63583__$1;
(statearr_63592_63626[(2)] = inst_63564);

(statearr_63592_63626[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (21))){
var inst_63575 = (state_63583[(2)]);
var state_63583__$1 = state_63583;
var statearr_63593_63627 = state_63583__$1;
(statearr_63593_63627[(2)] = inst_63575);

(statearr_63593_63627[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (13))){
var state_63583__$1 = state_63583;
var statearr_63594_63628 = state_63583__$1;
(statearr_63594_63628[(2)] = null);

(statearr_63594_63628[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (6))){
var inst_63533 = (state_63583[(8)]);
var inst_63548 = cljs.core._EQ_.call(null,inst_63533,close_ch);
var state_63583__$1 = state_63583;
if(inst_63548){
var statearr_63595_63629 = state_63583__$1;
(statearr_63595_63629[(1)] = (9));

} else {
var statearr_63596_63630 = state_63583__$1;
(statearr_63596_63630[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (17))){
var state_63583__$1 = state_63583;
var statearr_63597_63631 = state_63583__$1;
(statearr_63597_63631[(2)] = initial_ch);

(statearr_63597_63631[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (3))){
var inst_63581 = (state_63583[(2)]);
var state_63583__$1 = state_63583;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63583__$1,inst_63581);
} else {
if((state_val_63584 === (12))){
var inst_63518 = (state_63583[(7)]);
var state_63583__$1 = state_63583;
if(cljs.core.truth_(inst_63518)){
var statearr_63598_63632 = state_63583__$1;
(statearr_63598_63632[(1)] = (16));

} else {
var statearr_63599_63633 = state_63583__$1;
(statearr_63599_63633[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (2))){
var inst_63527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63528 = [open_ch,close_ch];
var inst_63529 = (new cljs.core.PersistentVector(null,2,(5),inst_63527,inst_63528,null));
var state_63583__$1 = state_63583;
return cljs.core.async.ioc_alts_BANG_.call(null,state_63583__$1,(4),inst_63529);
} else {
if((state_val_63584 === (19))){
var inst_63532 = (state_63583[(10)]);
var state_63583__$1 = state_63583;
var statearr_63600_63634 = state_63583__$1;
(statearr_63600_63634[(2)] = inst_63532);

(statearr_63600_63634[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (11))){
var inst_63577 = (state_63583[(2)]);
var state_63583__$1 = state_63583;
var statearr_63601_63635 = state_63583__$1;
(statearr_63601_63635[(2)] = inst_63577);

(statearr_63601_63635[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (9))){
var inst_63554 = (state_63583[(11)]);
var inst_63531 = (state_63583[(9)]);
var inst_63553 = cljs.core.nth.call(null,inst_63531,(0),null);
var inst_63554__$1 = chord.client.close_event__GT_maybe_error.call(null,inst_63553);
var state_63583__$1 = (function (){var statearr_63602 = state_63583;
(statearr_63602[(11)] = inst_63554__$1);

return statearr_63602;
})();
if(cljs.core.truth_(inst_63554__$1)){
var statearr_63603_63636 = state_63583__$1;
(statearr_63603_63636[(1)] = (12));

} else {
var statearr_63604_63637 = state_63583__$1;
(statearr_63604_63637[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (5))){
var inst_63531 = (state_63583[(9)]);
var inst_63539 = cljs.core.nth.call(null,inst_63531,(0),null);
var inst_63540 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_63541 = [ws_chan];
var inst_63542 = cljs.core.PersistentHashMap.fromArrays(inst_63540,inst_63541);
var state_63583__$1 = (function (){var statearr_63605 = state_63583;
(statearr_63605[(12)] = inst_63539);

return statearr_63605;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_63583__$1,(8),initial_ch,inst_63542);
} else {
if((state_val_63584 === (14))){
var inst_63567 = (state_63583[(2)]);
var inst_63568 = cljs.core.async.close_BANG_.call(null,ws_chan);
var inst_63569 = cljs.core.async.close_BANG_.call(null,initial_ch);
var state_63583__$1 = (function (){var statearr_63606 = state_63583;
(statearr_63606[(13)] = inst_63568);

(statearr_63606[(14)] = inst_63567);

return statearr_63606;
})();
var statearr_63607_63638 = state_63583__$1;
(statearr_63607_63638[(2)] = inst_63569);

(statearr_63607_63638[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (16))){
var state_63583__$1 = state_63583;
var statearr_63608_63639 = state_63583__$1;
(statearr_63608_63639[(2)] = read_ch__$1);

(statearr_63608_63639[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (10))){
var inst_63533 = (state_63583[(8)]);
var inst_63571 = cljs.core._EQ_.call(null,inst_63533,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_63583__$1 = state_63583;
if(inst_63571){
var statearr_63609_63640 = state_63583__$1;
(statearr_63609_63640[(1)] = (19));

} else {
var statearr_63610_63641 = state_63583__$1;
(statearr_63610_63641[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (18))){
var inst_63554 = (state_63583[(11)]);
var inst_63559 = (state_63583[(2)]);
var inst_63560 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63561 = [inst_63554];
var inst_63562 = cljs.core.PersistentHashMap.fromArrays(inst_63560,inst_63561);
var state_63583__$1 = state_63583;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_63583__$1,(15),inst_63559,inst_63562);
} else {
if((state_val_63584 === (8))){
var inst_63544 = (state_63583[(2)]);
var inst_63545 = cljs.core.async.close_BANG_.call(null,initial_ch);
var inst_63518 = true;
var state_63583__$1 = (function (){var statearr_63611 = state_63583;
(statearr_63611[(15)] = inst_63544);

(statearr_63611[(7)] = inst_63518);

(statearr_63611[(16)] = inst_63545);

return statearr_63611;
})();
var statearr_63612_63642 = state_63583__$1;
(statearr_63612_63642[(2)] = null);

(statearr_63612_63642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__58877__auto___63620,ws_chan,initial_ch,web_socket,map__63516,map__63516__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__63511,map__63514,map__63514__$1,opts,read_ch,write_ch,format,ws_opts))
;
return ((function (switch__58824__auto__,c__58877__auto___63620,ws_chan,initial_ch,web_socket,map__63516,map__63516__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__63511,map__63514,map__63514__$1,opts,read_ch,write_ch,format,ws_opts){
return (function() {
var chord$client$state_machine__58825__auto__ = null;
var chord$client$state_machine__58825__auto____0 = (function (){
var statearr_63613 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63613[(0)] = chord$client$state_machine__58825__auto__);

(statearr_63613[(1)] = (1));

return statearr_63613;
});
var chord$client$state_machine__58825__auto____1 = (function (state_63583){
while(true){
var ret_value__58826__auto__ = (function (){try{while(true){
var result__58827__auto__ = switch__58824__auto__.call(null,state_63583);
if(cljs.core.keyword_identical_QMARK_.call(null,result__58827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__58827__auto__;
}
break;
}
}catch (e63614){if((e63614 instanceof Object)){
var ex__58828__auto__ = e63614;
var statearr_63615_63643 = state_63583;
(statearr_63615_63643[(5)] = ex__58828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63583);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63614;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__58826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63644 = state_63583;
state_63583 = G__63644;
continue;
} else {
return ret_value__58826__auto__;
}
break;
}
});
chord$client$state_machine__58825__auto__ = function(state_63583){
switch(arguments.length){
case 0:
return chord$client$state_machine__58825__auto____0.call(this);
case 1:
return chord$client$state_machine__58825__auto____1.call(this,state_63583);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
chord$client$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__58825__auto____0;
chord$client$state_machine__58825__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__58825__auto____1;
return chord$client$state_machine__58825__auto__;
})()
;})(switch__58824__auto__,c__58877__auto___63620,ws_chan,initial_ch,web_socket,map__63516,map__63516__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__63511,map__63514,map__63514__$1,opts,read_ch,write_ch,format,ws_opts))
})();
var state__58879__auto__ = (function (){var statearr_63616 = f__58878__auto__.call(null);
(statearr_63616[(6)] = c__58877__auto___63620);

return statearr_63616;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__58879__auto__);
});})(c__58877__auto___63620,ws_chan,initial_ch,web_socket,map__63516,map__63516__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__63511,map__63514,map__63514__$1,opts,read_ch,write_ch,format,ws_opts))
);


return initial_ch;
});

chord.client.ws_ch.cljs$lang$maxFixedArity = (1);

chord.client.ws_ch.cljs$lang$applyTo = (function (seq63508){
var G__63509 = cljs.core.first.call(null,seq63508);
var seq63508__$1 = cljs.core.next.call(null,seq63508);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(G__63509,seq63508__$1);
});


//# sourceMappingURL=client.js.map?rel=1518787489282
