(ns leiningen.give-me-my-css
  (:require [clojure.java.io :as io])
  (:import java.lang.ProcessBuilder))

(defn sass [input output mode]
  (println "building sass/scss")
  (let [dir (.getAbsolutePath (io/file ""))
        command-arg (case mode
                      "watch" "--watch"
                      "--update")
        args ["docker" "run" "--rm"
              "-v" (format "%s:/app" dir)
              "ubuntudesign/sass" "sass" command-arg
              (format "/app/%s:/app/%s" input output)
              "--sourcemap"
              "-C"]
        pb (ProcessBuilder. args)
        _ (.inheritIO pb)
        proc (.start pb)]
    (.waitFor proc)
    (println "build finished")
    (System/exit (.exitValue proc))))

(defn give-me-my-css
  "I don't do a lot."
  [{{:keys [input output] } :give-me-my-css} & [mode]]
  (sass input output mode))
